/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.crud;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import info.archinnov.achilles.internals.cache.CacheKey;
import info.archinnov.achilles.internals.dsl.LWTHelper;
import info.archinnov.achilles.internals.dsl.StatementProvider;
import info.archinnov.achilles.internals.dsl.action.MutationAction;
import info.archinnov.achilles.internals.dsl.options.AbstractOptionsForUpdateOrDelete;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.BoundStatementWrapper;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteByPartitionWithOptions<ENTITY>
extends AbstractOptionsForUpdateOrDelete<DeleteByPartitionWithOptions<ENTITY>>
implements MutationAction,
StatementProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteByPartitionWithOptions.class);
    private final AbstractEntityProperty<ENTITY> meta;
    private final RuntimeEngine rte;
    private final Object[] partitionKeys;
    private final Object[] encodedPartitionKeys;
    private final CassandraOptions options;

    public DeleteByPartitionWithOptions(AbstractEntityProperty<ENTITY> meta, RuntimeEngine rte, Object[] partitionKeys, Object[] encodedPartitionKeys, Optional<CassandraOptions> cassandraOptions) {
        this.meta = meta;
        this.rte = rte;
        this.partitionKeys = partitionKeys;
        this.encodedPartitionKeys = encodedPartitionKeys;
        this.options = cassandraOptions.orElse(new CassandraOptions());
    }

    @Override
    public CompletableFuture<ExecutionInfo> executeAsyncWithStats() {
        StatementWrapper statementWrapper = this.getInternalBoundStatementWrapper();
        String queryString = statementWrapper.getBoundStatement().preparedStatement().getQueryString();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Execute delete async with execution info : %s", queryString));
        }
        CompletableFuture<ResultSet> cfutureRS = this.rte.execute(statementWrapper);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)cfutureRS.thenApply(this.options::resultSetAsyncListener)).thenApply(statementWrapper::logTrace)).thenApply(x -> LWTHelper.triggerLWTListeners(this.lwtResultListeners, x, queryString))).thenApply(x -> x.getExecutionInfo());
    }

    @Override
    protected CassandraOptions getOptions() {
        return this.options;
    }

    @Override
    public BoundStatement generateAndGetBoundStatement() {
        return this.getInternalBoundStatementWrapper().getBoundStatement();
    }

    @Override
    public String getStatementAsString() {
        return this.rte.getStaticCache(new CacheKey(this.meta.entityClass, CacheKey.Operation.DELETE_BY_PARTITION)).getQueryString();
    }

    @Override
    public List<Object> getBoundValues() {
        return Arrays.asList(this.partitionKeys);
    }

    @Override
    public List<Object> getEncodedBoundValues() {
        return Arrays.asList(this.encodedPartitionKeys);
    }

    @Override
    protected DeleteByPartitionWithOptions<ENTITY> getThis() {
        return this;
    }

    private StatementWrapper getInternalBoundStatementWrapper() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Get bound statement wrapper", new Object[0]));
        }
        PreparedStatement ps = CacheKey.Operation.DELETE_BY_PARTITION.getPreparedStatement(this.rte, this.meta, this.options);
        BoundStatementWrapper statementWrapper = new BoundStatementWrapper(OperationType.DELETE, this.meta, ps, this.partitionKeys, this.encodedPartitionKeys);
        statementWrapper.applyOptions(this.options);
        return statementWrapper;
    }
}

