/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.crud;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import info.archinnov.achilles.internals.cache.CacheKey;
import info.archinnov.achilles.internals.dsl.LWTHelper;
import info.archinnov.achilles.internals.dsl.StatementProvider;
import info.archinnov.achilles.internals.dsl.action.MutationAction;
import info.archinnov.achilles.internals.dsl.options.AbstractOptionsForUpdateOrDelete;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.BoundStatementWrapper;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import info.archinnov.achilles.type.interceptor.Event;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteWithOptions<ENTITY>
extends AbstractOptionsForUpdateOrDelete<DeleteWithOptions<ENTITY>>
implements MutationAction,
StatementProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteWithOptions.class);
    private final Class<ENTITY> entityClass;
    private final AbstractEntityProperty<ENTITY> meta;
    private final RuntimeEngine rte;
    private Object[] primaryKeyValues;
    private Object[] encodedPrimaryKeyValues;
    private final Optional<ENTITY> instance;
    private final CassandraOptions options;
    private Optional<Boolean> ifExists = Optional.empty();

    public DeleteWithOptions(Class<ENTITY> entityClass, AbstractEntityProperty<ENTITY> meta, RuntimeEngine rte, Object[] primaryKeyValues, Object[] encodedPrimaryKeyValues, Optional<ENTITY> instance, Optional<CassandraOptions> cassandraOptions) {
        this.entityClass = entityClass;
        this.meta = meta;
        this.rte = rte;
        this.primaryKeyValues = primaryKeyValues;
        this.encodedPrimaryKeyValues = encodedPrimaryKeyValues;
        this.instance = instance;
        this.options = cassandraOptions.orElse(new CassandraOptions());
    }

    @Override
    public CompletableFuture<ExecutionInfo> executeAsyncWithStats() {
        if (this.instance.isPresent()) {
            ENTITY entity = this.instance.get();
            this.meta.triggerInterceptorsForEvent(Event.PRE_DELETE, entity);
        }
        StatementWrapper statementWrapper = this.getInternalBoundStatementWrapper();
        String queryString = statementWrapper.getBoundStatement().preparedStatement().getQueryString();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Execute delete async with execution info : %s", queryString));
        }
        CompletableFuture<ResultSet> cfutureRS = this.rte.execute(statementWrapper);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)cfutureRS.thenApply(this.options::resultSetAsyncListener)).thenApply(statementWrapper::logTrace)).thenApply(x -> LWTHelper.triggerLWTListeners(this.lwtResultListeners, x, queryString))).thenApply(x -> x.getExecutionInfo())).thenApply(x -> {
            if (this.instance.isPresent()) {
                this.meta.triggerInterceptorsForEvent(Event.POST_DELETE, this.instance.get());
            }
            return x;
        });
    }

    @Override
    protected CassandraOptions getOptions() {
        return this.options;
    }

    @Override
    public BoundStatement generateAndGetBoundStatement() {
        return this.getInternalBoundStatementWrapper().getBoundStatement();
    }

    @Override
    public String getStatementAsString() {
        return this.rte.getStaticCache(new CacheKey(this.entityClass, CacheKey.Operation.DELETE)).getQueryString();
    }

    @Override
    public List<Object> getBoundValues() {
        return Arrays.asList(this.primaryKeyValues);
    }

    @Override
    public List<Object> getEncodedBoundValues() {
        return Arrays.asList(this.encodedPrimaryKeyValues);
    }

    @Override
    protected DeleteWithOptions<ENTITY> getThis() {
        return this;
    }

    private StatementWrapper getInternalBoundStatementWrapper() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Generate bound statement wrapper", new Object[0]));
        }
        PreparedStatement ps = this.getInternalPreparedStatement();
        BoundStatementWrapper statementWrapper = new BoundStatementWrapper(OperationType.DELETE, this.meta, ps, this.primaryKeyValues, this.encodedPrimaryKeyValues);
        statementWrapper.applyOptions(this.options);
        return statementWrapper;
    }

    private PreparedStatement getInternalPreparedStatement() {
        if (this.ifExists.isPresent() && this.ifExists.get().booleanValue()) {
            return CacheKey.Operation.DELETE_IF_EXISTS.getPreparedStatement(this.rte, this.meta, this.options);
        }
        return CacheKey.Operation.DELETE.getPreparedStatement(this.rte, this.meta, this.options);
    }

    public DeleteWithOptions<ENTITY> ifExists(boolean ifExists) {
        this.ifExists = Optional.of(ifExists);
        return this;
    }

    public DeleteWithOptions<ENTITY> ifExists() {
        this.ifExists = Optional.of(true);
        return this;
    }
}

