/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.options;

import info.archinnov.achilles.internals.dsl.options.AbstractOptionsForSelect;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.type.lightweighttransaction.LWTResultListener;
import info.archinnov.achilles.type.strategy.InsertStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptionsForCRUDUpdate<T extends AbstractOptionsForCRUDUpdate<T>>
extends AbstractOptionsForSelect<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOptionsForCRUDUpdate.class);
    protected InsertStrategy insertStrategy = InsertStrategy.NOT_NULL_FIELDS;
    protected Optional<Boolean> ifExists = Optional.empty();
    protected Optional<List<LWTResultListener>> lwtResultListeners = Optional.empty();

    public T ifExists(boolean ifExists) {
        this.ifExists = Optional.of(ifExists);
        return (T)((AbstractOptionsForCRUDUpdate)this.getThis());
    }

    public T ifExists() {
        this.ifExists = Optional.of(true);
        return (T)((AbstractOptionsForCRUDUpdate)this.getThis());
    }

    public T withLwtResultListeners(List<LWTResultListener> lwtResultListeners) {
        this.lwtResultListeners = Optional.of(lwtResultListeners);
        return (T)((AbstractOptionsForCRUDUpdate)this.getThis());
    }

    public T withLwtResultListener(LWTResultListener lwtResultListener) {
        this.lwtResultListeners = Optional.of(Arrays.asList(lwtResultListener));
        return (T)((AbstractOptionsForCRUDUpdate)this.getThis());
    }

    public T usingTimestamp(long timestamp) {
        this.getOptions().setDefaultTimestamp(Optional.of(timestamp));
        return (T)((AbstractOptionsForCRUDUpdate)this.getThis());
    }

    public T usingTimeToLive(int timeToLive) {
        this.getOptions().setTimeToLive(Optional.of(timeToLive));
        return (T)((AbstractOptionsForCRUDUpdate)this.getThis());
    }

    public InsertStrategy getOverridenStrategy(AbstractEntityProperty<?> property) {
        InsertStrategy insertStrategy = this.insertStrategy;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Get runtime insert strategy for entity %s : %s", property.entityClass.getCanonicalName(), insertStrategy.name()));
        }
        return insertStrategy;
    }
}

