/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.options;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.policies.RetryPolicy;
import info.archinnov.achilles.internals.options.CassandraOptions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractOptionsForSelect<T extends AbstractOptionsForSelect<T>> {
    protected abstract T getThis();

    protected abstract CassandraOptions getOptions();

    public T withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.getOptions().setCl(Optional.of(consistencyLevel));
        return this.getThis();
    }

    public T withOptionalConsistencyLevel(Optional<ConsistencyLevel> consistencyLevel) {
        this.getOptions().setCl(consistencyLevel);
        return this.getThis();
    }

    public T withSerialConsistencyLevel(ConsistencyLevel serialConsistencyLevel) {
        this.getOptions().setSerialCL(Optional.of(serialConsistencyLevel));
        return this.getThis();
    }

    public T withOptionalSerialConsistencyLevel(Optional<ConsistencyLevel> serialConsistencyLevel) {
        this.getOptions().setSerialCL(serialConsistencyLevel);
        return this.getThis();
    }

    public T withFetchSize(int fetchSize) {
        this.getOptions().setFetchSize(Optional.of(fetchSize));
        return this.getThis();
    }

    public T isIdempotent() {
        this.getOptions().setIdempotent(Optional.of(true));
        return this.getThis();
    }

    public T isIdempotent(boolean idempotent) {
        this.getOptions().setIdempotent(Optional.of(idempotent));
        return this.getThis();
    }

    public T withOutgoingPayload(Map<String, ByteBuffer> outgoingPayload) {
        this.getOptions().setOutgoingPayLoad(Optional.of(outgoingPayload));
        return this.getThis();
    }

    public T withOptionalOutgoingPayload(Optional<Map<String, ByteBuffer>> outgoingPayload) {
        this.getOptions().setOutgoingPayLoad(outgoingPayload);
        return this.getThis();
    }

    public T withPagingState(PagingState pagingState) {
        this.getOptions().setPagingState(Optional.of(pagingState));
        return this.getThis();
    }

    public T withPagingState(String pagingState) {
        this.getOptions().setPagingState(Optional.of(PagingState.fromString((String)pagingState)));
        return this.getThis();
    }

    public T withOptionalPagingState(Optional<PagingState> pagingState) {
        this.getOptions().setPagingState(pagingState);
        return this.getThis();
    }

    public T withOptionalPagingStateString(Optional<String> pagingStateString) {
        pagingStateString.ifPresent(cl -> this.getOptions().setPagingState(Optional.of(PagingState.fromString((String)((String)pagingStateString.get())))));
        return this.getThis();
    }

    public T withRetryPolicy(RetryPolicy retryPolicy) {
        this.getOptions().setRetryPolicy(Optional.of(retryPolicy));
        return this.getThis();
    }

    public T withOptionalRetryPolicy(Optional<RetryPolicy> retryPolicy) {
        this.getOptions().setRetryPolicy(retryPolicy);
        return this.getThis();
    }

    public T withResultSetAsyncListeners(List<Function<ResultSet, ResultSet>> resultSetAsyncListeners) {
        this.getOptions().setResultSetAsyncListeners(Optional.of(resultSetAsyncListeners));
        return this.getThis();
    }

    public T withResultSetAsyncListener(Function<ResultSet, ResultSet> resultSetAsyncListener) {
        this.getOptions().setResultSetAsyncListeners(Optional.of(Arrays.asList(resultSetAsyncListener)));
        return this.getThis();
    }

    public T withRowAsyncListeners(List<Function<Row, Row>> rowAsyncListeners) {
        this.getOptions().setRowAsyncListeners(Optional.of(rowAsyncListeners));
        return this.getThis();
    }

    public T withRowAsyncListener(Function<Row, Row> rowAsyncListener) {
        this.getOptions().setRowAsyncListeners(Optional.of(Arrays.asList(rowAsyncListener)));
        return this.getThis();
    }

    public T withTracing(boolean tracing) {
        this.getOptions().setTracing(Optional.of(tracing));
        return this.getThis();
    }

    public T withTracing() {
        this.getOptions().setTracing(Optional.of(true));
        return this.getThis();
    }

    public T withReadTimeoutInMillis(Integer readTimeoutInMillis) {
        this.getOptions().setReadTimeout(readTimeoutInMillis);
        return this.getThis();
    }

    public T withDMLResultsDisplaySize(int DMLResultsDisplaySize) {
        this.getOptions().setDMLResultsDisplaySize(Optional.of(Integer.max(0, Integer.min(DMLResultsDisplaySize, CassandraOptions.MAX_RESULTS_DISPLAY_SIZE))));
        return this.getThis();
    }
}

