/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.query.delete;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.querybuilder.Delete;
import info.archinnov.achilles.internals.dsl.LWTHelper;
import info.archinnov.achilles.internals.dsl.StatementProvider;
import info.archinnov.achilles.internals.dsl.action.MutationAction;
import info.archinnov.achilles.internals.dsl.options.AbstractOptionsForUpdateOrDelete;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.BoundStatementWrapper;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeleteEnd<T extends AbstractDeleteEnd<T, ENTITY>, ENTITY>
extends AbstractOptionsForUpdateOrDelete<T>
implements MutationAction,
StatementProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeleteEnd.class);
    protected final Delete.Where where;
    protected final CassandraOptions cassandraOptions;

    protected AbstractDeleteEnd(Delete.Where where, CassandraOptions cassandraOptions) {
        this.where = where;
        this.cassandraOptions = cassandraOptions;
    }

    protected abstract List<Object> getBoundValuesInternal();

    protected abstract List<Object> getEncodedValuesInternal();

    protected abstract AbstractEntityProperty<ENTITY> getMetaInternal();

    protected abstract Class<ENTITY> getEntityClass();

    protected abstract RuntimeEngine getRte();

    public T ifExists(boolean ifExists) {
        if (ifExists) {
            this.where.ifExists();
        }
        return (T)((AbstractDeleteEnd)this.getThis());
    }

    public T ifExists() {
        this.where.ifExists();
        return (T)((AbstractDeleteEnd)this.getThis());
    }

    @Override
    public CompletableFuture<ExecutionInfo> executeAsyncWithStats() {
        RuntimeEngine rte = this.getRte();
        CassandraOptions options = this.getOptions();
        StatementWrapper statementWrapper = this.getInternalBoundStatementWrapper();
        String queryString = statementWrapper.getBoundStatement().preparedStatement().getQueryString();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Execute delete async with execution info : %s", queryString));
        }
        CompletableFuture<ResultSet> futureRS = rte.execute(statementWrapper);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)futureRS.thenApply(options::resultSetAsyncListener)).thenApply(statementWrapper::logTrace)).thenApply(x -> LWTHelper.triggerLWTListeners(this.lwtResultListeners, x, queryString))).thenApply(x -> x.getExecutionInfo());
    }

    @Override
    public BoundStatement generateAndGetBoundStatement() {
        return this.getInternalBoundStatementWrapper().getBoundStatement();
    }

    @Override
    public String getStatementAsString() {
        return this.where.getQueryString();
    }

    @Override
    public List<Object> getBoundValues() {
        return this.getBoundValuesInternal();
    }

    @Override
    public List<Object> getEncodedBoundValues() {
        return this.getEncodedValuesInternal();
    }

    private StatementWrapper getInternalBoundStatementWrapper() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Get bound statement wrapper", new Object[0]));
        }
        RuntimeEngine rte = this.getRte();
        AbstractEntityProperty<ENTITY> meta = this.getMetaInternal();
        CassandraOptions cassandraOptions = this.getOptions();
        PreparedStatement ps = rte.prepareDynamicQuery((RegularStatement)this.where);
        BoundStatementWrapper statementWrapper = new BoundStatementWrapper(OperationType.DELETE, meta, ps, this.getBoundValuesInternal().toArray(), this.getEncodedValuesInternal().toArray());
        statementWrapper.applyOptions(cassandraOptions);
        return statementWrapper;
    }
}

