/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.query.select;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.querybuilder.Select;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWhereJSON;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.BoundStatementWrapper;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexSelectWhereJSON<T extends AbstractIndexSelectWhereJSON<T, ENTITY>, ENTITY>
extends AbstractSelectWhereJSON<T, ENTITY> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIndexSelectWhereJSON.class);

    protected AbstractIndexSelectWhereJSON(Select.Where where, CassandraOptions cassandraOptions) {
        super(where, cassandraOptions);
    }

    @Override
    protected StatementWrapper getInternalBoundStatementWrapper() {
        String queryString;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Get bound statement wrapper", new Object[0]));
        }
        RuntimeEngine rte = this.getRte();
        AbstractEntityProperty meta = this.getMetaInternal();
        CassandraOptions cassandraOptions = this.getOptions();
        if (cassandraOptions.hasRawSolrQuery()) {
            this.getBoundValuesInternal().add(0, cassandraOptions.generateRawSolrQuery());
            this.getEncodedValuesInternal().add(0, cassandraOptions.generateRawSolrQuery());
            queryString = this.where.getQueryString();
        } else if (cassandraOptions.hasSolrQuery()) {
            this.getBoundValuesInternal().add(0, cassandraOptions.generateSolrQuery());
            this.getEncodedValuesInternal().add(0, cassandraOptions.generateSolrQuery());
            queryString = this.where.getQueryString();
        } else {
            queryString = this.where.getQueryString().trim().replaceFirst(";$", " ALLOW FILTERING;");
        }
        PreparedStatement ps = rte.prepareDynamicQuery(queryString);
        BoundStatementWrapper statementWrapper = new BoundStatementWrapper(OperationType.SELECT, meta, ps, this.getBoundValuesInternal().toArray(), this.getEncodedValuesInternal().toArray());
        statementWrapper.applyOptions(cassandraOptions);
        return statementWrapper;
    }
}

