/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.query.select;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.querybuilder.Select;
import info.archinnov.achilles.internals.dsl.StatementProvider;
import info.archinnov.achilles.internals.dsl.action.SelectJSONAction;
import info.archinnov.achilles.internals.dsl.options.AbstractOptionsForSelect;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.BoundStatementWrapper;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import info.archinnov.achilles.internals.types.JSONIteratorWrapper;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelectWhereJSON<T extends AbstractSelectWhereJSON<T, ENTITY>, ENTITY>
extends AbstractOptionsForSelect<T>
implements SelectJSONAction,
StatementProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSelectWhereJSON.class);
    protected final Select.Where where;
    protected final CassandraOptions cassandraOptions;

    protected AbstractSelectWhereJSON(Select.Where where, CassandraOptions cassandraOptions) {
        this.where = where;
        this.cassandraOptions = cassandraOptions;
    }

    protected abstract List<Object> getBoundValuesInternal();

    protected abstract List<Object> getEncodedValuesInternal();

    protected abstract AbstractEntityProperty<ENTITY> getMetaInternal();

    protected abstract Class<ENTITY> getEntityClass();

    protected abstract RuntimeEngine getRte();

    @Override
    public CompletableFuture<Tuple2<List<String>, ExecutionInfo>> getListJSONAsyncWithStats() {
        RuntimeEngine rte = this.getRte();
        CassandraOptions options = this.getOptions();
        StatementWrapper statementWrapper = this.getInternalBoundStatementWrapper();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Select async with execution info : %s", statementWrapper.getBoundStatement().preparedStatement().getQueryString()));
        }
        CompletableFuture<ResultSet> futureRS = rte.execute(statementWrapper);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)futureRS.thenApply(options::resultSetAsyncListener)).thenApply(x -> statementWrapper.logReturnResults((ResultSet)x, options.computeMaxDisplayedResults(rte.configContext)))).thenApply(statementWrapper::logTrace)).thenApply(resultSet -> Tuple2.of(IntStream.range(0, resultSet.getAvailableWithoutFetching()).mapToObj(index -> resultSet.one().getString("[json]")).collect(Collectors.toList()), (Object)resultSet.getExecutionInfo()));
    }

    @Override
    public Iterator<String> iterator() {
        RuntimeEngine rte = this.getRte();
        CassandraOptions cassandraOptions = this.getOptions();
        StatementWrapper statementWrapper = this.getInternalBoundStatementWrapper();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Execute native query async with execution info : %s", statementWrapper.getBoundStatement().preparedStatement().getQueryString()));
        }
        CompletableFuture<ResultSet> futureRS = rte.execute(statementWrapper);
        return new JSONIteratorWrapper(futureRS, statementWrapper, cassandraOptions);
    }

    @Override
    public Tuple2<Iterator<String>, ExecutionInfo> iteratorWithExecutionInfo() {
        JSONIteratorWrapper iterator = (JSONIteratorWrapper)this.iterator();
        return Tuple2.of((Object)iterator, (Object)iterator.getExecutionInfo());
    }

    @Override
    public BoundStatement generateAndGetBoundStatement() {
        return this.getInternalBoundStatementWrapper().getBoundStatement();
    }

    @Override
    public String getStatementAsString() {
        return this.where.getQueryString();
    }

    @Override
    public List<Object> getBoundValues() {
        return this.getBoundValuesInternal();
    }

    @Override
    public List<Object> getEncodedBoundValues() {
        return this.getEncodedValuesInternal();
    }

    protected StatementWrapper getInternalBoundStatementWrapper() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Get bound statement wrapper", new Object[0]));
        }
        RuntimeEngine rte = this.getRte();
        AbstractEntityProperty<ENTITY> meta = this.getMetaInternal();
        CassandraOptions cassandraOptions = this.getOptions();
        PreparedStatement ps = rte.prepareDynamicQuery((RegularStatement)this.where);
        BoundStatementWrapper statementWrapper = new BoundStatementWrapper(OperationType.SELECT, meta, ps, this.getBoundValuesInternal().toArray(), this.getEncodedValuesInternal().toArray());
        statementWrapper.applyOptions(cassandraOptions);
        return statementWrapper;
    }
}

