/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.raw;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import info.archinnov.achilles.internals.dsl.LWTHelper;
import info.archinnov.achilles.internals.dsl.RawAndTypeMapDefaultImpl;
import info.archinnov.achilles.internals.dsl.action.MutationAction;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.NativeStatementWrapper;
import info.archinnov.achilles.type.lightweighttransaction.LWTResultListener;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeQuery
implements MutationAction,
RawAndTypeMapDefaultImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeQuery.class);
    private final AbstractEntityProperty<?> meta;
    private final RuntimeEngine rte;
    private final BoundStatement boundStatement;
    private final Object[] encodedBoundValues;
    private final CassandraOptions options = new CassandraOptions();
    private Optional<List<LWTResultListener>> lwtResultListeners = Optional.empty();

    public NativeQuery(AbstractEntityProperty<?> meta, RuntimeEngine rte, BoundStatement boundStatement, Object[] encodedBoundValues) {
        this.meta = meta;
        this.rte = rte;
        this.boundStatement = boundStatement;
        this.encodedBoundValues = encodedBoundValues;
    }

    public NativeQuery withLwtResultListeners(List<LWTResultListener> lwtResultListeners) {
        this.lwtResultListeners = Optional.of(lwtResultListeners);
        return this;
    }

    public NativeQuery withLwtResultListener(LWTResultListener lwtResultListener) {
        this.lwtResultListeners = Optional.of(Arrays.asList(lwtResultListener));
        return this;
    }

    public NativeQuery withResultSetAsyncListeners(List<Function<ResultSet, ResultSet>> resultSetAsyncListeners) {
        this.options.setResultSetAsyncListeners(Optional.of(resultSetAsyncListeners));
        return this;
    }

    public NativeQuery withResultSetAsyncListener(Function<ResultSet, ResultSet> resultSetAsyncListener) {
        this.options.setResultSetAsyncListeners(Optional.of(Arrays.asList(resultSetAsyncListener)));
        return this;
    }

    public NativeQuery withDMLResultsDisplaySize(int DMLResultsDisplaySize) {
        if (!this.getOperationType((Statement)this.boundStatement).isUpsert) {
            this.options.setDMLResultsDisplaySize(Optional.of(Integer.max(0, Integer.min(DMLResultsDisplaySize, CassandraOptions.MAX_RESULTS_DISPLAY_SIZE))));
        }
        return this;
    }

    @Override
    public CompletableFuture<ExecutionInfo> executeAsyncWithStats() {
        NativeStatementWrapper statementWrapper = new NativeStatementWrapper(this.getOperationType((Statement)this.boundStatement), this.meta, this.boundStatement, this.encodedBoundValues);
        String queryString = statementWrapper.getBoundStatement().preparedStatement().getQueryString();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Execute native query async with execution info : %s", queryString));
        }
        CompletableFuture<ResultSet> cfutureRS = this.rte.execute(statementWrapper);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)cfutureRS.thenApply(this.options::resultSetAsyncListener)).thenApply(x -> statementWrapper.logReturnResults((ResultSet)x, this.options.computeMaxDisplayedResults(this.rte.configContext)))).thenApply(statementWrapper::logTrace)).thenApply(x -> LWTHelper.triggerLWTListeners(this.lwtResultListeners, x, queryString))).thenApply(x -> x.getExecutionInfo());
    }

    @Override
    public RuntimeEngine runtimeEngine() {
        return this.rte;
    }

    @Override
    public AbstractEntityProperty<?> meta() {
        return this.meta;
    }

    @Override
    public BoundStatement boundStatement() {
        return this.boundStatement;
    }

    @Override
    public Object[] encodedBoundValues() {
        return this.encodedBoundValues;
    }

    @Override
    public CassandraOptions options() {
        return this.options;
    }
}

