/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.raw;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import info.archinnov.achilles.internals.dsl.RawAndTypeMapDefaultImpl;
import info.archinnov.achilles.internals.dsl.action.SelectAction;
import info.archinnov.achilles.internals.dsl.raw.TypedQueryValidator;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.BoundStatementWrapper;
import info.archinnov.achilles.internals.types.EntityIteratorWrapper;
import info.archinnov.achilles.type.interceptor.Event;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedQuery<ENTITY>
implements SelectAction<ENTITY>,
RawAndTypeMapDefaultImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypedQuery.class);
    private final RuntimeEngine rte;
    private final AbstractEntityProperty<ENTITY> meta;
    private final BoundStatement boundStatement;
    private final Object[] encodedBoundValues;
    private final CassandraOptions options = new CassandraOptions();

    public TypedQuery(RuntimeEngine rte, AbstractEntityProperty<ENTITY> meta, BoundStatement boundStatement, Object[] encodedBoundValues) {
        this.rte = rte;
        this.meta = meta;
        this.boundStatement = boundStatement;
        this.encodedBoundValues = encodedBoundValues;
        TypedQueryValidator.validateCorrectTableName(boundStatement.preparedStatement().getQueryString().toLowerCase(), meta);
    }

    public TypedQuery<ENTITY> withResultSetAsyncListeners(List<Function<ResultSet, ResultSet>> resultSetAsyncListeners) {
        this.options.setResultSetAsyncListeners(Optional.of(resultSetAsyncListeners));
        return this;
    }

    public TypedQuery<ENTITY> withResultSetAsyncListener(Function<ResultSet, ResultSet> resultSetAsyncListener) {
        this.options.setResultSetAsyncListeners(Optional.of(Arrays.asList(resultSetAsyncListener)));
        return this;
    }

    public TypedQuery<ENTITY> withRowAsyncListeners(List<Function<Row, Row>> rowAsyncListeners) {
        this.options.setRowAsyncListeners(Optional.of(rowAsyncListeners));
        return this;
    }

    public TypedQuery<ENTITY> withRowAsyncListener(Function<Row, Row> rowAsyncListener) {
        this.options.setRowAsyncListeners(Optional.of(Arrays.asList(rowAsyncListener)));
        return this;
    }

    public TypedQuery<ENTITY> withDMLResultsDisplaySize(int DMLResultsDisplaySize) {
        if (!this.getOperationType((Statement)this.boundStatement).isUpsert) {
            this.options.setDMLResultsDisplaySize(Optional.of(Integer.max(0, Integer.min(DMLResultsDisplaySize, CassandraOptions.MAX_RESULTS_DISPLAY_SIZE))));
        }
        return this;
    }

    @Override
    public Iterator<ENTITY> iterator() {
        BoundStatementWrapper statementWrapper = new BoundStatementWrapper(this.getOperationType((Statement)this.boundStatement), this.meta, this.boundStatement, this.encodedBoundValues);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Generate iterator for typed query : %s", statementWrapper.getBoundStatement().preparedStatement().getQueryString()));
        }
        CompletableFuture<ResultSet> futureRS = this.rte.execute(statementWrapper);
        return new EntityIteratorWrapper<ENTITY>(futureRS, this.meta, statementWrapper, this.options);
    }

    @Override
    public Tuple2<Iterator<ENTITY>, ExecutionInfo> iteratorWithExecutionInfo() {
        EntityIteratorWrapper iterator = (EntityIteratorWrapper)this.iterator();
        return Tuple2.of((Object)iterator, (Object)iterator.getExecutionInfo());
    }

    @Override
    public CompletableFuture<Tuple2<List<ENTITY>, ExecutionInfo>> getListAsyncWithStats() {
        BoundStatementWrapper statementWrapper = new BoundStatementWrapper(this.getOperationType((Statement)this.boundStatement), this.meta, this.boundStatement, this.encodedBoundValues);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Select async with execution info : %s", statementWrapper.getBoundStatement().preparedStatement().getQueryString()));
        }
        CompletableFuture<ResultSet> futureRS = this.rte.execute(statementWrapper);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)futureRS.thenApply(this.options::resultSetAsyncListener)).thenApply(x -> statementWrapper.logReturnResults((ResultSet)x, this.options.computeMaxDisplayedResults(this.rte.configContext)))).thenApply(statementWrapper::logTrace)).thenApply(rs -> Tuple2.of(IntStream.range(0, rs.getAvailableWithoutFetching()).mapToObj(index -> {
            Row row = rs.one();
            this.options.rowAsyncListener(row);
            return this.meta.createEntityFrom(row);
        }).collect(Collectors.toList()), (Object)rs.getExecutionInfo()))).thenApply(tuple2 -> {
            for (Object entity : (List)tuple2._1()) {
                this.meta.triggerInterceptorsForEvent(Event.POST_LOAD, entity);
            }
            return tuple2;
        });
    }

    @Override
    public RuntimeEngine runtimeEngine() {
        return this.rte;
    }

    @Override
    public AbstractEntityProperty<?> meta() {
        return this.meta;
    }

    @Override
    public BoundStatement boundStatement() {
        return this.boundStatement;
    }

    @Override
    public Object[] encodedBoundValues() {
        return this.encodedBoundValues;
    }

    @Override
    public CassandraOptions options() {
        return this.options;
    }
}

