/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.raw;

import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.validation.Validator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedQueryValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypedQueryValidator.class);
    private static final String OPTIONAL_KEYSPACE_PREFIX = "[a-zA-Z0-9_]*\\.?";

    public static void validateCorrectTableName(String queryString, AbstractEntityProperty<?> meta) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Validate that the query string %s is related to the entity meta %s", queryString, meta.toString()));
        }
        String tableName = meta.getTableOrViewName().toLowerCase();
        Pattern pattern = Pattern.compile(".* from [a-zA-Z0-9_]*\\.?" + tableName + "(?: )?.*");
        Validator.validateTrue((boolean)pattern.matcher(queryString).matches(), (String)"The typed query [%s] should contain the table name '%s' if the entity type is '%s'", (Object[])new Object[]{queryString, tableName, meta.entityClass.getCanonicalName()});
    }
}

