/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.UDTValue;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.injectable.InjectBeanFactory;
import info.archinnov.achilles.internals.injectable.InjectJacksonMapper;
import info.archinnov.achilles.internals.injectable.InjectKeyspace;
import info.archinnov.achilles.internals.injectable.InjectRuntimeCodecs;
import info.archinnov.achilles.internals.injectable.InjectSchemaStrategy;
import info.archinnov.achilles.internals.injectable.InjectUserAndTupleTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.utils.NamingHelper;
import info.archinnov.achilles.type.SchemaNameProvider;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractProperty<ENTITY, VALUEFROM, VALUETO>
implements InjectUserAndTupleTypeFactory,
InjectBeanFactory,
InjectJacksonMapper,
InjectRuntimeCodecs,
InjectKeyspace,
InjectSchemaStrategy {
    public final FieldInfo<ENTITY, VALUEFROM> fieldInfo;
    public final String fieldName;
    public TypeToken<VALUEFROM> valueFromTypeToken;
    public TypeToken<VALUETO> valueToTypeToken;
    protected Optional<SchemaNameProvider> schemaNameProvider = Optional.empty();
    private DataType dataType;

    AbstractProperty(TypeToken<VALUEFROM> valueFromTypeToken, TypeToken<VALUETO> valueToTypeToken, FieldInfo<ENTITY, VALUEFROM> fieldInfo) {
        this.valueFromTypeToken = valueFromTypeToken;
        this.valueToTypeToken = valueToTypeToken;
        this.fieldInfo = fieldInfo;
        this.fieldName = fieldInfo.fieldName;
    }

    AbstractProperty(FieldInfo<ENTITY, VALUEFROM> fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.fieldName = fieldInfo.fieldName;
    }

    public VALUETO encodeFromJava(VALUEFROM javaValue) {
        return this.encodeFromJava(javaValue, Optional.empty());
    }

    public VALUETO encodeFromJava(VALUEFROM javaValue, Optional<CassandraOptions> cassandraOptions) {
        if (javaValue == null) {
            return null;
        }
        return this.encodeFromJavaInternal(javaValue, cassandraOptions);
    }

    public abstract void encodeToSettable(VALUETO var1, SettableData<?> var2);

    abstract VALUETO encodeFromJavaInternal(VALUEFROM var1, Optional<CassandraOptions> var2);

    public VALUETO encodeFromRaw(Object o) {
        return this.encodeFromRaw(o, Optional.empty());
    }

    public VALUETO encodeFromRaw(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (o == null) {
            return null;
        }
        return this.encodeFromRawInternal(o, cassandraOptions);
    }

    abstract VALUETO encodeFromRawInternal(Object var1, Optional<CassandraOptions> var2);

    public VALUEFROM decodeFromGettable(GettableData gettableData) {
        if (gettableData.isNull(NamingHelper.maybeQuote(this.getColumnForSelect())) && !this.isOptional()) {
            return null;
        }
        return this.decodeFromGettableInternal(gettableData);
    }

    abstract VALUEFROM decodeFromGettableInternal(GettableData var1);

    public VALUEFROM decodeFromRaw(Object o) {
        if (o == null && !this.isOptional()) {
            return null;
        }
        return this.decodeFromRawInternal(o);
    }

    abstract VALUEFROM decodeFromRawInternal(Object var1);

    public abstract DataType buildType(Optional<CassandraOptions> var1);

    abstract boolean isOptional();

    public VALUETO encodeField(ENTITY entity) {
        return this.encodeField(entity, Optional.empty());
    }

    public VALUETO encodeField(ENTITY entity, Optional<CassandraOptions> cassandraOptions) {
        return this.encodeFromJava(this.getJavaValue(entity), cassandraOptions);
    }

    public VALUEFROM getJavaValue(ENTITY entity) {
        return this.fieldInfo.getter.get(entity);
    }

    public void encodeFieldToUdt(ENTITY entity, UDTValue udtValue) {
        this.encodeFieldToUdt(entity, udtValue, Optional.empty());
    }

    public abstract void encodeFieldToUdt(ENTITY var1, UDTValue var2, Optional<CassandraOptions> var3);

    public abstract boolean containsUDTProperty();

    public abstract List<AbstractUDTClassProperty<?>> getUDTClassProperties();

    public void decodeField(GettableData gettableData, ENTITY entity) {
        VALUEFROM valuefrom = this.decodeFromGettable(gettableData);
        this.fieldInfo.setter.set(entity, valuefrom);
    }

    public VALUEFROM getFieldValue(ENTITY entity) {
        return this.fieldInfo.getter.get(entity);
    }

    public void setField(ENTITY entity, VALUEFROM value) {
        this.fieldInfo.setter.set(entity, value);
    }

    public String getColumnForSelect() {
        return this.fieldInfo.cqlColumn;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = this.buildType(Optional.empty());
        }
        return this.dataType;
    }

    @Override
    public void inject(SchemaNameProvider schemaNameProvider) {
        this.schemaNameProvider = Optional.ofNullable(schemaNameProvider);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProperty that = (AbstractProperty)o;
        return Objects.equals(this.fieldName, that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractProperty{");
        sb.append("fieldName='").append(this.fieldName).append('\'');
        sb.append(", valueFromTypeToken=").append(this.valueFromTypeToken);
        sb.append(", valueToTypeToken=").append(this.valueToTypeToken);
        sb.append('}');
        return sb.toString();
    }
}

