/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.type.tuples.Tuple;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTupleProperty<ENTITY, T extends Tuple>
extends AbstractProperty<ENTITY, T, TupleValue> {
    public static final TypeToken<TupleValue> TUPLE_VALUE_TYPE_TOKEN = new TypeToken<TupleValue>(){};
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTupleProperty.class);
    protected TupleType tupleType;
    protected TupleTypeFactory tupleTypeFactory;

    AbstractTupleProperty(TypeToken<T> valueFromTypeToken, FieldInfo<ENTITY, T> fieldInfo) {
        super(valueFromTypeToken, TUPLE_VALUE_TYPE_TOKEN, fieldInfo);
    }

    public abstract TupleType buildType(Optional<CassandraOptions> var1);

    @Override
    boolean isOptional() {
        return false;
    }

    protected abstract List<AbstractProperty<ENTITY, ?, ?>> componentsProperty();

    @Override
    public void encodeToSettable(TupleValue tuple, SettableData<?> settableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode tuple value %s to settable object %s", tuple, settableData));
        }
        settableData.setTupleValue(this.fieldInfo.quotedCqlColumn, tuple);
    }

    @Override
    public void encodeFieldToUdt(ENTITY entity, UDTValue udtValue, Optional<CassandraOptions> cassandraOptions) {
        TupleValue tupleValue = (TupleValue)this.encodeField(entity, cassandraOptions);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode tuple value %s to udt value %s", tupleValue, udtValue));
        }
        udtValue.setTupleValue(this.fieldInfo.quotedCqlColumn, tupleValue);
    }

    @Override
    public void injectKeyspace(String keyspace) {
        for (AbstractProperty<ENTITY, ?, ?> x : this.componentsProperty()) {
            x.injectKeyspace(keyspace);
        }
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
        this.tupleTypeFactory = tupleTypeFactory;
        for (AbstractProperty<ENTITY, ?, ?> x : this.componentsProperty()) {
            x.inject(userTypeFactory, tupleTypeFactory);
        }
        this.tupleType = this.buildType(this.schemaNameProvider.map(CassandraOptions::withSchemaNameProvider));
    }

    @Override
    public void inject(ObjectMapper jacksonMapper) {
        for (AbstractProperty<ENTITY, ?, ?> x : this.componentsProperty()) {
            x.inject(jacksonMapper);
        }
    }

    @Override
    public void inject(BeanFactory factory) {
        for (AbstractProperty<ENTITY, ?, ?> x : this.componentsProperty()) {
            x.inject(factory);
        }
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        for (AbstractProperty<ENTITY, ?, ?> x : this.componentsProperty()) {
            x.injectRuntimeCodecs(runtimeCodecs);
        }
    }

    @Override
    public boolean containsUDTProperty() {
        boolean containsUDT = false;
        for (AbstractProperty<ENTITY, ?, ?> x : this.componentsProperty()) {
            containsUDT = containsUDT || x.containsUDTProperty();
        }
        return containsUDT;
    }

    @Override
    public List<AbstractUDTClassProperty<?>> getUDTClassProperties() {
        return this.componentsProperty().stream().flatMap(property -> property.getUDTClassProperties().stream()).collect(Collectors.toList());
    }

    @Override
    public void inject(SchemaNameProvider schemaNameProvider) {
        super.inject(schemaNameProvider);
        for (AbstractProperty<ENTITY, ?, ?> x : this.componentsProperty()) {
            x.inject(schemaNameProvider);
        }
    }

    protected TupleType getRuntimeTupleType(Optional<CassandraOptions> options) {
        return options.isPresent() ? this.buildType(options) : this.tupleType;
    }
}

