/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.annotations.UDT;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.injectable.InjectBeanFactory;
import info.archinnov.achilles.internals.injectable.InjectJacksonMapper;
import info.archinnov.achilles.internals.injectable.InjectKeyspace;
import info.archinnov.achilles.internals.injectable.InjectRuntimeCodecs;
import info.archinnov.achilles.internals.injectable.InjectSchemaStrategy;
import info.archinnov.achilles.internals.injectable.InjectUserAndTupleTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.schema.SchemaContext;
import info.archinnov.achilles.internals.strategy.naming.InternalNamingStrategy;
import info.archinnov.achilles.internals.types.OverridingOptional;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.validation.Validator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUDTClassProperty<A>
implements InjectUserAndTupleTypeFactory,
InjectBeanFactory,
InjectKeyspace,
InjectJacksonMapper,
InjectRuntimeCodecs,
InjectSchemaStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUDTClassProperty.class);
    public final Optional<String> staticKeyspace;
    public final Optional<InternalNamingStrategy> staticNamingStrategy;
    public final Optional<String> staticUdtName;
    public final Class<A> udtClass;
    public final String udtName;
    public final List<AbstractProperty<A, ?, ?>> componentsProperty;
    public final List<AbstractProperty<A, ?, ?>> constructorInjectedProperty;
    public final Class<?> parentEntityClass;
    protected BeanFactory udtFactory;
    protected UserTypeFactory userTypeFactory;
    protected UserType userType;
    protected Optional<SchemaNameProvider> schemaNameProvider = Optional.empty();
    String keyspace;

    public AbstractUDTClassProperty() {
        this.staticKeyspace = this.getStaticKeyspace();
        this.staticNamingStrategy = this.getStaticNamingStrategy();
        this.staticUdtName = this.getStaticUdtName();
        this.udtName = this.getUdtName();
        this.udtClass = this.getUdtClass();
        this.componentsProperty = this.getComponentsProperty();
        this.constructorInjectedProperty = this.getConstructorInjectedProperty();
        this.parentEntityClass = this.getParentEntityClass();
    }

    protected abstract Optional<String> getStaticKeyspace();

    protected abstract Optional<InternalNamingStrategy> getStaticNamingStrategy();

    protected abstract Optional<String> getStaticUdtName();

    protected abstract String getUdtName();

    protected abstract Class<A> getUdtClass();

    protected abstract List<AbstractProperty<A, ?, ?>> getComponentsProperty();

    protected abstract List<AbstractProperty<A, ?, ?>> getConstructorInjectedProperty();

    protected abstract Class<?> getParentEntityClass();

    protected abstract UDTValue createUDTFromBean(A var1, boolean var2, Optional<CassandraOptions> var3);

    protected abstract A newInstanceFromCustomConstructor(UDTValue var1);

    protected A createBeanFromUDT(UDTValue udtValue) {
        if (udtValue != null) {
            Object instance;
            if (this.constructorInjectedProperty.size() == 0) {
                instance = this.udtFactory.newInstance(this.udtClass);
                this.componentsProperty.stream().forEach(x -> x.decodeField((GettableData)udtValue, instance));
            } else {
                instance = this.newInstanceFromCustomConstructor(udtValue);
                this.componentsProperty.stream().filter(x -> !this.constructorInjectedProperty.contains(x)).forEach(x -> x.decodeField((GettableData)udtValue, instance));
            }
            return instance;
        }
        return null;
    }

    protected UserType getUserType(boolean frozen, Optional<CassandraOptions> cassandraOptions) {
        if (cassandraOptions.isPresent() || this.userType == null) {
            return this.buildType(frozen, cassandraOptions);
        }
        return this.userType;
    }

    public UserType buildType(boolean frozen, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Building UserType instance for the current UDT class meta %s", this.toString()));
        }
        Optional<Optional<String>> keyspaceName = OverridingOptional.from(cassandraOptions.flatMap(CassandraOptions::getSchemaNameProvider).map(x -> x.keyspaceFor(this.parentEntityClass))).andThen(this.schemaNameProvider.map(x -> x.keyspaceFor(this.parentEntityClass))).andThen((Optional<String>)((Object)this.staticKeyspace.orElse(this.keyspace))).getOptional();
        Validator.validateTrue((boolean)keyspaceName.isPresent(), (String)"The keyspace name for the UDT type '%s' should be either provided by the '%s' annotation or at runtime", (Object[])new Object[]{this.udtClass.getCanonicalName(), UDT.class.getSimpleName()});
        List<UserType.Field> fields = this.getComponentsProperty().stream().map(property -> this.userTypeFactory.fieldFor(property.fieldInfo.cqlColumn, property.buildType(cassandraOptions))).collect(Collectors.toList());
        return this.userTypeFactory.typeFor((String)((Object)keyspaceName.get()), this.udtName, frozen, fields);
    }

    public String generateSchema(SchemaContext context) {
        Optional<Object> keyspace;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generating creation script for current UDT class meta %s", this.toString()));
        }
        CreateType type = (keyspace = Optional.ofNullable(context.keyspace.orElse(this.staticKeyspace.orElse(null)))).isPresent() ? (CreateType)SchemaBuilder.createType((String)keyspace.get(), (String)this.udtName).ifNotExists() : (CreateType)SchemaBuilder.createType((String)this.udtName).ifNotExists();
        for (AbstractProperty<A, ?, ?> x : this.componentsProperty) {
            type.addColumn(x.fieldInfo.quotedCqlColumn, x.buildType(Optional.empty()));
        }
        return type.getQueryString().replaceFirst("\t+", "") + ";";
    }

    @Override
    public void inject(BeanFactory factory) {
        this.udtFactory = factory;
        for (AbstractProperty<A, ?, ?> x : this.componentsProperty) {
            x.inject(this.udtFactory);
        }
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
        this.userTypeFactory = userTypeFactory;
        for (AbstractProperty<A, ?, ?> x : this.componentsProperty) {
            x.inject(userTypeFactory, tupleTypeFactory);
        }
    }

    @Override
    public void inject(ObjectMapper jacksonMapper) {
        for (AbstractProperty<A, ?, ?> x : this.componentsProperty) {
            x.inject(jacksonMapper);
        }
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        for (AbstractProperty<A, ?, ?> x : this.componentsProperty) {
            x.injectRuntimeCodecs(runtimeCodecs);
        }
    }

    @Override
    public void injectKeyspace(String keyspace) {
        this.keyspace = keyspace;
        for (AbstractProperty<A, ?, ?> x : this.componentsProperty) {
            x.injectKeyspace(keyspace);
        }
    }

    @Override
    public void inject(SchemaNameProvider schemaNameProvider) {
        this.schemaNameProvider = Optional.ofNullable(schemaNameProvider);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractUDTClassProperty{");
        sb.append("componentsProperty=").append(this.componentsProperty);
        sb.append(", udtName='").append(this.udtName).append('\'');
        sb.append(", keyspace='").append(this.keyspace).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUDTClassProperty that = (AbstractUDTClassProperty)o;
        return Objects.equals(this.staticKeyspace, that.staticKeyspace) && Objects.equals(this.staticNamingStrategy, that.staticNamingStrategy) && Objects.equals(this.staticUdtName, that.staticUdtName) && Objects.equals(this.udtClass, that.udtClass) && Objects.equals(this.udtName, that.udtName) && Objects.equals(this.keyspace, that.keyspace);
    }

    public int hashCode() {
        return Objects.hash(this.staticKeyspace, this.staticNamingStrategy, this.staticUdtName, this.udtClass, this.udtName, this.keyspace);
    }
}

