/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.Session;
import info.archinnov.achilles.internals.cache.StatementsCache;
import info.archinnov.achilles.internals.cassandra_version.InternalCassandraVersion;
import info.archinnov.achilles.internals.context.ConfigurationContext;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.schema.SchemaContext;
import info.archinnov.achilles.internals.schema.SchemaCreator;
import info.archinnov.achilles.internals.schema.SchemaValidator;
import info.archinnov.achilles.internals.statements.PreparedStatementGenerator;
import info.archinnov.achilles.internals.types.OverridingOptional;
import info.archinnov.achilles.internals.utils.CollectionsHelper;
import info.archinnov.achilles.type.interceptor.Event;
import info.archinnov.achilles.type.strategy.InsertStrategy;
import info.archinnov.achilles.validation.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractViewProperty<T>
extends AbstractEntityProperty<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractViewProperty.class);
    private final List<AbstractProperty<T, ?, ?>> EMPTY_LIST = Arrays.asList(new AbstractProperty[0]);
    private AbstractEntityProperty<?> baseClassProperty;

    public abstract Class<?> getBaseEntityClass();

    @Override
    public boolean isTable() {
        return false;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public String generateSchema(SchemaContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generating DDL script for entity of type %s", this.entityClass.getCanonicalName()));
        }
        StringJoiner joiner = new StringJoiner("\n\n");
        SchemaCreator.generateView(context, this).forEach(joiner::add);
        return joiner.toString();
    }

    @Override
    public void validateSchema(ConfigurationContext configContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Validating schema for entity of type %s", this.entityClass.getCanonicalName()));
        }
        String keyspace = this.getKeyspace().orElse(null);
        Validator.validateNotBlank((String)keyspace, (String)"Current keyspace not provided neither in configuration nor on entity '%s' annotation", (Object[])new Object[]{this.entityClass.getCanonicalName()});
        KeyspaceMetadata keyspaceMetadata = configContext.getSession().getCluster().getMetadata().getKeyspace(keyspace);
        Validator.validateNotNull((Object)keyspaceMetadata, (String)"The keyspace {} defined on entity {} does not exist in Cassandra", (Object[])new Object[]{keyspace, this.entityClass.getCanonicalName()});
        String tableName = this.getTableOrViewName();
        MaterializedViewMetadata viewMetadata = keyspaceMetadata.getMaterializedView(tableName);
        Validator.validateNotNull((Object)viewMetadata, (String)"The view {} defined on entity {} does not exist in Cassandra", (Object[])new Object[]{tableName, this.entityClass.getCanonicalName()});
        SchemaValidator.validateColumnType(ColumnType.PARTITION, (AbstractTableMetadata)viewMetadata, this.partitionKeys, this.entityClass);
        SchemaValidator.validateColumnType(ColumnType.CLUSTERING, (AbstractTableMetadata)viewMetadata, this.clusteringColumns, this.entityClass);
        SchemaValidator.validateColumns((AbstractTableMetadata)viewMetadata, this.partitionKeys, this.entityClass);
        SchemaValidator.validateColumns((AbstractTableMetadata)viewMetadata, this.clusteringColumns, this.entityClass);
        SchemaValidator.validateColumns((AbstractTableMetadata)viewMetadata, this.normalColumns, this.entityClass);
    }

    @Override
    public void prepareStaticStatements(InternalCassandraVersion cassandraVersion, Session session, StatementsCache cache) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Preparing static statements for entity of type %s", this.entityClass.getCanonicalName()));
        }
        PreparedStatementGenerator.generateStaticSelectQuery(session, cache, this);
    }

    @Override
    protected List<AbstractProperty<T, ?, ?>> getAllColumns() {
        return CollectionsHelper.appendAll(this.partitionKeys, this.clusteringColumns, this.normalColumns);
    }

    @Override
    protected List<AbstractProperty<T, ?, ?>> getAllColumnsWithComputed() {
        return CollectionsHelper.appendAll(this.partitionKeys, this.clusteringColumns, this.normalColumns, this.computedColumns);
    }

    @Override
    protected AbstractEntityProperty.EntityType getType() {
        return AbstractEntityProperty.EntityType.VIEW;
    }

    @Override
    public void injectConsistencyLevels(Session session, ConfigurationContext configContext) {
        ConsistencyLevel clusterConsistency = session.getCluster().getConfiguration().getQueryOptions().getConsistencyLevel();
        String tableOrViewName = this.getTableOrViewName();
        this.readConsistencyLevel = (ConsistencyLevel)OverridingOptional.from(this.staticReadConsistency).andThen((Optional)configContext.getReadConsistencyLevelForTable(tableOrViewName)).andThen((Optional)clusterConsistency).andThen(configContext.getDefaultReadConsistencyLevel()).defaultValue((Optional<ConsistencyLevel>)ConfigurationContext.DEFAULT_CONSISTENCY_LEVEL).get();
    }

    @Override
    public void inject(InsertStrategy insertStrategy) {
    }

    @Override
    public void triggerInterceptorsForEvent(Event event, T instance) {
        if (event != Event.POST_LOAD) {
            throw new RuntimeException("Cannot execute mutation for the materialized view " + this.getDerivedTableOrViewName());
        }
        super.triggerInterceptorsForEvent(event, instance);
    }

    @Override
    public InsertStrategy insertStrategy() {
        throw new RuntimeException("Cannot execute mutation for the materialized view " + this.getDerivedTableOrViewName());
    }

    @Override
    public ConsistencyLevel writeConsistency(Optional<ConsistencyLevel> runtimeConsistency) {
        throw new RuntimeException("Cannot execute mutation for the materialized view " + this.getDerivedTableOrViewName());
    }

    @Override
    public ConsistencyLevel serialConsistency(Optional<ConsistencyLevel> runtimeConsistency) {
        throw new RuntimeException("Cannot execute mutation for the materialized view " + this.getDerivedTableOrViewName());
    }

    @Override
    protected boolean isCounterTable() {
        return false;
    }

    @Override
    protected Optional<ConsistencyLevel> getStaticWriteConsistency() {
        return Optional.empty();
    }

    @Override
    protected Optional<ConsistencyLevel> getStaticSerialConsistency() {
        return Optional.empty();
    }

    @Override
    protected Optional<Integer> getStaticTTL() {
        return Optional.empty();
    }

    @Override
    protected Optional<InsertStrategy> getStaticInsertStrategy() {
        return Optional.empty();
    }

    @Override
    protected List<AbstractProperty<T, ?, ?>> getStaticColumns() {
        return this.EMPTY_LIST;
    }

    @Override
    protected List<AbstractProperty<T, ?, ?>> getCounterColumns() {
        return this.EMPTY_LIST;
    }

    public AbstractEntityProperty<?> getBaseClassProperty() {
        return this.baseClassProperty;
    }

    public void setBaseClassProperty(AbstractEntityProperty<?> baseClassProperty) {
        this.baseClassProperty = baseClassProperty;
    }
}

