/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.UDTValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.columns.ComputedColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.types.RuntimeCodecWrapper;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedProperty<ENTITY, VALUEFROM, VALUETO>
extends AbstractProperty<ENTITY, VALUEFROM, VALUETO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputedProperty.class);
    public final ComputedColumnInfo computedColumnInfo;
    private final Function<GettableData, VALUETO> extractor;
    private final Codec<VALUEFROM, VALUETO> valueCodec;

    public ComputedProperty(FieldInfo<ENTITY, VALUEFROM> fieldInfo, Function<GettableData, VALUETO> extractor, Codec<VALUEFROM, VALUETO> valueCodec) {
        super(fieldInfo);
        this.valueFromTypeToken = new TypeToken<VALUEFROM>(this.getClass()){};
        this.valueToTypeToken = new TypeToken<VALUETO>(this.getClass()){};
        this.extractor = extractor;
        this.valueCodec = valueCodec;
        this.computedColumnInfo = (ComputedColumnInfo)fieldInfo.columnInfo;
    }

    @Override
    boolean isOptional() {
        return false;
    }

    @Override
    public void encodeToSettable(VALUETO valueto, SettableData<?> settableData) {
        throw new UnsupportedOperationException(String.format("Cannot set computed value to field '%s'", this.fieldInfo.fieldName));
    }

    @Override
    VALUETO encodeFromJavaInternal(VALUEFROM javaValue, Optional<CassandraOptions> cassandraOptions) {
        throw new UnsupportedOperationException(String.format("Cannot set computed value to field '%s'", this.fieldInfo.fieldName));
    }

    @Override
    VALUETO encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        throw new UnsupportedOperationException(String.format("Cannot set computed value to field '%s'", this.fieldInfo.fieldName));
    }

    @Override
    VALUEFROM decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode computed property %s from gettable data %s", this.toString(), gettableData));
        }
        return (VALUEFROM)this.valueCodec.decode(this.extractor.apply(gettableData));
    }

    @Override
    VALUEFROM decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode computed property %s from raw data %s", this.toString(), o));
        }
        Class<?> cqlClass = this.computedColumnInfo.cqlClass;
        Validator.validateTrue((boolean)cqlClass.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be %s", (Object[])new Object[]{o, cqlClass.getCanonicalName()});
        return (VALUEFROM)this.valueCodec.decode(o);
    }

    @Override
    public DataType buildType(Optional<CassandraOptions> cassandraOptions) {
        throw new UnsupportedOperationException(String.format("No type for computed field '%s'", this.fieldInfo.fieldName));
    }

    @Override
    public String getColumnForSelect() {
        return this.computedColumnInfo.alias;
    }

    @Override
    public void encodeFieldToUdt(ENTITY entity, UDTValue udtValue, Optional<CassandraOptions> cassandraOptions) {
        throw new UnsupportedOperationException(String.format("No UDT encoding for computed field '%s'", this.fieldInfo.fieldName));
    }

    @Override
    public boolean containsUDTProperty() {
        return false;
    }

    @Override
    public List<AbstractUDTClassProperty<?>> getUDTClassProperties() {
        return new ArrayList();
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
    }

    @Override
    public void inject(ObjectMapper mapper) {
    }

    @Override
    public void inject(BeanFactory factory) {
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        if (this.valueCodec instanceof RuntimeCodecWrapper) {
            ((RuntimeCodecWrapper)this.valueCodec).inject(runtimeCodecs);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ComputedProperty{");
        sb.append("computedColumnInfo=").append(this.computedColumnInfo);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void injectKeyspace(String keyspace) {
    }
}

