/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.UDTValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.validation.Validator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkOptionalProperty<ENTITY, FROM, TO>
extends AbstractProperty<ENTITY, Optional<FROM>, TO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkOptionalProperty.class);
    private final AbstractProperty<ENTITY, FROM, TO> aProperty;

    public JdkOptionalProperty(FieldInfo<ENTITY, Optional<FROM>> fieldInfo, AbstractProperty<ENTITY, FROM, TO> aProperty) {
        super(new TypeToken<Optional<FROM>>(){}.where(new TypeParameter<FROM>(){}, aProperty.valueFromTypeToken), aProperty.valueToTypeToken, fieldInfo);
        this.aProperty = aProperty;
    }

    @Override
    boolean isOptional() {
        return true;
    }

    @Override
    public void encodeToSettable(TO a, SettableData<?> settableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode value %s to settable object %s", a, settableData));
        }
        if (a != null) {
            this.aProperty.encodeToSettable(a, settableData);
        }
    }

    @Override
    TO encodeFromJavaInternal(Optional<FROM> javaValue, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' optional object %s", this.fieldName, javaValue));
        }
        if (javaValue.isPresent()) {
            return this.aProperty.encodeFromJavaInternal(javaValue.get(), cassandraOptions);
        }
        return null;
    }

    @Override
    TO encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' optional object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)Optional.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be java.util.Optional", (Object[])new Object[]{o});
        return (TO)this.encodeFromJava((Optional)o, cassandraOptions);
    }

    @Override
    Optional<FROM> decodeFromGettableInternal(GettableData gettableData) {
        FROM decoded;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' optional from gettable object %s", this.fieldName, gettableData));
        }
        if ((decoded = this.aProperty.decodeFromGettableInternal(gettableData)) == null) {
            return Optional.empty();
        }
        return Optional.of(decoded);
    }

    @Override
    Optional<FROM> decodeFromRawInternal(Object o) {
        FROM decoded;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple1 raw object %s", this.fieldName, o));
        }
        if ((decoded = this.aProperty.decodeFromRawInternal(o)) == null) {
            return Optional.empty();
        }
        return Optional.of(decoded);
    }

    @Override
    public DataType buildType(Optional<CassandraOptions> cassandraOptions) {
        return this.aProperty.buildType(cassandraOptions);
    }

    @Override
    public void encodeFieldToUdt(ENTITY entity, UDTValue udtValue, Optional<CassandraOptions> cassandraOptions) {
        TO encoded = this.aProperty.encodeField(entity, cassandraOptions);
        if (encoded != null) {
            this.aProperty.encodeFieldToUdt(entity, udtValue, cassandraOptions);
        }
    }

    @Override
    public boolean containsUDTProperty() {
        return this.aProperty.containsUDTProperty();
    }

    @Override
    public List<AbstractUDTClassProperty<?>> getUDTClassProperties() {
        return this.aProperty.getUDTClassProperties();
    }

    @Override
    public void inject(BeanFactory factory) {
        this.aProperty.inject(factory);
    }

    @Override
    public void inject(ObjectMapper mapper) {
        this.aProperty.inject(mapper);
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        this.aProperty.injectRuntimeCodecs(runtimeCodecs);
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
        this.aProperty.inject(userTypeFactory, tupleTypeFactory);
    }

    @Override
    public void injectKeyspace(String keyspace) {
        this.aProperty.injectKeyspace(keyspace);
    }

    @Override
    public void inject(SchemaNameProvider schemaNameProvider) {
        super.inject(schemaNameProvider);
        this.aProperty.inject(schemaNameProvider);
    }
}

