/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.UDTValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.utils.CollectionsHelper;
import info.archinnov.achilles.internals.utils.NamingHelper;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.validation.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapProperty<ENTITY, KEYFROM, KEYTO, VALUEFROM, VALUETO>
extends AbstractProperty<ENTITY, Map<KEYFROM, VALUEFROM>, Map<KEYTO, VALUETO>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapProperty.class);
    public final AbstractProperty<ENTITY, KEYFROM, KEYTO> keyProperty;
    public final AbstractProperty<ENTITY, VALUEFROM, VALUETO> valueProperty;
    public final boolean frozen;
    public final boolean emptyCollectionIfNull;

    public MapProperty(FieldInfo<ENTITY, Map<KEYFROM, VALUEFROM>> fieldInfo, boolean frozen, boolean emptyCollectionIfNull, AbstractProperty<ENTITY, KEYFROM, KEYTO> keyProperty, AbstractProperty<ENTITY, VALUEFROM, VALUETO> valueProperty) {
        super(new TypeToken<Map<KEYFROM, VALUEFROM>>(){}.where(new TypeParameter<KEYFROM>(){}, keyProperty.valueFromTypeToken).where(new TypeParameter<VALUEFROM>(){}, valueProperty.valueFromTypeToken), new TypeToken<Map<KEYTO, VALUETO>>(){}.where(new TypeParameter<KEYTO>(){}, keyProperty.valueToTypeToken).where(new TypeParameter<VALUETO>(){}, valueProperty.valueToTypeToken), fieldInfo);
        this.frozen = frozen;
        this.emptyCollectionIfNull = emptyCollectionIfNull;
        this.keyProperty = keyProperty;
        this.valueProperty = valueProperty;
    }

    public KEYTO encodeSingleKeyElement(KEYFROM javaValue) {
        return this.encodeSingleKeyElement(javaValue, Optional.empty());
    }

    public KEYTO encodeSingleKeyElement(KEYFROM javaValue, Optional<CassandraOptions> cassandraOptions) {
        return this.keyProperty.encodeFromRaw(javaValue, cassandraOptions);
    }

    public VALUETO encodeSingleValueElement(VALUEFROM javaValue) {
        return this.encodeSingleValueElement(javaValue, Optional.empty());
    }

    public VALUETO encodeSingleValueElement(VALUEFROM javaValue, Optional<CassandraOptions> cassandraOptions) {
        return this.valueProperty.encodeFromRaw(javaValue, cassandraOptions);
    }

    @Override
    boolean isOptional() {
        return false;
    }

    @Override
    public void encodeToSettable(Map<KEYTO, VALUETO> mapTo, SettableData<?> settableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode '%s' map value %s to settable object %s", this.fieldName, mapTo, settableData));
        }
        settableData.setMap(this.fieldInfo.quotedCqlColumn, mapTo, this.keyProperty.valueToTypeToken, this.valueProperty.valueToTypeToken);
    }

    @Override
    public Map<KEYTO, VALUETO> encodeFromJavaInternal(Map<KEYFROM, VALUEFROM> map, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' map %s to CQL type", this.fieldName, map));
        }
        return new HashMap<Object, Object>(map.entrySet().stream().collect(Collectors.toMap(entry -> this.keyProperty.encodeFromRaw(entry.getKey(), cassandraOptions), entry -> this.valueProperty.encodeFromRaw(entry.getValue(), cassandraOptions))));
    }

    @Override
    public Map<KEYTO, VALUETO> encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' map object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)Map.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be Map", (Object[])new Object[]{o});
        return (Map)this.encodeFromJava((Map)o, cassandraOptions);
    }

    @Override
    public Map<KEYFROM, VALUEFROM> decodeFromGettable(GettableData gettableData) {
        if (gettableData.isNull(NamingHelper.maybeQuote(this.getColumnForSelect())) && !this.emptyCollectionIfNull) {
            return null;
        }
        return this.decodeFromGettableInternal(gettableData);
    }

    @Override
    public Map<KEYFROM, VALUEFROM> decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' map from gettable object %s", this.fieldName, gettableData));
        }
        return this.decodeFromRaw(gettableData.getMap(this.fieldInfo.quotedCqlColumn, this.keyProperty.valueToTypeToken, this.valueProperty.valueToTypeToken));
    }

    @Override
    public Map<KEYFROM, VALUEFROM> decodeFromRaw(Object o) {
        return this.decodeFromRawInternal(o);
    }

    @Override
    public Map<KEYFROM, VALUEFROM> decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' map raw object %s", this.fieldName, o));
        }
        if (o == null) {
            if (this.emptyCollectionIfNull) {
                return new HashMap();
            }
            return null;
        }
        Validator.validateTrue((boolean)Map.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be Map<%s,%s>", (Object[])new Object[]{o, this.keyProperty.valueToTypeToken, this.valueProperty.valueToTypeToken});
        return new HashMap<Object, Object>(((Map)o).entrySet().stream().collect(Collectors.toMap(entry -> this.keyProperty.decodeFromRaw(entry.getKey()), entry -> this.valueProperty.decodeFromRaw(entry.getValue()))));
    }

    public KEYFROM decodeSingleKeyElement(KEYTO cassandraValue) {
        return this.keyProperty.decodeFromRaw(cassandraValue);
    }

    public VALUEFROM decodeSingleValueElement(VALUETO cassandraValue) {
        return this.valueProperty.decodeFromRaw(cassandraValue);
    }

    @Override
    public DataType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' map data type", this.fieldName));
        }
        DataType keyType = this.keyProperty.buildType(cassandraOptions);
        DataType valueType = this.valueProperty.buildType(cassandraOptions);
        if (this.frozen) {
            return DataType.frozenMap((DataType)keyType, (DataType)valueType);
        }
        return DataType.map((DataType)keyType, (DataType)valueType);
    }

    @Override
    public void encodeFieldToUdt(ENTITY entity, UDTValue udtValue, Optional<CassandraOptions> cassandraOptions) {
        Map valueTo = (Map)this.encodeField(entity, cassandraOptions);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode '%s' map %s to UDT value %s", this.fieldName, valueTo, udtValue));
        }
        udtValue.set(this.fieldInfo.quotedCqlColumn, (Object)valueTo, this.valueToTypeToken);
    }

    @Override
    public boolean containsUDTProperty() {
        return this.keyProperty.containsUDTProperty() || this.valueProperty.containsUDTProperty();
    }

    @Override
    public List<AbstractUDTClassProperty<?>> getUDTClassProperties() {
        return CollectionsHelper.appendAll(this.keyProperty.getUDTClassProperties(), this.valueProperty.getUDTClassProperties());
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
        this.keyProperty.inject(userTypeFactory, tupleTypeFactory);
        this.valueProperty.inject(userTypeFactory, tupleTypeFactory);
    }

    @Override
    public void inject(ObjectMapper mapper) {
        this.keyProperty.inject(mapper);
        this.valueProperty.inject(mapper);
    }

    @Override
    public void inject(BeanFactory factory) {
        this.keyProperty.inject(factory);
        this.valueProperty.inject(factory);
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        this.keyProperty.injectRuntimeCodecs(runtimeCodecs);
        this.valueProperty.injectRuntimeCodecs(runtimeCodecs);
    }

    @Override
    public void injectKeyspace(String keyspace) {
        this.keyProperty.injectKeyspace(keyspace);
        this.valueProperty.injectKeyspace(keyspace);
    }

    @Override
    public void inject(SchemaNameProvider schemaNameProvider) {
        super.inject(schemaNameProvider);
        this.keyProperty.inject(schemaNameProvider);
        this.valueProperty.inject(schemaNameProvider);
    }
}

