/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.cql.TupleExtractor;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractTupleProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.tuples.Tuple1;
import info.archinnov.achilles.validation.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple1Property<ENTITY, A>
extends AbstractTupleProperty<ENTITY, Tuple1<A>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tuple1.class);
    private final AbstractProperty<ENTITY, A, ?> aProperty;

    public Tuple1Property(FieldInfo<ENTITY, Tuple1<A>> fieldInfo, AbstractProperty<ENTITY, A, ?> aProperty) {
        super(new TypeToken<Tuple1<A>>(){}, fieldInfo);
        this.aProperty = aProperty;
    }

    @Override
    public TupleValue encodeFromJavaInternal(Tuple1<A> tuple1, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' tuple1 %s to CQL type", this.fieldName, tuple1));
        }
        return this.getRuntimeTupleType(cassandraOptions).newValue(new Object[]{this.aProperty.encodeFromRaw(tuple1._1(), cassandraOptions)});
    }

    @Override
    public TupleValue encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' tuple1 object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)Tuple1.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be Tuple1", (Object[])new Object[]{o});
        return (TupleValue)this.encodeFromJava((Tuple1)o, cassandraOptions);
    }

    @Override
    public Tuple1<A> decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple1 from gettable object %s", this.fieldName, gettableData));
        }
        return (Tuple1)this.decodeFromRaw(gettableData.getTupleValue(this.fieldInfo.quotedCqlColumn));
    }

    @Override
    public Tuple1<A> decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple1 raw object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)TupleValue.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be %s", (Object[])new Object[]{o, TupleValue.class.getCanonicalName()});
        List types = this.tupleType.getComponentTypes();
        return new Tuple1(this.aProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(0), this.aProperty, 0)));
    }

    @Override
    public TupleType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' tuple1 data type", this.fieldName));
        }
        return this.tupleTypeFactory.typeFor(this.aProperty.buildType(cassandraOptions));
    }

    @Override
    protected List<AbstractProperty<ENTITY, ?, ?>> componentsProperty() {
        return Arrays.asList(this.aProperty);
    }
}

