/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.cql.TupleExtractor;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractTupleProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.tuples.Tuple2;
import info.archinnov.achilles.validation.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple2Property<ENTITY, A, B>
extends AbstractTupleProperty<ENTITY, Tuple2<A, B>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tuple2.class);
    private final AbstractProperty<ENTITY, A, ?> aProperty;
    private final AbstractProperty<ENTITY, B, ?> bProperty;

    public Tuple2Property(FieldInfo<ENTITY, Tuple2<A, B>> fieldInfo, AbstractProperty<ENTITY, A, ?> aProperty, AbstractProperty<ENTITY, B, ?> bProperty) {
        super(new TypeToken<Tuple2<A, B>>(){}, fieldInfo);
        this.aProperty = aProperty;
        this.bProperty = bProperty;
    }

    @Override
    TupleValue encodeFromJavaInternal(Tuple2<A, B> tuple2, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' tuple2 %s to CQL type", this.fieldName, tuple2));
        }
        return this.getRuntimeTupleType(cassandraOptions).newValue(new Object[]{this.aProperty.encodeFromRaw(tuple2._1(), cassandraOptions), this.bProperty.encodeFromRaw(tuple2._2(), cassandraOptions)});
    }

    @Override
    TupleValue encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' tuple2 object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)Tuple2.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be Tuple2", (Object[])new Object[]{o});
        return (TupleValue)this.encodeFromJava((Tuple2)o, cassandraOptions);
    }

    @Override
    Tuple2<A, B> decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple2 from gettable object %s", this.fieldName, gettableData));
        }
        return (Tuple2)this.decodeFromRaw(gettableData.getTupleValue(this.fieldInfo.quotedCqlColumn));
    }

    @Override
    Tuple2<A, B> decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple2 raw object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)TupleValue.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be %s", (Object[])new Object[]{o, TupleValue.class.getCanonicalName()});
        List types = this.tupleType.getComponentTypes();
        return new Tuple2(this.aProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(0), this.aProperty, 0)), this.bProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(1), this.bProperty, 1)));
    }

    @Override
    public TupleType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' tuple2 data type", this.fieldName));
        }
        return this.tupleTypeFactory.typeFor(this.aProperty.buildType(cassandraOptions), this.bProperty.buildType(cassandraOptions));
    }

    @Override
    protected List<AbstractProperty<ENTITY, ?, ?>> componentsProperty() {
        return Arrays.asList(this.aProperty, this.bProperty);
    }
}

