/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser;

import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.TargetType;
import info.archinnov.achilles.annotations.ASCII;
import info.archinnov.achilles.annotations.ClusteringColumn;
import info.archinnov.achilles.annotations.Codec;
import info.archinnov.achilles.annotations.Computed;
import info.archinnov.achilles.annotations.Counter;
import info.archinnov.achilles.annotations.DSE_Search;
import info.archinnov.achilles.annotations.EmptyCollectionIfNull;
import info.archinnov.achilles.annotations.Enumerated;
import info.archinnov.achilles.annotations.Frozen;
import info.archinnov.achilles.annotations.FunctionRegistry;
import info.archinnov.achilles.annotations.Index;
import info.archinnov.achilles.annotations.JSON;
import info.archinnov.achilles.annotations.MaterializedView;
import info.archinnov.achilles.annotations.PartitionKey;
import info.archinnov.achilles.annotations.RuntimeCodec;
import info.archinnov.achilles.annotations.SASI;
import info.archinnov.achilles.annotations.TimeUUID;
import info.archinnov.achilles.annotations.UDT;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.parser.CodecFactory;
import info.archinnov.achilles.internals.parser.context.CodecContext;
import info.archinnov.achilles.internals.parser.context.DSESearchInfoContext;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.parser.context.IndexInfoContext;
import info.archinnov.achilles.internals.parser.context.RuntimeCodecContext;
import info.archinnov.achilles.internals.parser.context.SASIInfoContext;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.type.tuples.Tuple1;
import info.archinnov.achilles.type.tuples.Tuple10;
import info.archinnov.achilles.type.tuples.Tuple2;
import info.archinnov.achilles.type.tuples.Tuple3;
import info.archinnov.achilles.type.tuples.Tuple4;
import info.archinnov.achilles.type.tuples.Tuple5;
import info.archinnov.achilles.type.tuples.Tuple6;
import info.archinnov.achilles.type.tuples.Tuple7;
import info.archinnov.achilles.type.tuples.Tuple8;
import info.archinnov.achilles.type.tuples.Tuple9;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.internal.compiler.apt.model.DeclaredTypeImplContainer;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeMirrorImpl;
import org.eclipse.jdt.internal.compiler.apt.model.VariableElementImpl;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class AnnotationTree {
    private Map<Class<? extends Annotation>, TypedMap> annotations = new LinkedHashMap<Class<? extends Annotation>, TypedMap>();
    private TypeMirror currentType;
    private AnnotationTree next;
    private int depth = 1;

    AnnotationTree(TypeMirror currentType, Map<Class<? extends Annotation>, TypedMap> annotations, int currentDepth) {
        this.annotations = annotations;
        this.currentType = currentType;
        this.depth = currentDepth;
    }

    public static AnnotationTree buildFromMethodForReturnType(AptUtils aptUtils, ExecutableElement method) {
        if (AptUtils.isJavaCompiler(method)) {
            TypeMirror returnType = method.getReturnType();
            SymbolMetadata metadata = ((Symbol.MethodSymbol)method).getMetadata();
            List<Attribute.TypeCompound> typeAttributes = metadata == null ? Arrays.asList(new Attribute.TypeCompound[0]) : metadata.getTypeAttributes();
            Map<Class<? extends Annotation>, TypedMap> annotationInfo = typeAttributes.stream().filter(x -> x.getPosition().type == TargetType.METHOD_RETURN && x.getPosition().location.size() == 0).map(x -> x).collect(Collectors.toMap(x -> AnnotationTree.toAnnotation_Javac(aptUtils, x), x -> AnnotationTree.inspectSupportedAnnotation_Javac(aptUtils, returnType, x)));
            AnnotationTree annotationTree = new AnnotationTree(returnType, annotationInfo, 1);
            List<? extends TypeMirror> nestedTypes = returnType.getKind() == TypeKind.DECLARED ? MoreTypes.asDeclared((TypeMirror)returnType).getTypeArguments() : Arrays.asList(new TypeMirror[0]);
            List<Attribute.TypeCompound> nestedTypeAttributes = typeAttributes.stream().filter(x -> x.getPosition().type == TargetType.METHOD_RETURN && x.getPosition().location.size() > 0).collect(Collectors.toList());
            AnnotationTree.buildTree_Javac(aptUtils, annotationTree, 1, nestedTypes, nestedTypeAttributes);
            return annotationTree;
        }
        if (AptUtils.isEclipseCompiler(method)) {
            TypeMirror returnType = method.getReturnType();
            List<? extends TypeMirror> nestedTypes = returnType.getKind() == TypeKind.DECLARED ? MoreTypes.asDeclared((TypeMirror)returnType).getTypeArguments() : Arrays.asList(new TypeMirror[0]);
            TypeBinding binding = (TypeBinding)DeclaredTypeImplContainer.from((TypeMirrorImpl)returnType).getBinding();
            List<AnnotationBinding> annotationBindings = Arrays.asList(binding.getTypeAnnotations());
            Map<Class<? extends Annotation>, TypedMap> annotationInfo = annotationBindings.stream().filter(annotBinding -> {
                String annotationName = annotBinding.getAnnotationType().debugName();
                return JSON.class.getCanonicalName().equals(annotationName) || EmptyCollectionIfNull.class.getCanonicalName().equals(annotationName) || Enumerated.class.getCanonicalName().equals(annotationName) || Frozen.class.getCanonicalName().equals(annotationName) || Computed.class.getCanonicalName().equals(annotationName) || Counter.class.getCanonicalName().equals(annotationName) || TimeUUID.class.getCanonicalName().equals(annotationName) || ASCII.class.getCanonicalName().equals(annotationName) || Codec.class.getCanonicalName().equals(annotationName) || RuntimeCodec.class.getCanonicalName().equals(annotationName) || Index.class.getCanonicalName().equals(annotationName) || PartitionKey.class.getCanonicalName().equals(annotationName) || ClusteringColumn.class.getCanonicalName().equals(annotationName);
            }).map(x -> AnnotationTree.inspectSupportedAnnotation_Ecj(aptUtils, returnType, x)).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
            AnnotationTree annotationTree = new AnnotationTree(returnType, annotationInfo, 1);
            ArrayList<TypeBinding> typeBindings = new ArrayList();
            if (binding instanceof ParameterizedTypeBinding) {
                typeBindings = Arrays.asList(((ParameterizedTypeBinding)binding).typeArguments());
            }
            AnnotationTree.buildTree_Ecj(aptUtils, annotationTree, 1, nestedTypes, typeBindings);
            return annotationTree;
        }
        aptUtils.printError("Unknown compiler, only standard Java compiler and Eclipse ECJ compiler are supported", new Object[0]);
        return null;
    }

    public static List<AnnotationTree> buildFromMethodForParam(AptUtils aptUtils, ExecutableElement method) {
        if (AptUtils.isJavaCompiler(method)) {
            ArrayList<AnnotationTree> annotationTrees = new ArrayList<AnnotationTree>(method.getParameters().size());
            SymbolMetadata metadata = ((Symbol.MethodSymbol)method).getMetadata();
            List<Attribute.TypeCompound> list = metadata == null ? Arrays.asList(new Attribute.TypeCompound[0]) : metadata.getTypeAttributes();
            List<? extends VariableElement> parameters = method.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                int finalI = i;
                VariableElement parameter = parameters.get(i);
                TypeMirror typeMirror = parameter.asType();
                Map<Class<? extends Annotation>, TypedMap> annotationInfo = list.stream().filter(x -> x.getPosition().parameter_index == finalI && x.getPosition().location.size() == 0).map(x -> x).collect(Collectors.toMap(x -> AnnotationTree.toAnnotation_Javac(aptUtils, x), x -> AnnotationTree.inspectSupportedAnnotation_Javac(aptUtils, typeMirror, x)));
                AnnotationTree annotationTree = new AnnotationTree(typeMirror, annotationInfo, 1);
                List<? extends TypeMirror> nestedTypes = typeMirror.getKind() == TypeKind.DECLARED ? MoreTypes.asDeclared((TypeMirror)typeMirror).getTypeArguments() : Arrays.asList(new TypeMirror[0]);
                List<Attribute.TypeCompound> nestedTypeAttributes = list.stream().filter(x -> x.getPosition().parameter_index == finalI && x.getPosition().location.size() > 0).collect(Collectors.toList());
                AnnotationTree.buildTree_Javac(aptUtils, annotationTree, 1, nestedTypes, nestedTypeAttributes);
                annotationTrees.add(annotationTree);
            }
            return annotationTrees;
        }
        if (AptUtils.isEclipseCompiler(method)) {
            ArrayList<AnnotationTree> annotationTrees = new ArrayList<AnnotationTree>(method.getParameters().size());
            for (VariableElement variableElement : method.getParameters()) {
                TypeMirror currentType = variableElement.asType();
                List<? extends TypeMirror> nestedTypes = currentType.getKind() == TypeKind.DECLARED ? MoreTypes.asDeclared((TypeMirror)currentType).getTypeArguments() : Arrays.asList(new TypeMirror[0]);
                TypeBinding binding = (TypeBinding)DeclaredTypeImplContainer.from((TypeMirrorImpl)currentType).getBinding();
                List<AnnotationBinding> annotationBindings = Arrays.asList(binding.getTypeAnnotations());
                Map<Class<? extends Annotation>, TypedMap> annotationInfo = annotationBindings.stream().filter(annotBinding -> {
                    String annotationName = annotBinding.getAnnotationType().debugName();
                    return JSON.class.getCanonicalName().equals(annotationName) || EmptyCollectionIfNull.class.getCanonicalName().equals(annotationName) || Enumerated.class.getCanonicalName().equals(annotationName) || Frozen.class.getCanonicalName().equals(annotationName) || Computed.class.getCanonicalName().equals(annotationName) || Counter.class.getCanonicalName().equals(annotationName) || TimeUUID.class.getCanonicalName().equals(annotationName) || ASCII.class.getCanonicalName().equals(annotationName) || Codec.class.getCanonicalName().equals(annotationName) || RuntimeCodec.class.getCanonicalName().equals(annotationName) || Index.class.getCanonicalName().equals(annotationName) || PartitionKey.class.getCanonicalName().equals(annotationName) || ClusteringColumn.class.getCanonicalName().equals(annotationName);
                }).map(x -> AnnotationTree.inspectSupportedAnnotation_Ecj(aptUtils, currentType, x)).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
                AnnotationTree annotationTree = new AnnotationTree(currentType, annotationInfo, 1);
                ArrayList<TypeBinding> typeBindings = new ArrayList();
                if (binding instanceof ParameterizedTypeBinding) {
                    typeBindings = Arrays.asList(((ParameterizedTypeBinding)binding).typeArguments());
                }
                AnnotationTree.buildTree_Ecj(aptUtils, annotationTree, 1, nestedTypes, typeBindings);
                annotationTrees.add(annotationTree);
            }
            return annotationTrees;
        }
        aptUtils.printError("Unknown compiler, only standard Java compiler and Eclipse ECJ compiler are supported", new Object[0]);
        return null;
    }

    public static AnnotationTree buildFrom(AptUtils aptUtils, GlobalParsingContext parsingContext, VariableElement varElm) {
        List<? extends TypeMirror> nestedTypes;
        String fieldName = varElm.getSimpleName().toString();
        Name className = AptUtils.enclosingClass(varElm).getQualifiedName();
        TypeMirror currentType = varElm.asType();
        Frozen frozen = varElm.getAnnotation(Frozen.class);
        JSON json = varElm.getAnnotation(JSON.class);
        Enumerated enumerated = varElm.getAnnotation(Enumerated.class);
        Codec codec = varElm.getAnnotation(Codec.class);
        RuntimeCodec runtimeCodec = varElm.getAnnotation(RuntimeCodec.class);
        Computed computed = varElm.getAnnotation(Computed.class);
        Counter counter = varElm.getAnnotation(Counter.class);
        TimeUUID timeUUID = varElm.getAnnotation(TimeUUID.class);
        ASCII ascii = varElm.getAnnotation(ASCII.class);
        parsingContext.fieldValidator().validateCompatibleCodecAnnotationsOnField(aptUtils, fieldName, className, frozen, json, enumerated, codec, runtimeCodec, computed, counter, timeUUID, ascii);
        List<? extends TypeMirror> list = nestedTypes = currentType.getKind() == TypeKind.DECLARED ? MoreTypes.asDeclared((TypeMirror)currentType).getTypeArguments() : Arrays.asList(new TypeMirror[0]);
        if (AptUtils.isEclipseCompiler(varElm)) {
            FieldBinding binding = (FieldBinding)((VariableElementImpl)varElm)._binding;
            List<AnnotationBinding> annotationBindings = Arrays.asList(binding.getAnnotations());
            Map<Class<? extends Annotation>, TypedMap> annotationInfo = annotationBindings.stream().filter(annotBinding -> {
                String annotationName = annotBinding.getAnnotationType().debugName();
                return JSON.class.getCanonicalName().equals(annotationName) || EmptyCollectionIfNull.class.getCanonicalName().equals(annotationName) || Enumerated.class.getCanonicalName().equals(annotationName) || Frozen.class.getCanonicalName().equals(annotationName) || Computed.class.getCanonicalName().equals(annotationName) || Counter.class.getCanonicalName().equals(annotationName) || TimeUUID.class.getCanonicalName().equals(annotationName) || ASCII.class.getCanonicalName().equals(annotationName) || Codec.class.getCanonicalName().equals(annotationName) || RuntimeCodec.class.getCanonicalName().equals(annotationName) || Index.class.getCanonicalName().equals(annotationName) || SASI.class.getCanonicalName().equals(annotationName) || DSE_Search.class.getCanonicalName().equals(annotationName) || PartitionKey.class.getCanonicalName().equals(annotationName) || ClusteringColumn.class.getCanonicalName().equals(annotationName);
            }).map(x -> AnnotationTree.inspectSupportedAnnotation_Ecj(aptUtils, currentType, x)).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
            AnnotationTree annotationTree = new AnnotationTree(currentType, annotationInfo, 1);
            List<TypeBinding> typeBindings = new ArrayList<TypeBinding>();
            if (binding.type instanceof ParameterizedTypeBinding) {
                typeBindings = Arrays.asList(((ParameterizedTypeBinding)binding.type).typeArguments());
            }
            AnnotationTree.buildTree_Ecj(aptUtils, annotationTree, 1, nestedTypes, typeBindings);
            return annotationTree;
        }
        if (AptUtils.isJavaCompiler(varElm)) {
            Map<Class<? extends Annotation>, TypedMap> annotationInfo = varElm.getAnnotationMirrors().stream().filter(x -> AptUtils.areSameByClass(x, JSON.class) || AptUtils.areSameByClass(x, EmptyCollectionIfNull.class) || AptUtils.areSameByClass(x, Enumerated.class) || AptUtils.areSameByClass(x, Frozen.class) || AptUtils.areSameByClass(x, Computed.class) || AptUtils.areSameByClass(x, Counter.class) || AptUtils.areSameByClass(x, TimeUUID.class) || AptUtils.areSameByClass(x, ASCII.class) || AptUtils.areSameByClass(x, Codec.class) || AptUtils.areSameByClass(x, RuntimeCodec.class) || AptUtils.areSameByClass(x, Index.class) || AptUtils.areSameByClass(x, SASI.class) || AptUtils.areSameByClass(x, DSE_Search.class) || AptUtils.areSameByClass(x, PartitionKey.class) || AptUtils.areSameByClass(x, ClusteringColumn.class)).map(x -> x).collect(Collectors.toMap(x -> AnnotationTree.toAnnotation_Javac(aptUtils, x), x -> AnnotationTree.inspectSupportedAnnotation_Javac(aptUtils, currentType, x)));
            AnnotationTree annotationTree = new AnnotationTree(currentType, annotationInfo, 1);
            SymbolMetadata metadata = ((Symbol.VarSymbol)varElm).getMetadata();
            List<Attribute.TypeCompound> typeAttributes = metadata == null ? Arrays.asList(new Attribute.TypeCompound[0]) : metadata.getTypeAttributes();
            AnnotationTree.buildTree_Javac(aptUtils, annotationTree, 1, nestedTypes, typeAttributes);
            return annotationTree;
        }
        aptUtils.printError("Unknown compiler, only standard Java compiler and Eclipse ECJ compiler are supported", new Object[0]);
        return null;
    }

    private static AnnotationTree buildTree_Javac(AptUtils aptUtils, AnnotationTree annotationTree, int depth, List<? extends TypeMirror> nestedTypes, List<Attribute.TypeCompound> typeAttributes) {
        TypeMirror currentType = annotationTree.currentType;
        boolean hasJson = AptUtils.containsAnnotation(annotationTree, JSON.class);
        if (hasJson) {
            return annotationTree;
        }
        if (AptUtils.isPrimitive(currentType) || AptUtils.isArray(currentType) || AptUtils.isAnEnum(currentType) || nestedTypes.size() == 0) {
            return annotationTree;
        }
        if (aptUtils.isAssignableFrom(Tuple1.class, currentType) || aptUtils.isAssignableFrom(List.class, currentType) || aptUtils.isAssignableFrom(Set.class, currentType) || aptUtils.isAssignableFrom(Optional.class, currentType)) {
            TypeMirror typeMirror = nestedTypes.get(0);
            Map<Class<? extends Annotation>, TypedMap> annotationsInfo = typeAttributes.stream().filter(x -> x.getPosition().location.size() == depth).collect(Collectors.toMap(x -> AnnotationTree.toAnnotation_Javac(aptUtils, x), x -> AnnotationTree.inspectSupportedAnnotation_Javac(aptUtils, currentType, x)));
            AnnotationTree newTree = annotationTree.addNext(new AnnotationTree(typeMirror, annotationsInfo, depth + 1));
            List<Attribute.TypeCompound> newTypeAttributes = typeAttributes.stream().filter(x -> x.getPosition().location.size() != depth).collect(Collectors.toList());
            return AnnotationTree.buildTree_Javac(aptUtils, newTree, depth + 1, AnnotationTree.getTypeArguments(typeMirror), newTypeAttributes);
        }
        if (aptUtils.isAssignableFrom(Tuple2.class, currentType) || aptUtils.isAssignableFrom(Map.class, annotationTree.currentType)) {
            return AnnotationTree.buildTreeForTuple_Javac(aptUtils, annotationTree, depth, 2, nestedTypes, typeAttributes);
        }
        if (aptUtils.isAssignableFrom(Tuple3.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Javac(aptUtils, annotationTree, depth, 3, nestedTypes, typeAttributes);
        }
        if (aptUtils.isAssignableFrom(Tuple4.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Javac(aptUtils, annotationTree, depth, 4, nestedTypes, typeAttributes);
        }
        if (aptUtils.isAssignableFrom(Tuple5.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Javac(aptUtils, annotationTree, depth, 5, nestedTypes, typeAttributes);
        }
        if (aptUtils.isAssignableFrom(Tuple6.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Javac(aptUtils, annotationTree, depth, 6, nestedTypes, typeAttributes);
        }
        if (aptUtils.isAssignableFrom(Tuple7.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Javac(aptUtils, annotationTree, depth, 7, nestedTypes, typeAttributes);
        }
        if (aptUtils.isAssignableFrom(Tuple8.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Javac(aptUtils, annotationTree, depth, 8, nestedTypes, typeAttributes);
        }
        if (aptUtils.isAssignableFrom(Tuple9.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Javac(aptUtils, annotationTree, depth, 9, nestedTypes, typeAttributes);
        }
        if (aptUtils.isAssignableFrom(Tuple10.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Javac(aptUtils, annotationTree, depth, 10, nestedTypes, typeAttributes);
        }
        if (aptUtils.getAnnotationOnClass(currentType, UDT.class).isPresent()) {
            return annotationTree;
        }
        if (nestedTypes.size() == 0) {
            return annotationTree;
        }
        throw new IllegalStateException("Unknown current type : " + currentType.toString());
    }

    private static AnnotationTree buildTree_Ecj(AptUtils aptUtils, AnnotationTree annotationTree, int depth, List<? extends TypeMirror> nestedTypes, List<TypeBinding> typeBindings) {
        TypeMirror currentType = annotationTree.currentType;
        if (AptUtils.containsAnnotation(annotationTree, JSON.class)) {
            return annotationTree;
        }
        if (AptUtils.isPrimitive(currentType) || AptUtils.isArray(currentType) || AptUtils.isAnEnum(currentType) || nestedTypes.size() == 0) {
            return annotationTree;
        }
        if (aptUtils.isAssignableFrom(Tuple1.class, currentType) || aptUtils.isAssignableFrom(List.class, currentType) || aptUtils.isAssignableFrom(Set.class, currentType) || aptUtils.isAssignableFrom(Optional.class, currentType)) {
            TypeMirror typeMirror = nestedTypes.get(0);
            TypeBinding nestedTypeBinding = typeBindings.get(0);
            Map<Class<? extends Annotation>, TypedMap> annotationsInfo = Arrays.asList(nestedTypeBinding.getTypeAnnotations()).stream().map(annotBinding -> AnnotationTree.inspectSupportedAnnotation_Ecj(aptUtils, currentType, annotBinding)).collect(Collectors.toMap(pair -> (Class)pair._1(), pair -> (TypedMap)pair._2()));
            AnnotationTree newTree = annotationTree.addNext(new AnnotationTree(typeMirror, annotationsInfo, depth + 1));
            ArrayList<TypeBinding> nestedBindings = new ArrayList();
            if (nestedTypeBinding instanceof ParameterizedTypeBinding) {
                nestedBindings = Arrays.asList(((ParameterizedTypeBinding)nestedTypeBinding).typeArguments());
            }
            return AnnotationTree.buildTree_Ecj(aptUtils, newTree, depth + 1, AnnotationTree.getTypeArguments(typeMirror), nestedBindings);
        }
        if (aptUtils.isAssignableFrom(Tuple2.class, currentType) || aptUtils.isAssignableFrom(Map.class, annotationTree.currentType)) {
            return AnnotationTree.buildTreeForTuple_Ecj(aptUtils, currentType, annotationTree, depth, 2, nestedTypes, typeBindings);
        }
        if (aptUtils.isAssignableFrom(Tuple3.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Ecj(aptUtils, currentType, annotationTree, depth, 3, nestedTypes, typeBindings);
        }
        if (aptUtils.isAssignableFrom(Tuple4.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Ecj(aptUtils, currentType, annotationTree, depth, 4, nestedTypes, typeBindings);
        }
        if (aptUtils.isAssignableFrom(Tuple5.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Ecj(aptUtils, currentType, annotationTree, depth, 5, nestedTypes, typeBindings);
        }
        if (aptUtils.isAssignableFrom(Tuple6.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Ecj(aptUtils, currentType, annotationTree, depth, 6, nestedTypes, typeBindings);
        }
        if (aptUtils.isAssignableFrom(Tuple7.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Ecj(aptUtils, currentType, annotationTree, depth, 7, nestedTypes, typeBindings);
        }
        if (aptUtils.isAssignableFrom(Tuple8.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Ecj(aptUtils, currentType, annotationTree, depth, 8, nestedTypes, typeBindings);
        }
        if (aptUtils.isAssignableFrom(Tuple9.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Ecj(aptUtils, currentType, annotationTree, depth, 9, nestedTypes, typeBindings);
        }
        if (aptUtils.isAssignableFrom(Tuple10.class, currentType)) {
            return AnnotationTree.buildTreeForTuple_Ecj(aptUtils, currentType, annotationTree, depth, 10, nestedTypes, typeBindings);
        }
        if (aptUtils.getAnnotationOnClass(currentType, UDT.class).isPresent()) {
            return annotationTree;
        }
        throw new IllegalStateException("Unknown current type : " + currentType.toString());
    }

    private static List<? extends TypeMirror> getTypeArguments(TypeMirror typeMirror) {
        if (AptUtils.isPrimitive(typeMirror) || AptUtils.isArray(typeMirror)) {
            return Collections.emptyList();
        }
        return MoreTypes.asDeclared((TypeMirror)typeMirror).getTypeArguments();
    }

    private static AnnotationTree buildTreeForTuple_Javac(AptUtils aptUtils, AnnotationTree annotationTree, int depth, int cardinality, List<? extends TypeMirror> nestedTypes, List<Attribute.TypeCompound> typeAttributes) {
        List annotations = typeAttributes.stream().filter(x -> x.getPosition().location.size() == depth).collect(Collectors.toList());
        ArrayList<Attribute.TypeCompound> newTypeAttributes = new ArrayList<Attribute.TypeCompound>(typeAttributes);
        newTypeAttributes.removeAll(annotations);
        AnnotationTree recursiveTreeN = annotationTree;
        int i = 0;
        while (i < cardinality) {
            TypeMirror typeMirrorN = nestedTypes.get(i);
            int j = i++;
            TypeMirror currentType = recursiveTreeN.currentType;
            Map<Class<? extends Annotation>, TypedMap> annotsN = annotations.stream().filter(x -> x.getPosition().location.get((int)(depth - 1)).arg == j).collect(Collectors.toMap(x -> AnnotationTree.toAnnotation_Javac(aptUtils, x), x -> AnnotationTree.inspectSupportedAnnotation_Javac(aptUtils, currentType, x)));
            AnnotationTree newTreeN = recursiveTreeN.addNext(new AnnotationTree(typeMirrorN, annotsN, depth + 1));
            recursiveTreeN = AnnotationTree.buildTree_Javac(aptUtils, newTreeN, depth + 1, AnnotationTree.getTypeArguments(typeMirrorN), newTypeAttributes);
        }
        return recursiveTreeN;
    }

    private static AnnotationTree buildTreeForTuple_Ecj(AptUtils aptUtils, TypeMirror currentType, AnnotationTree annotationTree, int depth, int cardinality, List<? extends TypeMirror> nestedTypes, List<TypeBinding> typeBindings) {
        AnnotationTree recursiveTreeN = annotationTree;
        for (int i = 0; i < cardinality; ++i) {
            TypeMirror typeMirrorN = nestedTypes.get(i);
            TypeBinding typeBinding = typeBindings.get(i);
            Map<Class<? extends Annotation>, TypedMap> annotationsInfo = Arrays.asList(typeBinding.getTypeAnnotations()).stream().map(annotBinding -> AnnotationTree.inspectSupportedAnnotation_Ecj(aptUtils, currentType, annotBinding)).collect(Collectors.toMap(pair -> (Class)pair._1(), pair -> (TypedMap)pair._2()));
            ArrayList<TypeBinding> nestedBindings = new ArrayList();
            if (typeBinding instanceof ParameterizedTypeBinding) {
                nestedBindings = Arrays.asList(((ParameterizedTypeBinding)typeBinding).typeArguments());
            }
            AnnotationTree newTreeN = recursiveTreeN.addNext(new AnnotationTree(typeMirrorN, annotationsInfo, depth + 1));
            recursiveTreeN = AnnotationTree.buildTree_Ecj(aptUtils, newTreeN, depth + 1, AnnotationTree.getTypeArguments(typeMirrorN), nestedBindings);
        }
        return recursiveTreeN;
    }

    AnnotationTree addNext(AnnotationTree next) {
        this.next = next;
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public AnnotationTree next() {
        if (this.hasNext()) {
            return this.next;
        }
        throw new IllegalStateException(String.format("No more leaf for annotation tree. Current type = %s, depth = %s", this.currentType.toString(), this.depth));
    }

    public Map<Class<? extends Annotation>, TypedMap> getAnnotations() {
        return this.annotations;
    }

    public TypeMirror getCurrentType() {
        return this.currentType;
    }

    public int depth() {
        return this.depth;
    }

    private static TypedMap inspectSupportedAnnotation_Javac(AptUtils aptUtils, TypeMirror currentType, AnnotationMirror annotation) {
        TypedMap typedMap = new TypedMap();
        if (AptUtils.areSameByClass(annotation, Enumerated.class)) {
            Enumerated.Encoding encoding = AptUtils.getElementValueEnum(annotation, "value", Enumerated.Encoding.class, true);
            return TypedMap.of((String)"value", (Object)encoding);
        }
        if (AptUtils.areSameByClass(annotation, Codec.class)) {
            CodecContext codecContext = CodecFactory.buildCodecContext(aptUtils, annotation);
            return TypedMap.of((String)"codecContext", (Object)codecContext);
        }
        if (AptUtils.areSameByClass(annotation, RuntimeCodec.class)) {
            RuntimeCodecContext runtimeCodecContext = CodecFactory.buildRuntimeCodecContext(currentType, annotation);
            return TypedMap.of((String)"runtimeCodecContext", (Object)runtimeCodecContext);
        }
        if (AptUtils.areSameByClass(annotation, Computed.class)) {
            String function = AptUtils.getElementValue(annotation, "function", String.class, false);
            Optional cqlClass = AptUtils.getElementValueClass(annotation, "cqlClass", false);
            aptUtils.validateTrue(cqlClass.isPresent(), "Cannot find 'cqlClass' attribute value on annotation %s", Computed.class.getCanonicalName());
            String alias = AptUtils.getElementValue(annotation, "alias", String.class, false);
            List<String> targetColumns = AptUtils.getElementValueArray(annotation, "targetColumns", String.class, false);
            typedMap.put((Object)"function", (Object)function);
            typedMap.put((Object)"cqlClass", cqlClass.get());
            typedMap.put((Object)"alias", (Object)alias);
            typedMap.put((Object)"targetColumns", targetColumns);
            return typedMap;
        }
        if (AptUtils.areSameByClass(annotation, Index.class)) {
            String indexName = AptUtils.getElementValue(annotation, "name", String.class, true);
            String indexOptions = AptUtils.getElementValue(annotation, "indexOptions", String.class, true);
            String indexClassName = AptUtils.getElementValue(annotation, "indexClassName", String.class, true);
            typedMap.put((Object)"indexInfoContext", (Object)new IndexInfoContext(indexName, indexClassName, indexOptions));
            return typedMap;
        }
        if (AptUtils.areSameByClass(annotation, SASI.class)) {
            String indexName = AptUtils.getElementValue(annotation, "name", String.class, true);
            SASI.IndexMode indexMode = AptUtils.getElementValueEnum(annotation, "indexMode", SASI.IndexMode.class, true);
            boolean analyzed = AptUtils.getElementValue(annotation, "analyzed", Boolean.class, true);
            SASI.Analyzer analyzerClass = AptUtils.getElementValueEnum(annotation, "analyzerClass", SASI.Analyzer.class, true);
            int maxCompactionFlushMemoryInMb = AptUtils.getElementValue(annotation, "maxCompactionFlushMemoryInMb", Integer.class, true);
            SASI.Normalization normalization = AptUtils.getElementValueEnum(annotation, "normalization", SASI.Normalization.class, true);
            String locale = AptUtils.getElementValue(annotation, "locale", String.class, true);
            boolean enableStemming = AptUtils.getElementValue(annotation, "enableStemming", Boolean.class, true);
            boolean skipStopWords = AptUtils.getElementValue(annotation, "skipStopWords", Boolean.class, true);
            typedMap.put((Object)"sasiInfoContext", (Object)new SASIInfoContext(indexName, indexMode, analyzed, analyzerClass, maxCompactionFlushMemoryInMb, normalization, locale, enableStemming, skipStopWords));
            return typedMap;
        }
        if (AptUtils.areSameByClass(annotation, DSE_Search.class)) {
            boolean fullTextSearchEnabled = AptUtils.getElementValue(annotation, "fullTextSearchEnabled", Boolean.class, true);
            typedMap.put((Object)"dseSearchInfoContext", (Object)new DSESearchInfoContext(fullTextSearchEnabled));
            return typedMap;
        }
        if (AptUtils.areSameByClass(annotation, PartitionKey.class)) {
            typedMap.put((Object)"order", (Object)AptUtils.getElementValue(annotation, "value", Integer.class, true));
            return typedMap;
        }
        if (AptUtils.areSameByClass(annotation, ClusteringColumn.class)) {
            typedMap.put((Object)"order", (Object)AptUtils.getElementValue(annotation, "value", Integer.class, true));
            typedMap.put((Object)"asc", (Object)AptUtils.getElementValue(annotation, "asc", Boolean.class, true));
            return typedMap;
        }
        return typedMap;
    }

    private static Class<? extends Annotation> toAnnotation_Javac(AptUtils aptUtils, AnnotationMirror annotationMirror) {
        if (AptUtils.areSameByClass(annotationMirror, JSON.class)) {
            return JSON.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, EmptyCollectionIfNull.class)) {
            return EmptyCollectionIfNull.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, Enumerated.class)) {
            return Enumerated.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, Frozen.class)) {
            return Frozen.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, Computed.class)) {
            return Computed.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, Counter.class)) {
            return Counter.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, TimeUUID.class)) {
            return TimeUUID.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, ASCII.class)) {
            return ASCII.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, Codec.class)) {
            return Codec.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, RuntimeCodec.class)) {
            return RuntimeCodec.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, Index.class)) {
            return Index.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, SASI.class)) {
            return SASI.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, DSE_Search.class)) {
            return DSE_Search.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, PartitionKey.class)) {
            return PartitionKey.class;
        }
        if (AptUtils.areSameByClass(annotationMirror, ClusteringColumn.class)) {
            return ClusteringColumn.class;
        }
        aptUtils.printError("Unsupported annotation : " + annotationMirror.toString(), new Object[0]);
        throw new IllegalArgumentException("Unsupported annotation : " + annotationMirror.toString());
    }

    private static Tuple2<Class<? extends Annotation>, TypedMap> inspectSupportedAnnotation_Ecj(AptUtils aptUtils, TypeMirror currentType, AnnotationBinding annotationBinding) {
        TypedMap typedMap = new TypedMap();
        String annotationName = annotationBinding.getAnnotationType().debugName();
        if (JSON.class.getCanonicalName().equals(annotationName)) {
            return Tuple2.of(JSON.class, (Object)typedMap);
        }
        if (EmptyCollectionIfNull.class.getCanonicalName().equals(annotationName)) {
            return Tuple2.of(EmptyCollectionIfNull.class, (Object)typedMap);
        }
        if (Enumerated.class.getCanonicalName().equals(annotationName)) {
            Enumerated.Encoding encoding = Arrays.asList(annotationBinding.getElementValuePairs()).stream().filter(pair -> new String(pair.getName()).equals("value")).map(pair -> pair.getValue()).filter(value -> value instanceof FieldBinding).map(value -> (FieldBinding)value).filter(value -> Enumerated.Encoding.class.getCanonicalName().equals(value.type.debugName())).map(value -> (Enumerated.Encoding)Enumerated.Encoding.valueOf(Enumerated.Encoding.class, (String)new String(value.name))).findFirst().orElse(Enumerated.Encoding.NAME);
            typedMap.put((Object)"value", (Object)encoding);
            return Tuple2.of(Enumerated.class, (Object)typedMap);
        }
        if (Frozen.class.getCanonicalName().equals(annotationName)) {
            return Tuple2.of(Frozen.class, (Object)typedMap);
        }
        if (Computed.class.getCanonicalName().equals(annotationName)) {
            List<ElementValuePair> pairs = Arrays.asList(annotationBinding.getElementValuePairs());
            String functionName = ((StringConstant)pairs.stream().filter(pair -> new String(pair.getName()).equals("function")).findFirst().get().getValue()).stringValue();
            String alias = ((StringConstant)pairs.stream().filter(pair -> new String(pair.getName()).equals("alias")).findFirst().get().getValue()).stringValue();
            String cqlClassName = ((ReferenceBinding)pairs.stream().filter(pair -> new String(pair.getName()).equals("cqlClass")).findFirst().get().getValue()).debugName();
            Class<?> cqlClass = null;
            try {
                cqlClass = Class.forName(cqlClassName);
            }
            catch (ClassNotFoundException e) {
                aptUtils.printError("Cannot find CQL class %s", cqlClassName);
            }
            List targetColumns = Arrays.asList((Object[])pairs.stream().filter(pair -> new String(pair.getName()).equals("targetColumns")).findFirst().get().getValue()).stream().map(object -> (StringConstant)object).map(stringConstant -> stringConstant.stringValue()).collect(Collectors.toList());
            typedMap.put((Object)"function", (Object)functionName);
            typedMap.put((Object)"alias", (Object)alias);
            typedMap.put((Object)"cqlClass", cqlClass);
            typedMap.put((Object)"targetColumns", targetColumns);
            return Tuple2.of(Computed.class, (Object)typedMap);
        }
        if (Counter.class.getCanonicalName().equals(annotationName)) {
            return Tuple2.of(Counter.class, (Object)typedMap);
        }
        if (TimeUUID.class.getCanonicalName().equals(annotationName)) {
            return Tuple2.of(TimeUUID.class, (Object)typedMap);
        }
        if (ASCII.class.getCanonicalName().equals(annotationName)) {
            return Tuple2.of(ASCII.class, (Object)typedMap);
        }
        if (Codec.class.getCanonicalName().equals(annotationName)) {
            Optional<String> codecClassName = Arrays.asList(annotationBinding.getElementValuePairs()).stream().filter(pair -> new String(pair.getName()).equals("value")).map(pair -> pair.getValue()).filter(value -> value instanceof ReferenceBinding).map(value -> ((ReferenceBinding)value).debugName()).findFirst();
            aptUtils.validateTrue(codecClassName.isPresent(), "Cannot find codec class on '%s' for type '%s", Codec.class.getCanonicalName(), currentType);
            CodecContext codecContext = CodecFactory.buildCodecContext(aptUtils, codecClassName.get());
            typedMap.put((Object)"codecContext", (Object)codecContext);
            return Tuple2.of(Codec.class, (Object)typedMap);
        }
        if (RuntimeCodec.class.getCanonicalName().equals(annotationName)) {
            List<ElementValuePair> pairs = Arrays.asList(annotationBinding.getElementValuePairs());
            Optional<String> codecName = pairs.stream().filter(pair -> new String(pair.getName()).equals("codecName")).findFirst().map(x -> (StringConstant)x.getValue()).map(x -> x.stringValue());
            String targetTypeName = ((ReferenceBinding)pairs.stream().filter(pair -> new String(pair.getName()).equals("cqlClass")).findFirst().get().getValue()).debugName();
            Class<?> targetType = null;
            try {
                targetType = Class.forName(targetTypeName);
            }
            catch (ClassNotFoundException e) {
                aptUtils.printError("Cannot find CQL class %s", targetTypeName);
            }
            RuntimeCodecContext runtimeCodecContext = new RuntimeCodecContext(TypeName.get((TypeMirror)currentType), TypeName.get(targetType), codecName);
            typedMap.put((Object)"runtimeCodecContext", (Object)runtimeCodecContext);
            return Tuple2.of(RuntimeCodec.class, (Object)typedMap);
        }
        if (Index.class.getCanonicalName().equals(annotationName)) {
            List<ElementValuePair> pairs = Arrays.asList(annotationBinding.getElementValuePairs());
            String name = pairs.stream().filter(pair -> new String(pair.getName()).equals("name")).map(pair -> ((StringConstant)pair.getValue()).stringValue()).findFirst().orElse("");
            String indexClassName = pairs.stream().filter(pair -> new String(pair.getName()).equals("indexClassName")).map(pair -> ((StringConstant)pair.getValue()).stringValue()).findFirst().orElse("");
            String indexOptions = pairs.stream().filter(pair -> new String(pair.getName()).equals("indexOptions")).map(pair -> ((StringConstant)pair.getValue()).stringValue()).findFirst().orElse("");
            typedMap.put((Object)"indexInfoContext", (Object)new IndexInfoContext(name, indexClassName, indexOptions));
            return Tuple2.of(Index.class, (Object)typedMap);
        }
        if (SASI.class.getCanonicalName().equals(annotationName)) {
            List<ElementValuePair> pairs = Arrays.asList(annotationBinding.getElementValuePairs());
            String indexName = pairs.stream().filter(pair -> new String(pair.getName()).equals("name")).map(pair -> ((StringConstant)pair.getValue()).stringValue()).findFirst().orElse("");
            SASI.IndexMode indexMode = pairs.stream().filter(pair -> new String(pair.getName()).equals("indexMode")).map(pair -> pair.getValue()).filter(value -> value instanceof FieldBinding).map(value -> (FieldBinding)value).filter(value -> SASI.IndexMode.class.getCanonicalName().equals(value.type.debugName())).map(value -> (SASI.IndexMode)SASI.IndexMode.valueOf(SASI.IndexMode.class, (String)new String(value.name))).findFirst().orElse(SASI.IndexMode.PREFIX);
            boolean analyzed = pairs.stream().filter(pair -> new String(pair.getName()).equals("analyzed")).map(pair -> ((BooleanConstant)pair.getValue()).booleanValue()).findFirst().orElse(false);
            SASI.Analyzer analyzerClass = pairs.stream().filter(pair -> new String(pair.getName()).equals("analyzerClass")).map(pair -> pair.getValue()).filter(value -> value instanceof FieldBinding).map(value -> (FieldBinding)value).filter(value -> SASI.Analyzer.class.getCanonicalName().equals(value.type.debugName())).map(value -> (SASI.Analyzer)SASI.Analyzer.valueOf(SASI.Analyzer.class, (String)new String(value.name))).findFirst().orElse(SASI.Analyzer.NO_OP_ANALYZER);
            int maxCompactionFlushMemoryInMb = pairs.stream().filter(pair -> new String(pair.getName()).equals("maxCompactionFlushMemoryInMb")).map(pair -> ((IntConstant)pair.getValue()).intValue()).findFirst().orElse(1024);
            SASI.Normalization normalization = pairs.stream().filter(pair -> new String(pair.getName()).equals("normalization")).map(pair -> pair.getValue()).filter(value -> value instanceof FieldBinding).map(value -> (FieldBinding)value).filter(value -> SASI.Normalization.class.getCanonicalName().equals(value.type.debugName())).map(value -> (SASI.Normalization)SASI.Analyzer.valueOf(SASI.Normalization.class, (String)new String(value.name))).findFirst().orElse(SASI.Normalization.NONE);
            String locale = pairs.stream().filter(pair -> new String(pair.getName()).equals("locale")).map(pair -> ((StringConstant)pair.getValue()).stringValue()).findFirst().orElse("en");
            boolean enableStemming = pairs.stream().filter(pair -> new String(pair.getName()).equals("enableStemming")).map(pair -> ((BooleanConstant)pair.getValue()).booleanValue()).findFirst().orElse(false);
            boolean skipStopWords = pairs.stream().filter(pair -> new String(pair.getName()).equals("skipStopWords")).map(pair -> ((BooleanConstant)pair.getValue()).booleanValue()).findFirst().orElse(false);
            typedMap.put((Object)"sasiInfoContext", (Object)new SASIInfoContext(indexName, indexMode, analyzed, analyzerClass, maxCompactionFlushMemoryInMb, normalization, locale, enableStemming, skipStopWords));
            return Tuple2.of(SASI.class, (Object)typedMap);
        }
        if (DSE_Search.class.getCanonicalName().equals(annotationName)) {
            List<ElementValuePair> pairs = Arrays.asList(annotationBinding.getElementValuePairs());
            boolean fullTextSearchEnabled = pairs.stream().filter(pair -> new String(pair.getName()).equals("fullTextSearchEnabled")).map(pair -> ((BooleanConstant)pair.getValue()).booleanValue()).findFirst().orElse(false);
            typedMap.put((Object)"dseSearchInfoContext", (Object)new DSESearchInfoContext(fullTextSearchEnabled));
            return Tuple2.of(DSE_Search.class, (Object)typedMap);
        }
        if (PartitionKey.class.getCanonicalName().equals(annotationName)) {
            List<ElementValuePair> pairs = Arrays.asList(annotationBinding.getElementValuePairs());
            Integer order = pairs.stream().filter(pair -> new String(pair.getName()).equals("value")).map(pair -> ((IntConstant)pair.getValue()).intValue()).findFirst().orElse(1);
            typedMap.put((Object)"order", (Object)order);
            return Tuple2.of(PartitionKey.class, (Object)typedMap);
        }
        if (ClusteringColumn.class.getCanonicalName().equals(annotationName)) {
            List<ElementValuePair> pairs = Arrays.asList(annotationBinding.getElementValuePairs());
            Integer order = pairs.stream().filter(pair -> new String(pair.getName()).equals("value")).map(pair -> ((IntConstant)pair.getValue()).intValue()).findFirst().orElse(1);
            Boolean asc = pairs.stream().filter(pair -> new String(pair.getName()).equals("asc")).map(pair -> ((BooleanConstant)pair.getValue()).booleanValue()).findFirst().orElse(true);
            typedMap.put((Object)"order", (Object)order);
            typedMap.put((Object)"asc", (Object)asc);
            return Tuple2.of(ClusteringColumn.class, (Object)typedMap);
        }
        aptUtils.printError("Unsupported annotation : " + annotationName, new Object[0]);
        throw new IllegalArgumentException("Unsupported annotation : " + annotationName.toString());
    }

    public static Optional<TypeName> findOptionalViewBaseClass(AptUtils aptUtils, TypeElement elm) {
        if (AptUtils.isJavaCompiler(elm)) {
            return AnnotationTree.findOptionalViewBaseClass_Javac(aptUtils, elm);
        }
        if (AptUtils.isEclipseCompiler(elm)) {
            return AnnotationTree.findOptionalViewBaseClass_Ecj(elm);
        }
        aptUtils.printError("Unknown compiler, only standard Java compiler and Eclipse ECJ compiler are supported", new Object[0]);
        return Optional.empty();
    }

    private static Optional<TypeName> findOptionalViewBaseClass_Javac(AptUtils aptUtils, TypeElement elm) {
        Optional<TypeName> viewBaseClass = elm.getAnnotationMirrors().stream().filter(x -> AptUtils.areSameByClass(x, MaterializedView.class)).findFirst().flatMap(view -> AptUtils.getElementValueClass(view, "baseEntity", false)).map(ClassName::get);
        if (viewBaseClass.isPresent()) {
            return viewBaseClass;
        }
        return elm.getAnnotationMirrors().stream().filter(x -> AptUtils.areSameByClass(x, MaterializedView.class)).findFirst().map(view -> AptUtils.getElementValueClassName(view, "baseEntity", false).toString()).map(baseClassName -> aptUtils.elementUtils.getTypeElement((CharSequence)baseClassName).asType()).map(TypeName::get);
    }

    private static Optional<TypeName> findOptionalViewBaseClass_Ecj(TypeElement elm) {
        return Arrays.asList(((TypeElementImpl)elm)._binding.getAnnotations()).stream().filter(annotBinding -> MaterializedView.class.getCanonicalName().equals(annotBinding.getAnnotationType().debugName())).flatMap(viewAnnot -> Arrays.asList(viewAnnot.getElementValuePairs()).stream()).filter(pair -> new String(pair.getName()).equals("baseEntity")).filter(pair -> pair.getValue() instanceof ReferenceBinding).map(pair -> (ReferenceBinding)pair.getValue()).map(x -> x.debugName()).map(ClassName::bestGuess).map(x -> x).findFirst();
    }

    public static Optional<String> findKeyspaceForFunctionRegistry(AptUtils aptUtils, TypeElement functionRegistry) {
        if (AptUtils.isJavaCompiler(functionRegistry)) {
            return functionRegistry.getAnnotationMirrors().stream().filter(x -> AptUtils.areSameByClass(x, FunctionRegistry.class)).findFirst().map(annot -> AptUtils.getElementValue(annot, "keyspace", String.class, false));
        }
        if (AptUtils.isEclipseCompiler(functionRegistry)) {
            return Arrays.asList(((TypeElementImpl)functionRegistry)._binding.getAnnotations()).stream().filter(annotBinding -> FunctionRegistry.class.getCanonicalName().equals(annotBinding.getAnnotationType().debugName())).flatMap(annot -> Arrays.asList(annot.getElementValuePairs()).stream()).filter(pair -> new String(pair.getName()).equals("keyspace")).findFirst().map(elementValuePair -> (StringConstant)elementValuePair.getValue()).map(stringConstant -> stringConstant.stringValue());
        }
        aptUtils.printError("Unknown compiler, only standard Java compiler and Eclipse ECJ compiler are supported", new Object[0]);
        return Optional.empty();
    }
}

