/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser;

import com.datastax.driver.core.GettableData;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.ASCII;
import info.archinnov.achilles.annotations.Computed;
import info.archinnov.achilles.annotations.Counter;
import info.archinnov.achilles.annotations.EmptyCollectionIfNull;
import info.archinnov.achilles.annotations.Frozen;
import info.archinnov.achilles.annotations.JSON;
import info.archinnov.achilles.annotations.TimeUUID;
import info.archinnov.achilles.annotations.UDT;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.CodecFactory;
import info.archinnov.achilles.internals.parser.FieldInfoParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.UDTParser;
import info.archinnov.achilles.internals.parser.context.EntityParsingContext;
import info.archinnov.achilles.internals.parser.context.FieldInfoContext;
import info.archinnov.achilles.internals.parser.context.FieldParsingContext;
import info.archinnov.achilles.internals.utils.NamingHelper;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.type.tuples.Tuple1;
import info.archinnov.achilles.type.tuples.Tuple10;
import info.archinnov.achilles.type.tuples.Tuple2;
import info.archinnov.achilles.type.tuples.Tuple3;
import info.archinnov.achilles.type.tuples.Tuple4;
import info.archinnov.achilles.type.tuples.Tuple5;
import info.archinnov.achilles.type.tuples.Tuple6;
import info.archinnov.achilles.type.tuples.Tuple7;
import info.archinnov.achilles.type.tuples.Tuple8;
import info.archinnov.achilles.type.tuples.Tuple9;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class FieldParser {
    static final CodeBlock NO_GETTER = CodeBlock.builder().add("gettable$$ -> null", new Object[0]).build();
    static final CodeBlock NO_UDT_SETTER = CodeBlock.builder().add("(udt$$, value$$) -> {}", new Object[0]).build();
    private final AptUtils aptUtils;
    private final CodecFactory codecFactory;
    private final FieldInfoParser fieldInfoParser;
    private final UDTParser udtParser;

    public FieldParser(AptUtils aptUtils) {
        this.aptUtils = aptUtils;
        this.codecFactory = new CodecFactory(aptUtils);
        this.fieldInfoParser = new FieldInfoParser(aptUtils);
        this.udtParser = new UDTParser(aptUtils);
    }

    public FieldMetaSignature parse(VariableElement elm, EntityParsingContext entityContext) {
        AnnotationTree annotationTree = AnnotationTree.buildFrom(this.aptUtils, entityContext.globalContext, elm);
        FieldInfoContext fieldInfoContext = this.fieldInfoParser.buildFieldInfo(elm, annotationTree, entityContext);
        FieldParsingContext context = new FieldParsingContext(entityContext, TypeUtils.getRawType(entityContext.entityType), fieldInfoContext);
        entityContext.globalContext.nestedTypesValidator().validate(this.aptUtils, annotationTree, context.fieldName, context.entityRawType);
        FieldMetaSignature fieldMetaSignature = this.parseType(annotationTree, context, TypeName.get((TypeMirror)elm.asType()));
        if (fieldMetaSignature.context.indexInfo.sasiInfoContext.isPresent()) {
            entityContext.globalContext.fieldValidator().validateSASIIndex(this.aptUtils, fieldMetaSignature);
        } else if (fieldMetaSignature.context.indexInfo.dseSearchInfoContext.isPresent()) {
            entityContext.globalContext.fieldValidator().validateDSESearchIndex(this.aptUtils, fieldMetaSignature);
        }
        return fieldMetaSignature;
    }

    protected FieldMetaSignature parseType(AnnotationTree annotationTree, FieldParsingContext context, TypeName sourceType) {
        boolean isUDT;
        TypeMirror currentTypeMirror = annotationTree.getCurrentType();
        Map<Class<? extends Annotation>, TypedMap> annotationsInfo = annotationTree.getAnnotations();
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(currentTypeMirror);
        boolean bl = isUDT = currentTypeMirror.getKind() == TypeKind.DECLARED && this.aptUtils.getAnnotationOnClass(currentTypeMirror, UDT.class).isPresent();
        if (AptUtils.containsAnnotation(annotationTree, JSON.class)) {
            return this.parseSimpleType(annotationTree, context, sourceType);
        }
        if (AptUtils.containsAnnotation(annotationTree, Computed.class)) {
            return this.parseComputedType(annotationTree, context, sourceType);
        }
        if (this.aptUtils.isAssignableFrom(Tuple1.class, currentTypeMirror)) {
            return this.parseTuple1(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(Tuple2.class, currentTypeMirror)) {
            return this.parseTuple2(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(Tuple3.class, currentTypeMirror)) {
            return this.parseTuple3(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(Tuple4.class, currentTypeMirror)) {
            return this.parseTuple4(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(Tuple5.class, currentTypeMirror)) {
            return this.parseTuple5(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(Tuple6.class, currentTypeMirror)) {
            return this.parseTuple6(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(Tuple7.class, currentTypeMirror)) {
            return this.parseTuple7(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(Tuple8.class, currentTypeMirror)) {
            return this.parseTuple8(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(Tuple9.class, currentTypeMirror)) {
            return this.parseTuple9(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(Tuple10.class, currentTypeMirror)) {
            return this.parseTuple10(annotationTree, context);
        }
        if (this.aptUtils.isAssignableFrom(List.class, currentTypeMirror)) {
            return this.parseList(annotationTree, context, annotationsInfo, typeArguments);
        }
        if (this.aptUtils.isAssignableFrom(Set.class, currentTypeMirror)) {
            return this.parseSet(annotationTree, context, annotationsInfo, typeArguments);
        }
        if (this.aptUtils.isAssignableFrom(Map.class, currentTypeMirror)) {
            return this.parseMap(annotationTree, context, annotationsInfo, typeArguments);
        }
        if (this.aptUtils.isAssignableFrom(Optional.class, currentTypeMirror)) {
            return this.parseOptional(annotationTree, context);
        }
        if (isUDT) {
            return this.udtParser.parseUDT(annotationTree, context, this);
        }
        return this.parseSimpleType(annotationTree, context, sourceType);
    }

    private FieldMetaSignature parseComputedType(AnnotationTree annotationTree, FieldParsingContext context, TypeName sourceType) {
        CodecFactory.CodecInfo codecInfo = this.codecFactory.createCodec(sourceType, annotationTree, context, Optional.empty());
        TypeName rawTargetType = TypeUtils.getRawType(codecInfo.targetType);
        TypedMap computed = AptUtils.extractTypedMap(annotationTree, Computed.class).get();
        String alias = NamingHelper.maybeQuote((String)computed.getTyped("alias"));
        CodeBlock extractor = context.buildExtractor ? CodeBlock.builder().add("gettableData$$ -> gettableData$$.$L", new Object[]{TypeUtils.gettableDataGetter(rawTargetType, alias)}).build() : NO_GETTER;
        CodeBlock typeCode = CodeBlock.builder().add("new $T<$T, $T, $T>($L, $L, $L)", new Object[]{TypeUtils.COMPUTED_PROPERTY, context.entityRawType, sourceType, codecInfo.targetType, context.fieldInfoCode, extractor, codecInfo.codecCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.COMPUTED_PROPERTY, context.entityRawType, codecInfo.sourceType, codecInfo.targetType);
        return new FieldMetaSignature(context, annotationTree.hasNext() ? annotationTree.next() : annotationTree, sourceType, codecInfo.targetType, (TypeName)propertyType, typeCode, IndexMetaSignature.simpleType(sourceType));
    }

    private FieldMetaSignature parseSimpleType(AnnotationTree annotationTree, FieldParsingContext context, TypeName sourceType) {
        CodeBlock dataType;
        CodecFactory.CodecInfo codecInfo = this.buildOrGetCodecFromRegistry(annotationTree, context, sourceType);
        TypeName rawTargetType = TypeUtils.getRawType(codecInfo.targetType);
        context.fieldValidator().validateAllowedType(this.aptUtils, rawTargetType, context);
        context.fieldValidator().validateCounter(this.aptUtils, rawTargetType, annotationTree.getAnnotations().keySet(), context);
        if (AptUtils.containsAnnotation(annotationTree, TimeUUID.class)) {
            this.aptUtils.validateTrue(codecInfo.targetType.equals((Object)TypeUtils.UUID), "Incorrect use @TimeUUID annotation on field %s of class %s because its type is not java.util.UUID", context.fieldName, context.className);
            dataType = CodeBlock.builder().add("$T.timeuuid()", new Object[]{TypeUtils.DATATYPE}).build();
        } else if (AptUtils.containsAnnotation(annotationTree, ASCII.class)) {
            this.aptUtils.validateTrue(codecInfo.targetType.equals((Object)TypeUtils.STRING), "Incorrect use @ASCII annotation on field %s of class %s because its type is not java.lang.String", context.fieldName, context.className);
            dataType = CodeBlock.builder().add("$T.ascii()", new Object[]{TypeUtils.DATATYPE}).build();
        } else {
            dataType = AptUtils.containsAnnotation(annotationTree, Counter.class) ? CodeBlock.builder().add("$T.counter()", new Object[]{TypeUtils.DATATYPE}).build() : TypeUtils.buildDataTypeFor(rawTargetType);
        }
        CodeBlock gettable = context.buildExtractor ? CodeBlock.builder().add("gettableData$$ -> gettableData$$.$L", new Object[]{TypeUtils.gettableDataGetter(rawTargetType, context.quotedCqlColumn)}).build() : NO_GETTER;
        CodeBlock settable = context.buildExtractor ? CodeBlock.builder().add("(settableData$$, value$$) -> settableData$$.$L", new Object[]{TypeUtils.settableDataSetter(rawTargetType, context.quotedCqlColumn)}).build() : NO_UDT_SETTER;
        CodeBlock typeCode = CodeBlock.builder().add("new $T<$T, $T, $T>($L, $L, $L, $L, new $T(){}, new $T(){}, $L)", new Object[]{TypeUtils.SIMPLE_PROPERTY, context.entityRawType, sourceType.box(), codecInfo.targetType.box(), context.fieldInfoCode, dataType, gettable, settable, TypeUtils.genericType(TypeUtils.TYPE_TOKEN, sourceType.box()), TypeUtils.genericType(TypeUtils.TYPE_TOKEN, codecInfo.targetType.box()), codecInfo.codecCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.SIMPLE_PROPERTY, context.entityRawType, codecInfo.sourceType.box(), codecInfo.targetType.box());
        return new FieldMetaSignature(context, annotationTree.hasNext() ? annotationTree.next() : annotationTree, sourceType, codecInfo.targetType, (TypeName)propertyType, typeCode, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseOptional(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        TypeMirror typeMirror1 = AptUtils.getTypeArguments(annotationTree.getCurrentType()).get(0);
        TypeName sourceType1 = TypeName.get((TypeMirror)typeMirror1);
        boolean frozen = AptUtils.containsAnnotation(annotationTree, Frozen.class);
        FieldMetaSignature parsingResult = this.parseType(annotationTree.next(), context.forOptionalType(context.entityRawType, sourceType1, frozen), sourceType1);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L)", new Object[]{TypeUtils.JDK_OPTIONAL_PROPERTY, context.fieldInfoCode, parsingResult.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.JDK_OPTIONAL_PROPERTY, context.entityRawType, sourceType1, parsingResult.targetType);
        return new FieldMetaSignature(context, parsingResult.annotationTree, sourceType, parsingResult.targetType, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType1));
    }

    private FieldMetaSignature parseMap(AnnotationTree annotationTree, FieldParsingContext context, Map<Class<? extends Annotation>, TypedMap> annotationsInfo, List<? extends TypeMirror> typeArguments) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        boolean hasFrozen = AptUtils.containsAnnotation(annotationsInfo.keySet(), Frozen.class);
        boolean hasEmptyCollectionIfNull = AptUtils.containsAnnotation(annotationsInfo.keySet(), EmptyCollectionIfNull.class);
        TypeMirror keyTypeMirror = typeArguments.get(0);
        TypeMirror valueTypeMirror = typeArguments.get(1);
        TypeName sourceKeyType = TypeName.get((TypeMirror)keyTypeMirror);
        FieldMetaSignature keyParsingResult = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceKeyType), sourceKeyType);
        TypeName sourceValueType = TypeName.get((TypeMirror)valueTypeMirror);
        FieldMetaSignature valueParsingResult = this.parseType(keyParsingResult.annotationTree, context.noLambda(context.entityRawType, sourceValueType), sourceValueType);
        CodeBlock typeCode = CodeBlock.builder().add("new $T<$T, $T, $T, $T, $T>($L, $L, $L, $L, $L)", new Object[]{TypeUtils.MAP_PROPERTY, context.entityRawType, sourceKeyType, keyParsingResult.targetType.box(), sourceValueType, valueParsingResult.targetType.box(), context.fieldInfoCode, hasFrozen, hasEmptyCollectionIfNull, keyParsingResult.typeCode, valueParsingResult.typeCode}).build();
        ParameterizedTypeName targetType = TypeUtils.genericType(TypeUtils.MAP, keyParsingResult.targetType, valueParsingResult.targetType);
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.MAP_PROPERTY, context.entityRawType, sourceKeyType, keyParsingResult.targetType, sourceValueType, valueParsingResult.targetType);
        return new FieldMetaSignature(context, valueParsingResult.annotationTree, sourceType, (TypeName)targetType, (TypeName)propertyType, typeCode, IndexMetaSignature.mapType(sourceKeyType, sourceValueType));
    }

    private FieldMetaSignature parseSet(AnnotationTree annotationTree, FieldParsingContext context, Map<Class<? extends Annotation>, TypedMap> annotationsInfo, List<? extends TypeMirror> typeArguments) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        boolean hasFrozen = AptUtils.containsAnnotation(annotationsInfo.keySet(), Frozen.class);
        boolean hasEmptyCollectionIfNull = AptUtils.containsAnnotation(annotationsInfo.keySet(), EmptyCollectionIfNull.class);
        TypeMirror typeMirror1 = typeArguments.get(0);
        TypeName sourceType1 = TypeName.get((TypeMirror)typeMirror1);
        FieldMetaSignature parsingResult = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        CodeBlock typeCode = CodeBlock.builder().add("new $T<>($L, $L, $L, $T.class, $L)", new Object[]{TypeUtils.SET_PROPERTY, context.fieldInfoCode, hasFrozen, hasEmptyCollectionIfNull, TypeUtils.getRawType(parsingResult.targetType).box(), parsingResult.typeCode}).build();
        ParameterizedTypeName targetType = TypeUtils.genericType(TypeUtils.SET, parsingResult.targetType);
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.SET_PROPERTY, context.entityRawType, sourceType1, parsingResult.targetType);
        return new FieldMetaSignature(context, parsingResult.annotationTree, sourceType, (TypeName)targetType, (TypeName)propertyType, typeCode, IndexMetaSignature.collectionElementType(sourceType1));
    }

    private FieldMetaSignature parseList(AnnotationTree annotationTree, FieldParsingContext context, Map<Class<? extends Annotation>, TypedMap> annotationsInfo, List<? extends TypeMirror> typeArguments) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        boolean hasFrozen = AptUtils.containsAnnotation(annotationsInfo.keySet(), Frozen.class);
        boolean hasEmptyCollectionIfNull = AptUtils.containsAnnotation(annotationsInfo.keySet(), EmptyCollectionIfNull.class);
        TypeMirror typeMirror1 = typeArguments.get(0);
        TypeName sourceType1 = TypeName.get((TypeMirror)typeMirror1);
        FieldMetaSignature parsingResult = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        CodeBlock typeCode = CodeBlock.builder().add("new $T<>($L, $L, $L, $T.class, $L)", new Object[]{TypeUtils.LIST_PROPERTY, context.fieldInfoCode, hasFrozen, hasEmptyCollectionIfNull, TypeUtils.getRawType(parsingResult.targetType).box(), parsingResult.typeCode}).build();
        ParameterizedTypeName targetType = TypeUtils.genericType(TypeUtils.LIST, parsingResult.targetType);
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.LIST_PROPERTY, context.entityRawType, sourceType1, parsingResult.targetType);
        return new FieldMetaSignature(context, parsingResult.annotationTree, sourceType, (TypeName)targetType, (TypeName)propertyType, typeCode, IndexMetaSignature.collectionElementType(sourceType1));
    }

    protected FieldMetaSignature parseTuple1(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        TypeMirror typeMirror1 = AptUtils.getTypeArguments(annotationTree.getCurrentType()).get(0);
        TypeName sourceType1 = TypeName.get((TypeMirror)typeMirror1);
        FieldMetaSignature parsingResult = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L)", new Object[]{TypeUtils.TUPLE1_PROPERTY, context.fieldInfoCode, parsingResult.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE1_PROPERTY, context.entityRawType, sourceType1);
        return new FieldMetaSignature(context, parsingResult.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseTuple2(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(annotationTree.getCurrentType());
        TypeName sourceType1 = TypeName.get((TypeMirror)typeArguments.get(0));
        TypeName sourceType2 = TypeName.get((TypeMirror)typeArguments.get(1));
        FieldMetaSignature parsingResult1 = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        FieldMetaSignature parsingResult2 = this.parseType(parsingResult1.annotationTree, context.noLambda(context.entityRawType, sourceType2), sourceType2);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L, $L)", new Object[]{TypeUtils.TUPLE2_PROPERTY, context.fieldInfoCode, parsingResult1.typeCode, parsingResult2.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE2_PROPERTY, context.entityRawType, sourceType1, sourceType2);
        return new FieldMetaSignature(context, parsingResult2.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseTuple3(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(annotationTree.getCurrentType());
        TypeName sourceType1 = TypeName.get((TypeMirror)typeArguments.get(0));
        TypeName sourceType2 = TypeName.get((TypeMirror)typeArguments.get(1));
        TypeName sourceType3 = TypeName.get((TypeMirror)typeArguments.get(2));
        FieldMetaSignature parsingResult1 = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        FieldMetaSignature parsingResult2 = this.parseType(parsingResult1.annotationTree, context.noLambda(context.entityRawType, sourceType2), sourceType2);
        FieldMetaSignature parsingResult3 = this.parseType(parsingResult2.annotationTree, context.noLambda(context.entityRawType, sourceType3), sourceType3);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L, $L, $L)", new Object[]{TypeUtils.TUPLE3_PROPERTY, context.fieldInfoCode, parsingResult1.typeCode, parsingResult2.typeCode, parsingResult3.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE3_PROPERTY, context.entityRawType, sourceType1, sourceType2, sourceType3);
        return new FieldMetaSignature(context, parsingResult3.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseTuple4(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(annotationTree.getCurrentType());
        TypeName sourceType1 = TypeName.get((TypeMirror)typeArguments.get(0));
        TypeName sourceType2 = TypeName.get((TypeMirror)typeArguments.get(1));
        TypeName sourceType3 = TypeName.get((TypeMirror)typeArguments.get(2));
        TypeName sourceType4 = TypeName.get((TypeMirror)typeArguments.get(3));
        FieldMetaSignature parsingResult1 = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        FieldMetaSignature parsingResult2 = this.parseType(parsingResult1.annotationTree, context.noLambda(context.entityRawType, sourceType2), sourceType2);
        FieldMetaSignature parsingResult3 = this.parseType(parsingResult2.annotationTree, context.noLambda(context.entityRawType, sourceType3), sourceType3);
        FieldMetaSignature parsingResult4 = this.parseType(parsingResult3.annotationTree, context.noLambda(context.entityRawType, sourceType4), sourceType4);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L, $L, $L, $L)", new Object[]{TypeUtils.TUPLE4_PROPERTY, context.fieldInfoCode, parsingResult1.typeCode, parsingResult2.typeCode, parsingResult3.typeCode, parsingResult4.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE4_PROPERTY, context.entityRawType, sourceType1, sourceType2, sourceType3, sourceType4);
        return new FieldMetaSignature(context, parsingResult4.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseTuple5(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(annotationTree.getCurrentType());
        TypeName sourceType1 = TypeName.get((TypeMirror)typeArguments.get(0));
        TypeName sourceType2 = TypeName.get((TypeMirror)typeArguments.get(1));
        TypeName sourceType3 = TypeName.get((TypeMirror)typeArguments.get(2));
        TypeName sourceType4 = TypeName.get((TypeMirror)typeArguments.get(3));
        TypeName sourceType5 = TypeName.get((TypeMirror)typeArguments.get(4));
        FieldMetaSignature parsingResult1 = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        FieldMetaSignature parsingResult2 = this.parseType(parsingResult1.annotationTree, context.noLambda(context.entityRawType, sourceType2), sourceType2);
        FieldMetaSignature parsingResult3 = this.parseType(parsingResult2.annotationTree, context.noLambda(context.entityRawType, sourceType3), sourceType3);
        FieldMetaSignature parsingResult4 = this.parseType(parsingResult3.annotationTree, context.noLambda(context.entityRawType, sourceType4), sourceType4);
        FieldMetaSignature parsingResult5 = this.parseType(parsingResult4.annotationTree, context.noLambda(context.entityRawType, sourceType5), sourceType5);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L, $L, $L, $L, $L)", new Object[]{TypeUtils.TUPLE5_PROPERTY, context.fieldInfoCode, parsingResult1.typeCode, parsingResult2.typeCode, parsingResult3.typeCode, parsingResult4.typeCode, parsingResult5.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE5_PROPERTY, context.entityRawType, sourceType1, sourceType2, sourceType3, sourceType4, sourceType5);
        return new FieldMetaSignature(context, parsingResult5.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseTuple6(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(annotationTree.getCurrentType());
        TypeName sourceType1 = TypeName.get((TypeMirror)typeArguments.get(0));
        TypeName sourceType2 = TypeName.get((TypeMirror)typeArguments.get(1));
        TypeName sourceType3 = TypeName.get((TypeMirror)typeArguments.get(2));
        TypeName sourceType4 = TypeName.get((TypeMirror)typeArguments.get(3));
        TypeName sourceType5 = TypeName.get((TypeMirror)typeArguments.get(4));
        TypeName sourceType6 = TypeName.get((TypeMirror)typeArguments.get(5));
        FieldMetaSignature parsingResult1 = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        FieldMetaSignature parsingResult2 = this.parseType(parsingResult1.annotationTree, context.noLambda(context.entityRawType, sourceType2), sourceType2);
        FieldMetaSignature parsingResult3 = this.parseType(parsingResult2.annotationTree, context.noLambda(context.entityRawType, sourceType3), sourceType3);
        FieldMetaSignature parsingResult4 = this.parseType(parsingResult3.annotationTree, context.noLambda(context.entityRawType, sourceType4), sourceType4);
        FieldMetaSignature parsingResult5 = this.parseType(parsingResult4.annotationTree, context.noLambda(context.entityRawType, sourceType5), sourceType5);
        FieldMetaSignature parsingResult6 = this.parseType(parsingResult5.annotationTree, context.noLambda(context.entityRawType, sourceType6), sourceType6);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L, $L, $L, $L, $L, $L)", new Object[]{TypeUtils.TUPLE6_PROPERTY, context.fieldInfoCode, parsingResult1.typeCode, parsingResult2.typeCode, parsingResult3.typeCode, parsingResult4.typeCode, parsingResult5.typeCode, parsingResult6.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE6_PROPERTY, context.entityRawType, sourceType1, sourceType2, sourceType3, sourceType4, sourceType5, sourceType6);
        return new FieldMetaSignature(context, parsingResult5.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseTuple7(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(annotationTree.getCurrentType());
        TypeName sourceType1 = TypeName.get((TypeMirror)typeArguments.get(0));
        TypeName sourceType2 = TypeName.get((TypeMirror)typeArguments.get(1));
        TypeName sourceType3 = TypeName.get((TypeMirror)typeArguments.get(2));
        TypeName sourceType4 = TypeName.get((TypeMirror)typeArguments.get(3));
        TypeName sourceType5 = TypeName.get((TypeMirror)typeArguments.get(4));
        TypeName sourceType6 = TypeName.get((TypeMirror)typeArguments.get(5));
        TypeName sourceType7 = TypeName.get((TypeMirror)typeArguments.get(6));
        FieldMetaSignature parsingResult1 = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        FieldMetaSignature parsingResult2 = this.parseType(parsingResult1.annotationTree, context.noLambda(context.entityRawType, sourceType2), sourceType2);
        FieldMetaSignature parsingResult3 = this.parseType(parsingResult2.annotationTree, context.noLambda(context.entityRawType, sourceType3), sourceType3);
        FieldMetaSignature parsingResult4 = this.parseType(parsingResult3.annotationTree, context.noLambda(context.entityRawType, sourceType4), sourceType4);
        FieldMetaSignature parsingResult5 = this.parseType(parsingResult4.annotationTree, context.noLambda(context.entityRawType, sourceType5), sourceType5);
        FieldMetaSignature parsingResult6 = this.parseType(parsingResult5.annotationTree, context.noLambda(context.entityRawType, sourceType6), sourceType6);
        FieldMetaSignature parsingResult7 = this.parseType(parsingResult6.annotationTree, context.noLambda(context.entityRawType, sourceType7), sourceType7);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L, $L, $L, $L, $L, $L, $L)", new Object[]{TypeUtils.TUPLE7_PROPERTY, context.fieldInfoCode, parsingResult1.typeCode, parsingResult2.typeCode, parsingResult3.typeCode, parsingResult4.typeCode, parsingResult5.typeCode, parsingResult6.typeCode, parsingResult7.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE7_PROPERTY, context.entityRawType, sourceType1, sourceType2, sourceType3, sourceType4, sourceType5, sourceType6, sourceType7);
        return new FieldMetaSignature(context, parsingResult5.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseTuple8(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(annotationTree.getCurrentType());
        TypeName sourceType1 = TypeName.get((TypeMirror)typeArguments.get(0));
        TypeName sourceType2 = TypeName.get((TypeMirror)typeArguments.get(1));
        TypeName sourceType3 = TypeName.get((TypeMirror)typeArguments.get(2));
        TypeName sourceType4 = TypeName.get((TypeMirror)typeArguments.get(3));
        TypeName sourceType5 = TypeName.get((TypeMirror)typeArguments.get(4));
        TypeName sourceType6 = TypeName.get((TypeMirror)typeArguments.get(5));
        TypeName sourceType7 = TypeName.get((TypeMirror)typeArguments.get(6));
        TypeName sourceType8 = TypeName.get((TypeMirror)typeArguments.get(7));
        FieldMetaSignature parsingResult1 = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        FieldMetaSignature parsingResult2 = this.parseType(parsingResult1.annotationTree, context.noLambda(context.entityRawType, sourceType2), sourceType2);
        FieldMetaSignature parsingResult3 = this.parseType(parsingResult2.annotationTree, context.noLambda(context.entityRawType, sourceType3), sourceType3);
        FieldMetaSignature parsingResult4 = this.parseType(parsingResult3.annotationTree, context.noLambda(context.entityRawType, sourceType4), sourceType4);
        FieldMetaSignature parsingResult5 = this.parseType(parsingResult4.annotationTree, context.noLambda(context.entityRawType, sourceType5), sourceType5);
        FieldMetaSignature parsingResult6 = this.parseType(parsingResult5.annotationTree, context.noLambda(context.entityRawType, sourceType6), sourceType6);
        FieldMetaSignature parsingResult7 = this.parseType(parsingResult6.annotationTree, context.noLambda(context.entityRawType, sourceType7), sourceType7);
        FieldMetaSignature parsingResult8 = this.parseType(parsingResult7.annotationTree, context.noLambda(context.entityRawType, sourceType8), sourceType8);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L, $L, $L, $L, $L, $L, $L, $L)", new Object[]{TypeUtils.TUPLE8_PROPERTY, context.fieldInfoCode, parsingResult1.typeCode, parsingResult2.typeCode, parsingResult3.typeCode, parsingResult4.typeCode, parsingResult5.typeCode, parsingResult6.typeCode, parsingResult7.typeCode, parsingResult8.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE8_PROPERTY, context.entityRawType, sourceType1, sourceType2, sourceType3, sourceType4, sourceType5, sourceType6, sourceType7, sourceType8);
        return new FieldMetaSignature(context, parsingResult5.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseTuple9(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(annotationTree.getCurrentType());
        TypeName sourceType1 = TypeName.get((TypeMirror)typeArguments.get(0));
        TypeName sourceType2 = TypeName.get((TypeMirror)typeArguments.get(1));
        TypeName sourceType3 = TypeName.get((TypeMirror)typeArguments.get(2));
        TypeName sourceType4 = TypeName.get((TypeMirror)typeArguments.get(3));
        TypeName sourceType5 = TypeName.get((TypeMirror)typeArguments.get(4));
        TypeName sourceType6 = TypeName.get((TypeMirror)typeArguments.get(5));
        TypeName sourceType7 = TypeName.get((TypeMirror)typeArguments.get(6));
        TypeName sourceType8 = TypeName.get((TypeMirror)typeArguments.get(7));
        TypeName sourceType9 = TypeName.get((TypeMirror)typeArguments.get(8));
        FieldMetaSignature parsingResult1 = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        FieldMetaSignature parsingResult2 = this.parseType(parsingResult1.annotationTree, context.noLambda(context.entityRawType, sourceType2), sourceType2);
        FieldMetaSignature parsingResult3 = this.parseType(parsingResult2.annotationTree, context.noLambda(context.entityRawType, sourceType3), sourceType3);
        FieldMetaSignature parsingResult4 = this.parseType(parsingResult3.annotationTree, context.noLambda(context.entityRawType, sourceType4), sourceType4);
        FieldMetaSignature parsingResult5 = this.parseType(parsingResult4.annotationTree, context.noLambda(context.entityRawType, sourceType5), sourceType5);
        FieldMetaSignature parsingResult6 = this.parseType(parsingResult5.annotationTree, context.noLambda(context.entityRawType, sourceType6), sourceType6);
        FieldMetaSignature parsingResult7 = this.parseType(parsingResult6.annotationTree, context.noLambda(context.entityRawType, sourceType7), sourceType7);
        FieldMetaSignature parsingResult8 = this.parseType(parsingResult7.annotationTree, context.noLambda(context.entityRawType, sourceType8), sourceType8);
        FieldMetaSignature parsingResult9 = this.parseType(parsingResult8.annotationTree, context.noLambda(context.entityRawType, sourceType9), sourceType9);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L, $L, $L, $L, $L, $L, $L, $L, $L)", new Object[]{TypeUtils.TUPLE9_PROPERTY, context.fieldInfoCode, parsingResult1.typeCode, parsingResult2.typeCode, parsingResult3.typeCode, parsingResult4.typeCode, parsingResult5.typeCode, parsingResult6.typeCode, parsingResult7.typeCode, parsingResult8.typeCode, parsingResult9.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE9_PROPERTY, context.entityRawType, sourceType1, sourceType2, sourceType3, sourceType4, sourceType5, sourceType6, sourceType7, sourceType8, sourceType9);
        return new FieldMetaSignature(context, parsingResult5.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    protected FieldMetaSignature parseTuple10(AnnotationTree annotationTree, FieldParsingContext context) {
        TypeName sourceType = TypeName.get((TypeMirror)annotationTree.getCurrentType());
        List<? extends TypeMirror> typeArguments = AptUtils.getTypeArguments(annotationTree.getCurrentType());
        TypeName sourceType1 = TypeName.get((TypeMirror)typeArguments.get(0));
        TypeName sourceType2 = TypeName.get((TypeMirror)typeArguments.get(1));
        TypeName sourceType3 = TypeName.get((TypeMirror)typeArguments.get(2));
        TypeName sourceType4 = TypeName.get((TypeMirror)typeArguments.get(3));
        TypeName sourceType5 = TypeName.get((TypeMirror)typeArguments.get(4));
        TypeName sourceType6 = TypeName.get((TypeMirror)typeArguments.get(5));
        TypeName sourceType7 = TypeName.get((TypeMirror)typeArguments.get(6));
        TypeName sourceType8 = TypeName.get((TypeMirror)typeArguments.get(7));
        TypeName sourceType9 = TypeName.get((TypeMirror)typeArguments.get(8));
        TypeName sourceType10 = TypeName.get((TypeMirror)typeArguments.get(9));
        FieldMetaSignature parsingResult1 = this.parseType(annotationTree.next(), context.noLambda(context.entityRawType, sourceType1), sourceType1);
        FieldMetaSignature parsingResult2 = this.parseType(parsingResult1.annotationTree, context.noLambda(context.entityRawType, sourceType2), sourceType2);
        FieldMetaSignature parsingResult3 = this.parseType(parsingResult2.annotationTree, context.noLambda(context.entityRawType, sourceType3), sourceType3);
        FieldMetaSignature parsingResult4 = this.parseType(parsingResult3.annotationTree, context.noLambda(context.entityRawType, sourceType4), sourceType4);
        FieldMetaSignature parsingResult5 = this.parseType(parsingResult4.annotationTree, context.noLambda(context.entityRawType, sourceType5), sourceType5);
        FieldMetaSignature parsingResult6 = this.parseType(parsingResult5.annotationTree, context.noLambda(context.entityRawType, sourceType6), sourceType6);
        FieldMetaSignature parsingResult7 = this.parseType(parsingResult6.annotationTree, context.noLambda(context.entityRawType, sourceType7), sourceType7);
        FieldMetaSignature parsingResult8 = this.parseType(parsingResult7.annotationTree, context.noLambda(context.entityRawType, sourceType8), sourceType8);
        FieldMetaSignature parsingResult9 = this.parseType(parsingResult8.annotationTree, context.noLambda(context.entityRawType, sourceType9), sourceType9);
        FieldMetaSignature parsingResult10 = this.parseType(parsingResult9.annotationTree, context.noLambda(context.entityRawType, sourceType10), sourceType10);
        CodeBlock codeBlock = CodeBlock.builder().add("new $T<>($L, $L, $L, $L, $L, $L, $L, $L, $L, $L, $L)", new Object[]{TypeUtils.TUPLE10_PROPERTY, context.fieldInfoCode, parsingResult1.typeCode, parsingResult2.typeCode, parsingResult3.typeCode, parsingResult4.typeCode, parsingResult5.typeCode, parsingResult6.typeCode, parsingResult7.typeCode, parsingResult8.typeCode, parsingResult9.typeCode, parsingResult10.typeCode}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.TUPLE10_PROPERTY, context.entityRawType, sourceType1, sourceType2, sourceType3, sourceType4, sourceType5, sourceType6, sourceType7, sourceType8, sourceType9, sourceType10);
        return new FieldMetaSignature(context, parsingResult5.annotationTree, sourceType, (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, (TypeName)propertyType, codeBlock, IndexMetaSignature.simpleType(sourceType));
    }

    private CodecFactory.CodecInfo buildOrGetCodecFromRegistry(AnnotationTree annotationTree, FieldParsingContext context, TypeName sourceType) {
        return this.codecFactory.createCodec(sourceType, annotationTree, context, Optional.ofNullable(context.getCodecFor(sourceType)));
    }

    public static class IndexMetaSignature {
        public final TypeName collectionElementType;
        public final TypeName mapKeyType;
        public final TypeName mapValueType;
        public final TypeName simpleType;

        private IndexMetaSignature(TypeName collectionElementType, TypeName mapKeyType, TypeName mapValueType, TypeName simpleType) {
            this.collectionElementType = collectionElementType;
            this.mapKeyType = mapKeyType;
            this.mapValueType = mapValueType;
            this.simpleType = simpleType;
        }

        public static IndexMetaSignature collectionElementType(TypeName collectionElementType) {
            return new IndexMetaSignature(collectionElementType, null, null, null);
        }

        public static IndexMetaSignature mapType(TypeName mapKeyType, TypeName mapValueType) {
            return new IndexMetaSignature(mapValueType, mapKeyType, mapValueType, null);
        }

        public static IndexMetaSignature simpleType(TypeName simpleType) {
            return new IndexMetaSignature(null, null, null, simpleType);
        }
    }

    public static class UDTMetaSignature {
        public final String fieldName;
        public final String quotedCqlColumn;
        public final List<FieldMetaSignature> fieldMetaSignatures;
        public final List<FieldMetaSignature> customConstructorFieldMetaSignatures;
        public final boolean isFrozen;

        public UDTMetaSignature(String fieldName, String quotedCqlColumn, List<FieldMetaSignature> fieldMetaSignatures, List<FieldMetaSignature> customConstructorFieldMetaSignatures, boolean isFrozen) {
            this.fieldName = fieldName;
            this.quotedCqlColumn = quotedCqlColumn;
            this.fieldMetaSignatures = fieldMetaSignatures;
            this.customConstructorFieldMetaSignatures = customConstructorFieldMetaSignatures;
            this.isFrozen = isFrozen;
        }
    }

    public static class FieldMetaSignature {
        private static final Modifier[] FIELD_MODIFIERS = new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC};
        public final FieldParsingContext context;
        public final AnnotationTree annotationTree;
        public final TypeName sourceType;
        public final TypeName targetType;
        public final CodeBlock typeCode;
        public final TypeName propertyType;
        public final Optional<UDTMetaSignature> udtMetaSignature;
        public final IndexMetaSignature indexMetaSignature;

        public boolean isUDT() {
            return this.udtMetaSignature.isPresent();
        }

        public boolean isList() {
            return TypeUtils.getRawType(this.targetType).equals((Object)TypeUtils.LIST);
        }

        public boolean isSet() {
            return TypeUtils.getRawType(this.targetType).equals((Object)TypeUtils.SET);
        }

        public boolean isMap() {
            return TypeUtils.getRawType(this.targetType).equals((Object)TypeUtils.MAP);
        }

        public boolean isCollection() {
            return this.isList() || this.isSet() || this.isMap();
        }

        public FieldMetaSignature(FieldParsingContext context, AnnotationTree annotationTree, TypeName sourceType, TypeName targetType, TypeName propertyType, CodeBlock typeCode, IndexMetaSignature indexMetaSignature, Optional<UDTMetaSignature> udtMetaSignature) {
            this.context = context;
            this.annotationTree = annotationTree;
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.propertyType = propertyType;
            this.typeCode = typeCode;
            this.indexMetaSignature = indexMetaSignature;
            this.udtMetaSignature = udtMetaSignature;
        }

        public FieldMetaSignature(FieldParsingContext context, AnnotationTree annotationTree, TypeName sourceType, TypeName targetType, TypeName propertyType, CodeBlock typeCode, IndexMetaSignature indexMetaSignature) {
            this.context = context;
            this.annotationTree = annotationTree;
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.propertyType = propertyType;
            this.typeCode = typeCode;
            this.indexMetaSignature = indexMetaSignature;
            this.udtMetaSignature = Optional.empty();
        }

        public String relationClassnameForUpdate() {
            return NamingHelper.upperCaseFirst(this.context.fieldName);
        }

        public FieldSpec buildPropertyAsField() {
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.propertyType, (String)this.context.fieldName, (Modifier[])FIELD_MODIFIERS).addJavadoc("Meta class for '$L' property <br/>\n", new Object[]{this.context.fieldName}).addJavadoc("The meta class exposes some useful methods: ", new Object[0]).addJavadoc("<ul>\n", new Object[0]).addJavadoc("   <li>encodeFromJava: encode a property from raw Java to CQL java compatible type </li>\n", new Object[0]).addJavadoc("   <li>encodeField: extract the current property value from the given $T instance and encode to CQL java compatible type </li>\n", new Object[]{this.context.entityRawType}).addJavadoc("   <li>decodeFromGettable: decode from a {@link $T} instance (Row, UDTValue, TupleValue) the current property</li>\n", new Object[]{ClassName.get(GettableData.class)}).addJavadoc("</ul>\n", new Object[0]).initializer(this.typeCode);
            AnnotationSpec.Builder annotationBuilder = null;
            if (this.typeCode.toString().contains("SimpleProperty")) {
                annotationBuilder = AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{$S, $S}", new Object[]{"serial", "unchecked"});
            }
            if (this.typeCode.toString().contains("FieldInfo.<")) {
                AnnotationSpec.Builder builder2 = annotationBuilder = annotationBuilder == null ? AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}) : annotationBuilder;
            }
            if (annotationBuilder != null) {
                builder.addAnnotation(annotationBuilder.build());
            }
            return builder.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldMetaSignature that = (FieldMetaSignature)o;
            return Objects.equals(this.context, that.context);
        }

        public int hashCode() {
            return Objects.hash(this.context);
        }

        public String toStringForViewCheck() {
            StringBuilder sb = new StringBuilder("{");
            sb.append(this.context.toStringForViewCheck());
            sb.append(", sourceType=").append(this.sourceType);
            sb.append(", targetType=").append(this.targetType);
            sb.append("}");
            return sb.toString();
        }

        public boolean equalsTo(FieldMetaSignature o) {
            if (this == o) {
                return true;
            }
            return this.context.equalsTo(o.context) && Objects.equals(this.sourceType, o.sourceType) && Objects.equals(this.targetType, o.targetType);
        }
    }
}

