/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser;

import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.codegen.function.InternalSystemFunctionRegistry;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.FunctionParamParser;
import info.archinnov.achilles.internals.parser.context.FunctionSignature;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.apache.commons.lang3.StringUtils;

public class FunctionParser {
    public static List<FunctionSignature> parseFunctionRegistryAndValidateTypes(AptUtils aptUtils, TypeElement elm, GlobalParsingContext context) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(elm.getEnclosedElements());
        Optional<String> keyspace = AnnotationTree.findKeyspaceForFunctionRegistry(aptUtils, elm);
        FunctionParamParser paramParser = new FunctionParamParser(aptUtils);
        TypeName parentType = TypeName.get((TypeMirror)aptUtils.erasure(elm));
        if (keyspace.isPresent()) {
            String keyspaceName = keyspace.get();
            aptUtils.validateFalse(InternalSystemFunctionRegistry.FORBIDDEN_KEYSPACES.contains(keyspaceName) || InternalSystemFunctionRegistry.FORBIDDEN_KEYSPACES.contains(keyspaceName.toLowerCase()), "The provided keyspace '%s' on function registry class '%s' is forbidden because it is a system keyspace", keyspaceName, parentType);
        }
        aptUtils.validateFalse(keyspace.isPresent() && StringUtils.isBlank((CharSequence)keyspace.get()), "The declared keyspace for function registry '%s' should not be blank", elm.getSimpleName().toString());
        return methods.stream().map(method -> {
            String methodName = method.getSimpleName().toString();
            List<AnnotationTree> annotationTrees = AnnotationTree.buildFromMethodForParam(aptUtils, method);
            List<? extends VariableElement> parameters = method.getParameters();
            ArrayList<FunctionSignature.FunctionParamSignature> parameterSignatures = new ArrayList<FunctionSignature.FunctionParamSignature>(parameters.size());
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement parameter = parameters.get(i);
                context.nestedTypesValidator().validate(aptUtils, annotationTrees.get(i), method.toString(), parentType);
                FunctionSignature.FunctionParamSignature functionParamSignature = paramParser.parseParam(context, annotationTrees.get(i), parentType, methodName, parameter.getSimpleName().toString());
                parameterSignatures.add(functionParamSignature);
            }
            TypeMirror returnType = method.getReturnType();
            aptUtils.validateFalse(returnType.getKind() == TypeKind.VOID, "The return type for the method '%s' on class '%s' should not be VOID", method.toString(), elm.getSimpleName().toString());
            aptUtils.validateFalse(returnType.getKind().isPrimitive(), "Due to internal JDK API limitations, UDF/UDA return types cannot be primitive. Use their Object counterpart instead for method '%s' in function registry '%s'", method.toString(), elm.getQualifiedName());
            FunctionSignature.FunctionParamSignature returnTypeSignature = paramParser.parseParam(context, AnnotationTree.buildFromMethodForReturnType(aptUtils, method), parentType, methodName, "returnType");
            aptUtils.validateFalse(InternalSystemFunctionRegistry.SYSTEM_FUNCTIONS_NAME.contains(methodName.toLowerCase()), "The name of the function '%s' in class '%s' is reserved for system functions", method, parentType);
            return new FunctionSignature(keyspace, parentType, methodName, returnTypeSignature, parameterSignatures);
        }).collect(Collectors.toList());
    }

    public static void validateNoDuplicateDeclaration(AptUtils aptUtils, List<FunctionSignature> signatures) {
        for (FunctionSignature signature : signatures) {
            signatures.stream().filter(signature::equals).filter(x -> x != signature).forEach(x -> aptUtils.printError("Functions '%s' and '%s' have same signature. Duplicate function declaration is not allowed", signature, x));
        }
    }
}

