/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.annotations.Frozen;
import info.archinnov.achilles.annotations.UDT;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.codegen.meta.UDTMetaCodeGen;
import info.archinnov.achilles.internals.parser.AbstractBeanParser;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.AccessorsExclusionContext;
import info.archinnov.achilles.internals.parser.context.FieldParsingContext;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class UDTParser
extends AbstractBeanParser {
    private final UDTMetaCodeGen udtMetaCodeGen;

    public UDTParser(AptUtils aptUtils) {
        super(aptUtils);
        this.udtMetaCodeGen = new UDTMetaCodeGen(aptUtils);
    }

    public FieldParser.FieldMetaSignature parseUDT(AnnotationTree annotationTree, FieldParsingContext context, FieldParser fieldParser) {
        TypeMirror typeMirror = annotationTree.getCurrentType();
        TypeName udtTypeName = TypeName.get((TypeMirror)typeMirror);
        TypeName rawUdtTypeName = TypeUtils.getRawType(udtTypeName);
        TypeElement typeElement = AptUtils.asTypeElement(typeMirror);
        GlobalParsingContext globalContext = context.entityContext.globalContext;
        this.validateUDT(globalContext, rawUdtTypeName, typeElement);
        if (!context.hasProcessedUDT(rawUdtTypeName)) {
            List<AccessorsExclusionContext> accessorsExclusionContexts = this.prebuildAccessorsExclusion(typeElement, globalContext);
            List<FieldParser.FieldMetaSignature> fieldMetaSignatures = this.parseFields(typeElement, fieldParser, accessorsExclusionContexts, globalContext);
            List<FieldParser.FieldMetaSignature> customConstructorFieldMetaSignatures = this.parseAndValidateCustomConstructor(globalContext.beanValidator(), rawUdtTypeName.toString(), typeElement, fieldMetaSignatures);
            TypeSpec udtClassPropertyCode = this.udtMetaCodeGen.buildUDTClassProperty(typeElement, context.entityContext, fieldMetaSignatures, customConstructorFieldMetaSignatures);
            context.addUDTMeta(rawUdtTypeName, udtClassPropertyCode);
            boolean isFrozen = AptUtils.containsAnnotation(annotationTree, Frozen.class);
            FieldParser.UDTMetaSignature udtMetaSignature = new FieldParser.UDTMetaSignature(context.fieldName, context.quotedCqlColumn, fieldMetaSignatures, customConstructorFieldMetaSignatures, isFrozen);
            globalContext.nestedTypesValidator().validateUDT(this.aptUtils, udtMetaSignature, context.fieldName, context.entityRawType);
            context.addUDTMetaSignature(rawUdtTypeName, udtMetaSignature);
        }
        Optional<FieldParser.UDTMetaSignature> udtMetaSignature = Optional.of(context.getUDTMetaSignature(rawUdtTypeName));
        ClassName udtClassMetaTypeName = ClassName.get((String)"info.archinnov.achilles.generated.meta.udt", (String)(typeElement.getSimpleName() + "_AchillesMeta"), (String[])new String[0]);
        CodeBlock typeCode = CodeBlock.builder().add("new $T<$T, $T, $T>($L, $T.class, $T.INSTANCE)", new Object[]{TypeUtils.UDT_PROPERTY, context.entityRawType, udtClassMetaTypeName, rawUdtTypeName.box(), context.fieldInfoCode, rawUdtTypeName.box(), udtClassMetaTypeName}).build();
        ParameterizedTypeName propertyType = TypeUtils.genericType(TypeUtils.UDT_PROPERTY, new TypeName[]{context.entityRawType, udtClassMetaTypeName, rawUdtTypeName});
        return new FieldParser.FieldMetaSignature(context, annotationTree.hasNext() ? annotationTree.next() : annotationTree, udtTypeName, (TypeName)TypeUtils.JAVA_DRIVER_UDT_VALUE_TYPE, (TypeName)propertyType, typeCode, FieldParser.IndexMetaSignature.simpleType(udtTypeName), udtMetaSignature);
    }

    void validateUDT(GlobalParsingContext context, TypeName udtTypeName, TypeElement typeElement) {
        context.beanValidator().validateIsAConcreteClass(this.aptUtils, typeElement);
        boolean isSupportedType = context.typeValidator().getAllowedTypes().contains(udtTypeName);
        this.aptUtils.validateFalse(isSupportedType, "Type '%s' cannot be annotated with '%s' because it is a supported type", udtTypeName, UDT.class.getCanonicalName());
        context.beanValidator().validateConstructor(this.aptUtils, udtTypeName, typeElement);
    }
}

