/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.context;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.internals.parser.TypeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class FunctionSignature {
    public final Optional<String> keyspace;
    public final TypeName sourceClass;
    public final String name;
    public final String methodName;
    public final TypeName sourceReturnType;
    public final List<TypeName> sourceParameterTypes;
    public final FunctionParamSignature returnTypeSignature;
    public final List<FunctionParamSignature> parameterSignatures;

    public FunctionSignature(Optional<String> keyspace, TypeName sourceClass, String name, String methodName, FunctionParamSignature returnTypeSignature, List<FunctionParamSignature> parameterSignatures) {
        this.keyspace = keyspace;
        this.sourceClass = sourceClass;
        this.name = name;
        this.methodName = methodName;
        this.returnTypeSignature = returnTypeSignature;
        this.sourceReturnType = returnTypeSignature.sourceTypeName;
        this.parameterSignatures = parameterSignatures;
        this.sourceParameterTypes = parameterSignatures.stream().map(x -> x.sourceTypeName).collect(Collectors.toList());
    }

    public FunctionSignature(Optional<String> keyspace, TypeName sourceClass, String name, FunctionParamSignature returnTypeSignature, List<FunctionParamSignature> parameterSignatures) {
        this.keyspace = keyspace;
        this.sourceClass = sourceClass;
        this.name = name;
        this.methodName = name;
        this.returnTypeSignature = returnTypeSignature;
        this.sourceReturnType = returnTypeSignature.sourceTypeName;
        this.parameterSignatures = parameterSignatures;
        this.sourceParameterTypes = parameterSignatures.stream().map(x -> x.sourceTypeName).collect(Collectors.toList());
    }

    public String getFunctionName() {
        return this.keyspace.isPresent() ? this.keyspace.get() + "." + this.name : this.name;
    }

    public TypeName returnTypeForFunctionParam() {
        return TypeUtils.determineTypeForFunctionParam(this.returnTypeSignature.sourceTypeName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionSignature that = (FunctionSignature)o;
        return Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.name.toLowerCase(), that.name.toLowerCase()) && Objects.equals(this.sourceReturnType, that.sourceReturnType) && Objects.equals(this.sourceParameterTypes, that.sourceParameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.name.toLowerCase(), this.methodName.toLowerCase(), this.sourceReturnType, this.sourceParameterTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UDFSignature{");
        sb.append("keyspace=").append(this.keyspace);
        sb.append(", sourceClass=").append(this.sourceClass);
        sb.append(", methodName='").append(this.methodName).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", returnType=").append(this.sourceReturnType);
        sb.append(", sourceParameterTypes=").append(this.sourceParameterTypes);
        sb.append('}');
        return sb.toString();
    }

    public static class FunctionParamSignature {
        public final String name;
        public final TypeName sourceTypeName;
        public final TypeName targetCQLTypeName;
        public final String targetCQLDataType;

        public static FunctionParamSignature VOID() {
            return new FunctionParamSignature("returnType", TypeName.VOID, TypeName.VOID, "");
        }

        public FunctionParamSignature(String name, TypeName sourceTypeName, TypeName targetCQLTypeName, String targetCQLDataType) {
            this.name = name;
            this.sourceTypeName = sourceTypeName;
            this.targetCQLTypeName = targetCQLTypeName;
            this.targetCQLDataType = targetCQLDataType;
        }

        public TypeName typeForFunctionParam() {
            return TypeUtils.determineTypeForFunctionParam(this.sourceTypeName);
        }

        public static FunctionParamSignature tupleType(String paramName, ClassName tupleTypeName, FunctionParamSignature ... signatures) {
            List<TypeName> typeNames = Arrays.stream(signatures).map(x -> x.sourceTypeName).collect(Collectors.toList());
            StringJoiner joiner = new StringJoiner(", ", "frozen<tuple<", ">>");
            Arrays.stream(signatures).forEach(x -> joiner.add(x.targetCQLDataType));
            return new FunctionParamSignature(paramName, (TypeName)TypeUtils.genericType(tupleTypeName, typeNames.toArray(new TypeName[typeNames.size()])), (TypeName)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE, joiner.toString());
        }

        public static FunctionParamSignature listType(String paramName, FunctionParamSignature nestedSignature, boolean isFrozen) {
            if (isFrozen) {
                return new FunctionParamSignature(paramName, (TypeName)TypeUtils.genericType(TypeUtils.LIST, nestedSignature.sourceTypeName), (TypeName)TypeUtils.genericType(TypeUtils.LIST, nestedSignature.targetCQLTypeName), "frozen<list<" + nestedSignature.targetCQLDataType + ">>");
            }
            return new FunctionParamSignature(paramName, (TypeName)TypeUtils.genericType(TypeUtils.LIST, nestedSignature.sourceTypeName), (TypeName)TypeUtils.genericType(TypeUtils.LIST, nestedSignature.targetCQLTypeName), "list<" + nestedSignature.targetCQLDataType + ">");
        }

        public static FunctionParamSignature setType(String paramName, FunctionParamSignature nestedSignature, boolean isFrozen) {
            if (isFrozen) {
                return new FunctionParamSignature(paramName, (TypeName)TypeUtils.genericType(TypeUtils.SET, nestedSignature.sourceTypeName), (TypeName)TypeUtils.genericType(TypeUtils.SET, nestedSignature.targetCQLTypeName), "frozen<set<" + nestedSignature.targetCQLDataType + ">>");
            }
            return new FunctionParamSignature(paramName, (TypeName)TypeUtils.genericType(TypeUtils.SET, nestedSignature.sourceTypeName), (TypeName)TypeUtils.genericType(TypeUtils.SET, nestedSignature.targetCQLTypeName), "set<" + nestedSignature.targetCQLDataType + ">");
        }

        public static FunctionParamSignature mapType(String paramName, FunctionParamSignature keySignature, FunctionParamSignature valueSignature, boolean isFrozen) {
            if (isFrozen) {
                return new FunctionParamSignature(paramName, (TypeName)TypeUtils.genericType(TypeUtils.MAP, keySignature.sourceTypeName, valueSignature.sourceTypeName), (TypeName)TypeUtils.genericType(TypeUtils.MAP, keySignature.targetCQLTypeName, valueSignature.targetCQLTypeName), "frozen<map<" + keySignature.targetCQLDataType + ", " + valueSignature.targetCQLDataType + ">>");
            }
            return new FunctionParamSignature(paramName, (TypeName)TypeUtils.genericType(TypeUtils.MAP, keySignature.sourceTypeName, valueSignature.sourceTypeName), (TypeName)TypeUtils.genericType(TypeUtils.MAP, keySignature.targetCQLTypeName, valueSignature.targetCQLTypeName), "map<" + keySignature.targetCQLDataType + ", " + valueSignature.targetCQLDataType + ">");
        }

        public static FunctionParamSignature optionalType(String paramName, FunctionParamSignature nestedSignature) {
            return new FunctionParamSignature(paramName, (TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, nestedSignature.sourceTypeName), nestedSignature.targetCQLTypeName, nestedSignature.targetCQLDataType);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("UDFParamSignature{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", sourceTypeName=").append(this.sourceTypeName);
            sb.append(", targetCQLTypeName=").append(this.targetCQLTypeName);
            sb.append(", targetCQLDataType='").append(this.targetCQLDataType).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionParamSignature that = (FunctionParamSignature)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.sourceTypeName, that.sourceTypeName) && Objects.equals(this.targetCQLTypeName, that.targetCQLTypeName) && Objects.equals(this.targetCQLDataType, that.targetCQLDataType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.sourceTypeName, this.targetCQLTypeName, this.targetCQLDataType);
        }
    }
}

