/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.context;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.annotations.CompileTimeConfig;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.cassandra_version.CassandraFeature;
import info.archinnov.achilles.internals.cassandra_version.DSE_4_8_X;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_0_0;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_0_1;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_0_2;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_0_3;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_0;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_1;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_10;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_2;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_3;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_4;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_5;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_6;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_7;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_8;
import info.archinnov.achilles.internals.cassandra_version.DSE_5_1_9;
import info.archinnov.achilles.internals.cassandra_version.InternalCassandraVersion;
import info.archinnov.achilles.internals.cassandra_version.V2_1;
import info.archinnov.achilles.internals.cassandra_version.V2_2;
import info.archinnov.achilles.internals.cassandra_version.V3_0;
import info.archinnov.achilles.internals.cassandra_version.V3_1;
import info.archinnov.achilles.internals.cassandra_version.V3_10;
import info.archinnov.achilles.internals.cassandra_version.V3_11_0;
import info.archinnov.achilles.internals.cassandra_version.V3_11_1;
import info.archinnov.achilles.internals.cassandra_version.V3_11_2;
import info.archinnov.achilles.internals.cassandra_version.V3_11_3;
import info.archinnov.achilles.internals.cassandra_version.V3_11_4;
import info.archinnov.achilles.internals.cassandra_version.V3_2;
import info.archinnov.achilles.internals.cassandra_version.V3_3;
import info.archinnov.achilles.internals.cassandra_version.V3_4;
import info.archinnov.achilles.internals.cassandra_version.V3_5;
import info.archinnov.achilles.internals.cassandra_version.V3_6;
import info.archinnov.achilles.internals.cassandra_version.V3_7;
import info.archinnov.achilles.internals.cassandra_version.V3_8;
import info.archinnov.achilles.internals.cassandra_version.V3_9;
import info.archinnov.achilles.internals.codegen.crud.CrudAPICodeGen;
import info.archinnov.achilles.internals.codegen.dsl.delete.DeleteDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.delete.DeleteWhereDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.select.SelectDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.select.SelectWhereDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.update.UpdateDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.update.UpdateWhereDSLCodeGen;
import info.archinnov.achilles.internals.codegen.function.FunctionParameterTypesCodeGen;
import info.archinnov.achilles.internals.codegen.function.FunctionsRegistryCodeGen;
import info.archinnov.achilles.internals.codegen.index.IndexSelectDSLCodeGen;
import info.archinnov.achilles.internals.codegen.index.IndexSelectWhereDSLCodeGen;
import info.archinnov.achilles.internals.parser.CodecFactory;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.validator.BeanValidator;
import info.archinnov.achilles.internals.parser.validator.FieldValidator;
import info.archinnov.achilles.internals.parser.validator.NestedTypesValidator;
import info.archinnov.achilles.internals.parser.validator.TypeValidator;
import info.archinnov.achilles.internals.strategy.field_filtering.FieldFilter;
import info.archinnov.achilles.internals.strategy.naming.InternalNamingStrategy;
import info.archinnov.achilles.internals.strategy.naming.LowerCaseNaming;
import info.archinnov.achilles.internals.utils.NamingHelper;
import info.archinnov.achilles.type.CassandraVersion;
import info.archinnov.achilles.type.strategy.ColumnMappingStrategy;
import info.archinnov.achilles.type.strategy.InsertStrategy;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.StringUtils;

public class GlobalParsingContext {
    private static final Map<CassandraVersion, InternalCassandraVersion> VERSION_MAPPING = new HashMap<CassandraVersion, InternalCassandraVersion>();
    private static final Map<ColumnMappingStrategy, Tuple2<FieldFilter, FieldFilter>> COLUMNS_MAPPING = new HashMap<ColumnMappingStrategy, Tuple2<FieldFilter, FieldFilter>>();
    public final InternalCassandraVersion cassandraVersion;
    public final InsertStrategy insertStrategy;
    public final InternalNamingStrategy namingStrategy;
    public final FieldFilter fieldFilter;
    public final FieldFilter udtFieldFilter;
    public final Optional<String> projectName;
    public final Map<TypeName, TypeSpec> udtTypes = new HashMap<TypeName, TypeSpec>();
    public final Map<TypeName, FieldParser.UDTMetaSignature> udtMetaSignatures = new HashMap<TypeName, FieldParser.UDTMetaSignature>();
    public final Map<TypeName, CodecFactory.CodecInfo> codecRegistry = new HashMap<TypeName, CodecFactory.CodecInfo>();

    public static GlobalParsingContext fromCompileTimeConfig(CompileTimeConfig compileTimeConfig) {
        InternalCassandraVersion version = VERSION_MAPPING.get(compileTimeConfig.cassandraVersion());
        InsertStrategy insertStrategy = compileTimeConfig.insertStrategy();
        InternalNamingStrategy namingStrategy = InternalNamingStrategy.getNamingStrategy(compileTimeConfig.namingStrategy());
        Tuple2<FieldFilter, FieldFilter> fieldFilters = COLUMNS_MAPPING.get(compileTimeConfig.columnMappingStrategy());
        Optional<String> projectName = StringUtils.isBlank((CharSequence)compileTimeConfig.projectName()) ? Optional.empty() : Optional.of(compileTimeConfig.projectName());
        return new GlobalParsingContext(version, insertStrategy, namingStrategy, (FieldFilter)fieldFilters._1(), (FieldFilter)fieldFilters._2(), projectName);
    }

    public static GlobalParsingContext defaultContext() {
        return new GlobalParsingContext(V3_0.INSTANCE, InsertStrategy.ALL_FIELDS, new LowerCaseNaming(), FieldFilter.EXPLICIT_ENTITY_FIELD_FILTER, FieldFilter.EXPLICIT_UDT_FIELD_FILTER, Optional.empty());
    }

    public GlobalParsingContext(InternalCassandraVersion cassandraVersion, InsertStrategy insertStrategy, InternalNamingStrategy namingStrategy, FieldFilter fieldFilter, FieldFilter udtFieldFilter, Optional<String> projectName) {
        this.cassandraVersion = cassandraVersion;
        this.insertStrategy = insertStrategy;
        this.fieldFilter = fieldFilter;
        this.udtFieldFilter = udtFieldFilter;
        this.namingStrategy = namingStrategy;
        this.projectName = projectName;
    }

    public String managerFactoryBuilderClassName() {
        return this.projectName.isPresent() ? "ManagerFactoryBuilder_For_" + NamingHelper.upperCaseFirst(this.projectName.get()) : "ManagerFactoryBuilder";
    }

    public String managerFactoryClassName() {
        return this.projectName.isPresent() ? "ManagerFactory_For_" + NamingHelper.upperCaseFirst(this.projectName.get()) : "ManagerFactory";
    }

    public TypeName managerFactoryBuilderTypeName() {
        return this.projectName.isPresent() ? ClassName.get((String)"info.archinnov.achilles.generated", (String)this.managerFactoryBuilderClassName(), (String[])new String[0]) : TypeUtils.MANAGER_FACTORY_BUILDER_TYPE_NAME;
    }

    public TypeName managerFactoryTypeName() {
        return this.projectName.isPresent() ? ClassName.get((String)"info.archinnov.achilles.generated", (String)this.managerFactoryClassName(), (String[])new String[0]) : TypeUtils.MANAGER_FACTORY_TYPE_NAME;
    }

    public BeanValidator beanValidator() {
        return this.cassandraVersion.beanValidator();
    }

    public FieldValidator fieldValidator() {
        return this.cassandraVersion.fieldValidator();
    }

    public TypeValidator typeValidator() {
        return this.cassandraVersion.typeValidator();
    }

    public NestedTypesValidator nestedTypesValidator() {
        return this.cassandraVersion.nestedTypesValidator();
    }

    public CrudAPICodeGen crudAPICodeGen() {
        return this.cassandraVersion.crudApiCodeGen();
    }

    public SelectDSLCodeGen selectDSLCodeGen() {
        return this.cassandraVersion.selectDslCodeGen();
    }

    public IndexSelectDSLCodeGen indexSelectDSLCodeGen() {
        return this.cassandraVersion.indexSelectDslCodeGen();
    }

    public SelectWhereDSLCodeGen selectWhereDSLCodeGen() {
        return this.cassandraVersion.selectWhereDSLCodeGen();
    }

    public IndexSelectWhereDSLCodeGen indexSelectWhereDSLCodeGen() {
        return this.cassandraVersion.indexSelectWhereDSLCodeGen();
    }

    public UpdateDSLCodeGen updateDSLCodeGen() {
        return this.cassandraVersion.updateDslCodeGen();
    }

    public UpdateWhereDSLCodeGen updateWhereDSLCodeGen() {
        return this.cassandraVersion.updateWhereDslCodeGen();
    }

    public DeleteDSLCodeGen deleteDSLCodeGen() {
        return this.cassandraVersion.deleteDslCodeGen();
    }

    public DeleteWhereDSLCodeGen deleteWhereDSLCodeGen() {
        return this.cassandraVersion.deleteWhereDslCodeGen();
    }

    public FunctionsRegistryCodeGen functionsRegistryCodeGen() {
        return this.cassandraVersion.functionsRegistryCodeGen();
    }

    public FunctionParameterTypesCodeGen functionParameterTypesCodeGen() {
        return this.cassandraVersion.functionParameterTypesCodeGen();
    }

    public boolean supportsFeature(CassandraFeature feature) {
        return this.cassandraVersion.supportsFeature(feature);
    }

    public boolean hasCodecFor(TypeName typeName) {
        return this.codecRegistry.containsKey(typeName);
    }

    public CodecFactory.CodecInfo getCodecFor(TypeName typeName) {
        return this.codecRegistry.get(typeName);
    }

    public void validateProjectName(AptUtils aptUtils) {
        if (this.projectName.isPresent()) {
            String projectName = this.projectName.get();
            aptUtils.validateTrue(SourceVersion.isName(projectName), "The project name '%s' is not a valid name for class name generation. Please use ([a-zA-Z][a-zA-Z0-9_]+) as pattern for project name", projectName);
        }
    }

    static {
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_2_1_X, V2_1.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_2_2_X, V2_2.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_0_X, V3_0.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_1, V3_1.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_2, V3_2.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_3, V3_3.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_4, V3_4.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_5, V3_5.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_6, V3_6.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_7, V3_7.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_8, V3_8.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_9, V3_9.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_10, V3_10.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_11_0, V3_11_0.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_11_1, V3_11_1.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_11_2, V3_11_2.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_11_3, V3_11_3.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.CASSANDRA_3_11_4, V3_11_4.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_4_8_X, DSE_4_8_X.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_0_0, DSE_5_0_0.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_0_1, DSE_5_0_1.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_0_2, DSE_5_0_2.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_0_3, DSE_5_0_3.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_0, DSE_5_1_0.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_1, DSE_5_1_1.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_2, DSE_5_1_2.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_3, DSE_5_1_3.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_4, DSE_5_1_4.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_5, DSE_5_1_5.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_6, DSE_5_1_6.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_7, DSE_5_1_7.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_8, DSE_5_1_8.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_9, DSE_5_1_9.INSTANCE);
        VERSION_MAPPING.put(CassandraVersion.DSE_5_1_10, DSE_5_1_10.INSTANCE);
        COLUMNS_MAPPING.put(ColumnMappingStrategy.EXPLICIT, (Tuple2<FieldFilter, FieldFilter>)Tuple2.of((Object)FieldFilter.EXPLICIT_ENTITY_FIELD_FILTER, (Object)FieldFilter.EXPLICIT_UDT_FIELD_FILTER));
        COLUMNS_MAPPING.put(ColumnMappingStrategy.IMPLICIT, (Tuple2<FieldFilter, FieldFilter>)Tuple2.of((Object)FieldFilter.IMPLICIT_ENTITY_FIELD_FILTER, (Object)FieldFilter.IMPLICIT_UDT_FIELD_FILTER));
    }
}

