/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.validator;

import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.Frozen;
import info.archinnov.achilles.annotations.Index;
import info.archinnov.achilles.annotations.JSON;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.FieldParser;
import java.util.Map;
import javax.lang.model.type.TypeMirror;

public abstract class NestedTypesValidator {
    public abstract void validate(AptUtils var1, AnnotationTree var2, String var3, TypeName var4);

    public abstract void validateUDT(AptUtils var1, FieldParser.UDTMetaSignature var2, String var3, TypeName var4);

    public void validateMapKeys(AptUtils aptUtils, AnnotationTree annotationTree, String fieldName, TypeName rawClass) {
        AnnotationTree next;
        TypeMirror mapKey;
        TypeMirror currentType = aptUtils.erasure(annotationTree.getCurrentType());
        if (aptUtils.isAssignableFrom(Map.class, currentType) && aptUtils.isCompositeTypeForCassandra(mapKey = (next = annotationTree.next()).getCurrentType()) && !AptUtils.containsAnnotation(next, JSON.class)) {
            aptUtils.validateTrue(AptUtils.containsAnnotation(next, Frozen.class), "Map key of type collection/UDT '%s' in '%s' of class '%s' should be annotated with @Frozen", mapKey, fieldName, rawClass);
        }
        if (annotationTree.hasNext()) {
            this.validateMapKeys(aptUtils, annotationTree.next(), fieldName, rawClass);
        }
    }

    public void validateIndexAnnotation(AptUtils aptUtils, AnnotationTree annotationTree, String fieldName, TypeName rawClass) {
        if (annotationTree.depth() > 2) {
            aptUtils.validateFalse(AptUtils.containsAnnotation(annotationTree, Index.class), "@Index annotation cannot be nested for depth > 2 for field '%s' of class '%s'", fieldName, rawClass);
        }
        if (annotationTree.hasNext()) {
            this.validateIndexAnnotation(aptUtils, annotationTree.next(), fieldName, rawClass);
        }
    }
}

