/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.validator.cassandra2_1;

import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.DSE_Search;
import info.archinnov.achilles.annotations.Index;
import info.archinnov.achilles.annotations.SASI;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.cassandra_version.CassandraFeature;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.parser.validator.FieldValidator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class FieldValidator2_1
extends FieldValidator {
    @Override
    public List<TypeName> getAllowedTypes() {
        return TypeUtils.ALLOWED_TYPES_2_1;
    }

    @Override
    public void validateCompatibleIndexAnnotationsOnField(GlobalParsingContext context, AptUtils aptUtils, String fieldName, TypeName rawEntityClass, Optional<Index> index, Optional<SASI> sasi, Optional<DSE_Search> dseSearch) {
        if (sasi.isPresent()) {
            aptUtils.validateTrue(context.supportsFeature(CassandraFeature.SASI_INDEX), "@SASI annotation is not allowed if using Cassandra version %s", context.cassandraVersion.version());
        }
        if (dseSearch.isPresent()) {
            aptUtils.validateTrue(context.supportsFeature(CassandraFeature.DSE_SEARCH), "@DSE_Search annotation is not allowed if using Cassandra version %s. Consider setting your Cassandra version to DSE_X_X", context.cassandraVersion.version());
        }
        this.checkNoMutuallyExclusiveAnnotations(aptUtils, fieldName, rawEntityClass, Arrays.asList(index, dseSearch));
    }

    @Override
    public void validateSASIIndex(AptUtils aptUtils, FieldParser.FieldMetaSignature fieldMetaSignature) {
    }

    @Override
    public void validateDSESearchIndex(AptUtils aptUtils, FieldParser.FieldMetaSignature fieldMetaSignature) {
    }
}

