/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.validator.cassandra2_1;

import com.datastax.driver.core.UDTValue;
import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.Frozen;
import info.archinnov.achilles.annotations.JSON;
import info.archinnov.achilles.annotations.UDT;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.index.IndexType;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.validator.NestedTypesValidator;
import info.archinnov.achilles.type.tuples.Tuple;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

public class NestedTypeValidator2_1
extends NestedTypesValidator {
    @Override
    public void validate(AptUtils aptUtils, AnnotationTree annotationTree, String fieldName, TypeName rawClass) {
        this.validateIndexAnnotation(aptUtils, annotationTree, fieldName, rawClass);
        TypeMirror currentType = aptUtils.erasure(annotationTree.getCurrentType());
        if (aptUtils.isAssignableFrom(Tuple.class, currentType) || AptUtils.containsAnnotation(annotationTree, JSON.class)) {
            return;
        }
        if (aptUtils.isAssignableFrom(List.class, currentType) || aptUtils.isAssignableFrom(Set.class, currentType)) {
            this.validateNestedType(aptUtils, annotationTree, fieldName, rawClass);
        } else if (aptUtils.isAssignableFrom(Map.class, currentType)) {
            this.validateMapKeys(aptUtils, annotationTree, fieldName, rawClass);
            AnnotationTree next = annotationTree;
            for (int i = 0; i < 2; ++i) {
                next = this.validateNestedType(aptUtils, next, fieldName, rawClass);
            }
        } else if (aptUtils.isAssignableFrom(UDTValue.class, currentType)) {
            aptUtils.validateTrue(AptUtils.containsAnnotation(annotationTree, Frozen.class), "UDTValue in field '%s' of class '%s' should be annotated with @Frozen", fieldName, rawClass);
        } else if (aptUtils.getAnnotationOnClass(currentType, UDT.class).isPresent()) {
            aptUtils.validateTrue(AptUtils.containsAnnotation(annotationTree, Frozen.class), "UDT class '%s' in field '%s' of class '%s' should be annotated with @Frozen", currentType, fieldName, rawClass);
        }
    }

    @Override
    public void validateUDT(AptUtils aptUtils, FieldParser.UDTMetaSignature udtMetaSignature, String fieldName, TypeName rawClass) {
        udtMetaSignature.fieldMetaSignatures.stream().filter(x -> x.isUDT()).forEach(x -> aptUtils.validateTrue(x.udtMetaSignature.get().isFrozen, "Nested udt type %s of field %s.%s should has @Frozen annotation", AptUtils.getShortname(TypeUtils.getRawType(x.sourceType)), AptUtils.getShortname(rawClass), fieldName + "." + x.context.fieldName));
        udtMetaSignature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.COUNTER).forEach(x -> aptUtils.printError("Counter column %s is not allowed inside UDT type %s", x.context.fieldName, AptUtils.getShortname(rawClass)));
        udtMetaSignature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).forEach(x -> aptUtils.printError("Partition key column %s is not allowed inside UDT type %s", x.context.fieldName, AptUtils.getShortname(rawClass)));
        udtMetaSignature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.CLUSTERING).forEach(x -> aptUtils.printError("Clustering column %s is not allowed inside UDT type %s", x.context.fieldName, AptUtils.getShortname(rawClass)));
        udtMetaSignature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.STATIC).forEach(x -> aptUtils.printError("Static column %s is not allowed inside UDT type %s", x.context.fieldName, AptUtils.getShortname(rawClass)));
        udtMetaSignature.fieldMetaSignatures.stream().filter(x -> x.context.indexInfo.type != IndexType.NONE).forEach(x -> aptUtils.printError("Indexed column %s is not allowed inside UDT type %s", x.context.fieldName, AptUtils.getShortname(rawClass)));
    }

    protected AnnotationTree validateNestedType(AptUtils aptUtils, AnnotationTree annotationTree, String fieldName, TypeName rawClass) {
        AnnotationTree next = annotationTree.next();
        TypeMirror nextType = next.getCurrentType();
        if (aptUtils.isCompositeTypeForCassandra(nextType) && !AptUtils.containsAnnotation(next, JSON.class)) {
            aptUtils.validateTrue(AptUtils.containsAnnotation(next, Frozen.class), "Nested collections/array type/UDT '%s' in '%s' of class '%s' should be annotated with @Frozen", nextType, fieldName, rawClass);
        }
        return next;
    }
}

