/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.validator.cassandra3_0;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.validator.BeanValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BeanValidator3_0
extends BeanValidator {
    @Override
    public void validateViewsAgainstBaseTable(AptUtils aptUtils, List<EntityMetaCodeGen.EntityMetaSignature> viewSignatures, List<EntityMetaCodeGen.EntityMetaSignature> entitySignatures) {
        Map<TypeName, List> entitySignaturesMap = entitySignatures.stream().collect(Collectors.toMap(meta -> meta.entityRawClass, meta -> meta.fieldMetaSignatures));
        for (EntityMetaCodeGen.EntityMetaSignature view : viewSignatures) {
            long count;
            TypeName viewBaseClass = view.viewBaseClass.get();
            List entityParsingResults = entitySignaturesMap.get(viewBaseClass);
            aptUtils.validateTrue(entityParsingResults != null, "Cannot find base entity class '%s' for view class '%s'", viewBaseClass, view.entityRawClass);
            for (FieldParser.FieldMetaSignature vpr2 : view.fieldMetaSignatures) {
                long count2 = entityParsingResults.stream().filter(epr -> epr.equalsTo(vpr2)).count();
                aptUtils.validateTrue(count2 == 1L, "Cannot find any match in base table for field '%s' in view class '%s'", vpr2.toStringForViewCheck(), view.entityRawClass);
            }
            List viewPKColumns = view.fieldMetaSignatures.stream().filter(vpr -> vpr.context.columnType == ColumnType.PARTITION || vpr.context.columnType == ColumnType.CLUSTERING).collect(Collectors.toList());
            List basePKColumns = entityParsingResults.stream().filter(vpr -> vpr.context.columnType == ColumnType.PARTITION || vpr.context.columnType == ColumnType.CLUSTERING).collect(Collectors.toList());
            List baseCollectionColumns = entityParsingResults.stream().filter(vpr -> vpr.targetType instanceof ParameterizedTypeName).filter(vpr -> {
                ClassName rawType = ((ParameterizedTypeName)vpr.targetType).rawType;
                return rawType.equals((Object)TypeUtils.LIST) || rawType.equals((Object)TypeUtils.SET) || rawType.equals((Object)TypeUtils.MAP) || rawType.equals((Object)TypeUtils.JAVA_DRIVER_UDT_VALUE_TYPE);
            }).collect(Collectors.toList());
            for (FieldParser.FieldMetaSignature epr2 : basePKColumns) {
                count = viewPKColumns.stream().filter(vpr -> vpr.equalsTo(epr2)).count();
                aptUtils.validateTrue(count == 1L, "Primary key column '%s' in base class %s is not found in view class '%s' as primary key column", epr2.toStringForViewCheck(), epr2.context.entityRawType, view.entityRawClass);
            }
            for (FieldParser.FieldMetaSignature epr2 : baseCollectionColumns) {
                count = view.fieldMetaSignatures.stream().filter(vpr -> vpr.equalsTo(epr2)).count();
                aptUtils.validateTrue(count == 1L, "Collection/UDT column '%s' in base class %s is not found in view class '%s'. It should be included in the view", epr2.toStringForViewCheck(), epr2.context.entityRawType, view.entityRawClass);
            }
            ArrayList<FieldParser.FieldMetaSignature> viewPKColumnNotInBase = new ArrayList<FieldParser.FieldMetaSignature>();
            for (FieldParser.FieldMetaSignature vpr3 : viewPKColumns) {
                long count3 = basePKColumns.stream().filter(epr -> epr.equalsTo(vpr3)).count();
                if (count3 != 0L) continue;
                viewPKColumnNotInBase.add(vpr3);
            }
            aptUtils.validateTrue(viewPKColumnNotInBase.size() <= 1, "There should be maximum 1 column in the view %s primary key that is NOT a primary column of the base class '%s'. We have %s", view.entityRawClass, viewBaseClass, viewPKColumnNotInBase.stream().map(x -> x.toStringForViewCheck()).collect(Collectors.toList()));
        }
    }

    @Override
    public void validateNoStaticColumnsForView(AptUtils aptUtils, TypeName rawClassType, List<FieldParser.FieldMetaSignature> parsingResults) {
        boolean hasStatic = parsingResults.stream().filter(x -> x.context.columnType == ColumnType.STATIC || x.context.columnType == ColumnType.STATIC_COUNTER).count() > 0L;
        aptUtils.validateFalse(hasStatic, "The class '%s' cannot have static columns because it is a materialized view", rawClassType);
    }
}

