/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.validator.cassandra3_6;

import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.JSON;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.validator.cassandra2_1.NestedTypeValidator2_1;
import info.archinnov.achilles.type.tuples.Tuple;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

public class NestedTypeValidator3_6
extends NestedTypeValidator2_1 {
    @Override
    public void validate(AptUtils aptUtils, AnnotationTree annotationTree, String fieldName, TypeName rawClass) {
        this.validateIndexAnnotation(aptUtils, annotationTree, fieldName, rawClass);
        TypeMirror currentType = aptUtils.erasure(annotationTree.getCurrentType());
        if (aptUtils.isAssignableFrom(Tuple.class, currentType) || AptUtils.containsAnnotation(annotationTree, JSON.class)) {
            return;
        }
        if (aptUtils.isAssignableFrom(List.class, currentType) || aptUtils.isAssignableFrom(Set.class, currentType)) {
            this.validateNestedType(aptUtils, annotationTree, fieldName, rawClass);
        } else if (aptUtils.isAssignableFrom(Map.class, currentType)) {
            this.validateMapKeys(aptUtils, annotationTree, fieldName, rawClass);
            AnnotationTree next = annotationTree;
            for (int i = 0; i < 2; ++i) {
                next = this.validateNestedType(aptUtils, next, fieldName, rawClass);
            }
        }
    }

    @Override
    public void validateUDT(AptUtils aptUtils, FieldParser.UDTMetaSignature udtMetaSignature, String fieldName, TypeName rawClass) {
        super.validateUDT(aptUtils, udtMetaSignature, fieldName, rawClass);
        if (!udtMetaSignature.isFrozen) {
            udtMetaSignature.fieldMetaSignatures.stream().filter(x -> x.isCollection()).forEach(x -> aptUtils.validateTrue(x.context.columnInfo.frozen, "Collection type %s of field %s.%s should has @Frozen annotation because %s.%s is a non-frozen UDT", AptUtils.getShortname(TypeUtils.getRawType(x.sourceType)), AptUtils.getShortname(rawClass), fieldName + "." + x.context.fieldName, AptUtils.getShortname(rawClass), fieldName));
        }
    }
}

