/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.runtime;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import info.archinnov.achilles.internals.dsl.crud.DeleteWithOptions;
import info.archinnov.achilles.internals.dsl.crud.InsertJSONWithOptions;
import info.archinnov.achilles.internals.dsl.crud.InsertWithOptions;
import info.archinnov.achilles.internals.dsl.crud.UpdateWithOptions;
import info.archinnov.achilles.internals.dsl.raw.NativeQuery;
import info.archinnov.achilles.internals.dsl.raw.TypedQuery;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.BeanInternalValidator;
import info.archinnov.achilles.internals.runtime.BeanValueExtractor;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statement.StatementHelper;
import info.archinnov.achilles.type.tuples.Tuple2;
import info.archinnov.achilles.validation.Validator;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManager<ENTITY> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractManager.class);
    protected final Class<ENTITY> entityClass;
    protected final RuntimeEngine rte;
    protected final AbstractEntityProperty<ENTITY> meta_internal;

    public AbstractManager(Class<ENTITY> entityClass, AbstractEntityProperty<ENTITY> meta_internal, RuntimeEngine rte) {
        this.entityClass = entityClass;
        this.meta_internal = meta_internal;
        this.rte = rte;
    }

    public ENTITY mapFromRow(Row row) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Map row %s back to entity of type %s", row, this.entityClass.getCanonicalName()));
        }
        Validator.validateNotNull((Object)row, (String)"Row object should not be null", (Object[])new Object[0]);
        String tableName = ((ColumnDefinitions.Definition)row.getColumnDefinitions().asList().get(0)).getTable();
        String entityTableName = this.meta_internal.getTableOrViewName();
        Validator.validateTableTrue((boolean)entityTableName.equals(tableName), (String)"CQL row is from table '%s', it cannot be mapped to entity '%s' associated to table '%s'", (Object[])new Object[]{tableName, this.entityClass.getCanonicalName(), entityTableName});
        return this.meta_internal.createEntityFrom(row);
    }

    public Session getNativeSession() {
        return this.rte.session;
    }

    public Cluster getNativeCluster() {
        return this.rte.getCluster();
    }

    protected InsertWithOptions<ENTITY> insertInternal(ENTITY instance, boolean insertStatic, Optional<CassandraOptions> cassandraOptions) {
        Validator.validateNotNull(instance, (String)"Entity to be inserted should not be null", (Object[])new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create insert CRUD for entity %s", instance));
        }
        if (insertStatic) {
            BeanInternalValidator.validateColumnsForInsertOrUpdateStatic(instance, this.meta_internal, cassandraOptions);
        } else {
            BeanInternalValidator.validatePrimaryKey(instance, this.meta_internal, cassandraOptions);
        }
        return new InsertWithOptions<ENTITY>(this.meta_internal, this.rte, instance, insertStatic, cassandraOptions);
    }

    protected UpdateWithOptions<ENTITY> updateInternal(ENTITY instance, boolean updateStatic, Optional<CassandraOptions> cassandraOptions) {
        Validator.validateNotNull(instance, (String)"Entity to be updated to Cassandra should not be null", (Object[])new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create update CRUD for entity %s", instance));
        }
        if (updateStatic) {
            BeanInternalValidator.validateColumnsForInsertOrUpdateStatic(instance, this.meta_internal, cassandraOptions);
        } else {
            BeanInternalValidator.validatePrimaryKey(instance, this.meta_internal, cassandraOptions);
        }
        return new UpdateWithOptions<ENTITY>(this.meta_internal, this.rte, instance, updateStatic, cassandraOptions);
    }

    protected InsertJSONWithOptions insertJSONInternal(String json, Optional<CassandraOptions> cassandraOptions) {
        Validator.validateNotBlank((String)json, (String)"The JSON string to be used for INSERT JSON should not be blank", (Object[])new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create insert json CRUD for with JSON %s", json));
        }
        return new InsertJSONWithOptions(this.meta_internal, this.rte, json, cassandraOptions);
    }

    protected DeleteWithOptions<ENTITY> deleteInternal(ENTITY instance, Optional<CassandraOptions> cassandraOptions) {
        Validator.validateNotNull(instance, (String)"Entity to be deleted should not be null", (Object[])new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create delete CRUD for entity %s", instance));
        }
        BeanInternalValidator.validatePrimaryKey(instance, this.meta_internal, cassandraOptions);
        Tuple2<Object[], Object[]> tuple = BeanValueExtractor.extractPrimaryKeyValues(instance, this.meta_internal, cassandraOptions);
        return new DeleteWithOptions<ENTITY>(this.entityClass, this.meta_internal, this.rte, (Object[])tuple._1(), (Object[])tuple._2(), Optional.of(instance), cassandraOptions);
    }

    protected TypedQuery<ENTITY> typedQueryForSelectInternal(BoundStatement boundStatement) {
        Validator.validateTrue((boolean)StatementHelper.isSelectStatement((Statement)boundStatement), (String)"Statement provided for typed query should be an SELECT statement", (Object[])new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create typed query for SELECT : %s", boundStatement.preparedStatement().getQueryString()));
        }
        return new TypedQuery<ENTITY>(this.rte, this.meta_internal, boundStatement, new Object[0]);
    }

    protected TypedQuery<ENTITY> typedQueryForSelectInternal(PreparedStatement preparedStatement, Object ... encodedBoundValues) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create typed query for SELECT : %s", preparedStatement.getQueryString()));
        }
        Validator.validateTrue((boolean)StatementHelper.isSelectStatement((PreparedStatement)preparedStatement), (String)"Statement provided for typed query should be an SELECT statement", (Object[])new Object[0]);
        Validator.validateNotEmpty((Object[])encodedBoundValues, (String)"Encoded values provided for typed query should not be empty", (Object[])new Object[0]);
        return new TypedQuery<ENTITY>(this.rte, this.meta_internal, preparedStatement.bind(encodedBoundValues), encodedBoundValues);
    }

    protected TypedQuery<ENTITY> typedQueryForSelectInternal(RegularStatement regularStatement, Object ... encodedBoundValues) {
        BoundStatement boundStatement;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create typed query for SELECT : %s", regularStatement.getQueryString()));
        }
        Validator.validateTrue((boolean)StatementHelper.isSelectStatement((Statement)regularStatement), (String)"Statement provided for typed query should be an SELECT statement", (Object[])new Object[0]);
        PreparedStatement preparedStatement = this.rte.prepareDynamicQuery(regularStatement);
        BoundStatement boundStatement2 = boundStatement = ArrayUtils.isEmpty((Object[])encodedBoundValues) ? preparedStatement.bind() : preparedStatement.bind(encodedBoundValues);
        if (regularStatement.getConsistencyLevel() != null) {
            boundStatement.setConsistencyLevel(regularStatement.getConsistencyLevel());
        }
        if (regularStatement.getSerialConsistencyLevel() != null) {
            boundStatement.setSerialConsistencyLevel(regularStatement.getSerialConsistencyLevel());
        }
        if (regularStatement.isTracing()) {
            boundStatement.enableTracing();
        }
        if (regularStatement.getRetryPolicy() != null) {
            boundStatement.setRetryPolicy(regularStatement.getRetryPolicy());
        }
        if (regularStatement.getOutgoingPayload() != null) {
            boundStatement.setOutgoingPayload(regularStatement.getOutgoingPayload());
        }
        if (regularStatement.isIdempotent() != null) {
            boundStatement.setIdempotent(regularStatement.isIdempotent().booleanValue());
        }
        boundStatement.setFetchSize(regularStatement.getFetchSize());
        return new TypedQuery<ENTITY>(this.rte, this.meta_internal, boundStatement, encodedBoundValues);
    }

    protected NativeQuery nativeQueryInternal(BoundStatement boundStatement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create native query : %s", boundStatement.preparedStatement().getQueryString()));
        }
        if (this.meta_internal.isView()) {
            Validator.validateTrue((boolean)StatementHelper.isSelectStatement((Statement)boundStatement), (String)"Statement provided for the materialized view '%s' should be an SELECT statement", (Object[])new Object[]{this.meta_internal.entityClass.getCanonicalName()});
        }
        return new NativeQuery(this.meta_internal, this.rte, boundStatement, new Object[0]);
    }

    protected NativeQuery nativeQueryInternal(PreparedStatement preparedStatement, Object ... encodedBoundValues) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create native query : %s", preparedStatement.getQueryString()));
        }
        if (this.meta_internal.isView()) {
            Validator.validateTrue((boolean)StatementHelper.isSelectStatement((PreparedStatement)preparedStatement), (String)"Statement provided for the materialized view '%s' should be an SELECT statement", (Object[])new Object[]{this.meta_internal.entityClass.getCanonicalName()});
        }
        Validator.validateNotEmpty((Object[])encodedBoundValues, (String)"Encoded values provided for native query should not be empty", (Object[])new Object[0]);
        return new NativeQuery(this.meta_internal, this.rte, preparedStatement.bind(encodedBoundValues), encodedBoundValues);
    }

    protected NativeQuery nativeQueryInternal(RegularStatement regularStatement, Object ... encodedBoundValues) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create native query : %s", regularStatement.getQueryString()));
        }
        if (this.meta_internal.isView()) {
            Validator.validateTrue((boolean)StatementHelper.isSelectStatement((Statement)regularStatement), (String)"Statement provided for the materialized view '%s' should be an SELECT statement", (Object[])new Object[]{this.meta_internal.entityClass.getCanonicalName()});
        }
        PreparedStatement preparedStatement = this.rte.prepareDynamicQuery(regularStatement);
        BoundStatement boundStatement = ArrayUtils.isEmpty((Object[])encodedBoundValues) ? preparedStatement.bind() : preparedStatement.bind(encodedBoundValues);
        return new NativeQuery(this.meta_internal, this.rte, boundStatement, encodedBoundValues);
    }
}

