/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.runtime;

import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.tuples.Tuple2;
import info.archinnov.achilles.validation.Validator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInternalValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanInternalValidator.class);

    public static <T> void validatePrimaryKey(T instance, AbstractEntityProperty<T> entityProperty, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Validate primary key for instance %s of type %s", instance, entityProperty.entityClass.getCanonicalName()));
        }
        entityProperty.partitionKeys.stream().map(x -> Tuple2.of((Object)x.fieldName, x.encodeField(instance, cassandraOptions))).filter(x -> x._2() == null).forEach(tuple -> Validator.validateNotNull((Object)tuple._2(), (String)"Field '%s' in entity of type '%s' should not be null because it is a partition key", (Object[])new Object[]{tuple._1(), entityProperty.entityClass.getCanonicalName()}));
        entityProperty.clusteringColumns.stream().map(x -> Tuple2.of((Object)x.fieldName, x.encodeField(instance, cassandraOptions))).filter(x -> x._2() == null).forEach(tuple -> Validator.validateNotNull((Object)tuple._2(), (String)"Field '%s' in entity of type '%s' should not be null because it is a clustering column", (Object[])new Object[]{tuple._1(), entityProperty.entityClass.getCanonicalName()}));
    }

    public static <T> void validateColumnsForInsertOrUpdateStatic(T instance, AbstractEntityProperty<T> entityProperty, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Validate partition columns and other columns for INSERT STATIC of instance %s of type %s", instance, entityProperty.entityClass.getCanonicalName()));
        }
        entityProperty.partitionKeys.stream().map(x -> Tuple2.of((Object)x.fieldName, x.encodeField(instance, cassandraOptions))).filter(x -> x._2() == null).forEach(tuple -> Validator.validateNotNull((Object)tuple._2(), (String)"Field '%s' in entity of type '%s' should not be null because it is a partition key", (Object[])new Object[]{tuple._1(), entityProperty.entityClass.getCanonicalName()}));
        long nonNullStaticColumnsCount = entityProperty.staticColumns.stream().map(x -> x.encodeField(instance, cassandraOptions)).filter(x -> x != null).count();
        Validator.validateTrue((nonNullStaticColumnsCount > 0L ? 1 : 0) != 0, (String)"There should be at least one non null static column in entity of type '%s' when calling insertStatic()", (Object[])new Object[]{entityProperty.entityClass.getCanonicalName()});
    }
}

