/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.schema;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.TableMetadata;
import info.archinnov.achilles.annotations.SASI;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.index.IndexImpl;
import info.archinnov.achilles.internals.metamodel.index.IndexInfo;
import info.archinnov.achilles.internals.metamodel.index.IndexType;
import info.archinnov.achilles.internals.parser.context.SASIInfoContext;
import info.archinnov.achilles.validation.Validator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaValidator.class);

    public static void validateDefaultTTL(AbstractTableMetadata metadata, Optional<Integer> staticTTL, Class<?> entityClass) {
        if (staticTTL.isPresent()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Validating table %s default TTL value", metadata.getName()));
            }
            int defaultTimeToLive = metadata.getOptions().getDefaultTimeToLive();
            Validator.validateBeanMappingTrue((boolean)staticTTL.get().equals(defaultTimeToLive), (String)"Default TTL '%s' declared on entity '%s' does not match detected default TTL '%s' in live schema", (Object[])new Object[]{staticTTL.get(), entityClass.getCanonicalName(), defaultTimeToLive});
        }
    }

    public static <T> void validateColumnType(ColumnType columnType, AbstractTableMetadata metadata, List<AbstractProperty<T, ?, ?>> properties, Class<T> entityClass) {
        List mappedColumnNames = properties.stream().map(x -> x.fieldInfo.cqlColumn).collect(Collectors.toList());
        String className = entityClass.getCanonicalName();
        switch (columnType) {
            case PARTITION: {
                List partitionKeyColumnNames = metadata.getPartitionKey().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
                Validator.validateBeanMappingTrue((boolean)CollectionUtils.isEqualCollection(mappedColumnNames, partitionKeyColumnNames), (String)"The mapped partition key(s) %s for entity %s do not correspond to live schema partition key(s) %s", (Object[])new Object[]{mappedColumnNames.stream().collect(Collectors.joining(", ", "[", "]")), className, partitionKeyColumnNames.stream().collect(Collectors.joining(", ", "[", "]"))});
                return;
            }
            case CLUSTERING: {
                List clusteringColColumnNames = metadata.getClusteringColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
                Validator.validateBeanMappingTrue((boolean)CollectionUtils.isEqualCollection(mappedColumnNames, clusteringColColumnNames), (String)"The mapped clustering column(s) %s for entity %s do not correspond to live schema clustering column(s) %s", (Object[])new Object[]{mappedColumnNames.stream().collect(Collectors.joining(", ", "[", "]")), className, clusteringColColumnNames.stream().collect(Collectors.joining(", ", "[", "]"))});
                return;
            }
            case STATIC: {
                List staticColColumnNames = metadata.getColumns().stream().filter(ColumnMetadata::isStatic).map(ColumnMetadata::getName).collect(Collectors.toList());
                Validator.validateBeanMappingTrue((boolean)CollectionUtils.isEqualCollection(mappedColumnNames, staticColColumnNames), (String)"The mapped static column(s) %s for entity %s do not correspond to live schema static column(s) %s", (Object[])new Object[]{mappedColumnNames.stream().collect(Collectors.joining(", ", "[", "]")), className, staticColColumnNames.stream().collect(Collectors.joining(", ", "[", "]"))});
                return;
            }
        }
    }

    public static <T> void validateColumns(AbstractTableMetadata metadata, List<AbstractProperty<T, ?, ?>> properties, Class<T> entityClass) {
        for (AbstractProperty<T, ?, ?> x : properties) {
            String cqlColumn = x.fieldInfo.quotedCqlColumn;
            ColumnMetadata columnMeta = metadata.getColumn(cqlColumn);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Validating column %s for table %s", cqlColumn, metadata.getName()));
            }
            Validator.validateBeanMappingTrue((columnMeta != null ? 1 : 0) != 0, (String)"Cannot find column '%s' in live schema for entity '%s'", (Object[])new Object[]{cqlColumn, entityClass});
            DataType runtimeType = columnMeta.getType();
            DataType staticType = x.buildType(Optional.empty());
            Validator.validateBeanMappingTrue((boolean)runtimeType.equals(staticType), (String)"Data type '%s' for column '%s' of entity '%s' does not match type in live schema '%s'", (Object[])new Object[]{staticType, cqlColumn, entityClass, runtimeType});
            if (x.fieldInfo.hasIndex()) {
                TableMetadata tableMetadata = (TableMetadata)metadata;
                String indexName = x.fieldInfo.indexInfo.name;
                IndexMetadata indexMetadata = tableMetadata.getIndex(indexName);
                if (x.fieldInfo.indexInfo.impl == IndexImpl.NATIVE) {
                    Validator.validateBeanMappingTrue((indexMetadata != null ? 1 : 0) != 0, (String)"Cannot find index name '%s' for column '%s' of entity '%s' in live schema", (Object[])new Object[]{indexName, cqlColumn, entityClass});
                    SchemaValidator.validateNativeIndex(entityClass, x, cqlColumn, indexMetadata);
                } else if (x.fieldInfo.indexInfo.impl == IndexImpl.SASI) {
                    Validator.validateBeanMappingTrue((indexMetadata != null ? 1 : 0) != 0, (String)"Cannot find index name '%s' for column '%s' of entity '%s' in live schema", (Object[])new Object[]{indexName, cqlColumn, entityClass});
                    SchemaValidator.validateSASIIndex(entityClass, x, cqlColumn, indexMetadata);
                } else if (x.fieldInfo.indexInfo.impl == IndexImpl.DSE_SEARCH) {
                    SchemaValidator.validateDSESearchIndex(entityClass, tableMetadata);
                }
            }
            if (x.fieldInfo.columnType != ColumnType.STATIC && x.fieldInfo.columnType != ColumnType.STATIC_COUNTER) continue;
            Validator.validateBeanMappingTrue((boolean)columnMeta.isStatic(), (String)"Column '%s' of entity '%s' should be static", (Object[])new Object[]{cqlColumn, entityClass});
        }
    }

    private static void validateDSESearchIndex(Class<?> entityClass, TableMetadata tableMetadata) {
        String tableName = tableMetadata.getName().toLowerCase();
        String keyspaceName = tableMetadata.getKeyspace().getName().toLowerCase();
        String indexName = keyspaceName + "_" + tableName + "_solr_query_index";
        Optional<IndexMetadata> indexMeta = Optional.ofNullable(tableMetadata.getIndex(indexName));
        Validator.validateBeanMappingTrue((boolean)indexMeta.isPresent(), (String)"Index name %s for entity '%s' cannot be found", (Object[])new Object[]{indexName, entityClass});
        IndexMetadata indexMetadata = indexMeta.get();
        String indexClassName = indexMetadata.getIndexClassName();
        Validator.validateBeanMappingTrue((boolean)indexClassName.equals("com.datastax.bdp.search.solr.Cql3SolrSecondaryIndex"), (String)"Index class name %s for entity '%s' should be %s", (Object[])new Object[]{indexClassName, entityClass, "com.datastax.bdp.search.solr.Cql3SolrSecondaryIndex"});
    }

    private static void validateSASIIndex(Class<?> entityClass, AbstractProperty<?, ?, ?> x, String cqlColumn, IndexMetadata indexMetadata) {
        SASIInfoContext sasiInfo = x.fieldInfo.indexInfo.sasiInfoContext.get();
        String indexName = sasiInfo.indexName;
        Validator.validateBeanMappingTrue((boolean)sasiInfo.indexMode.name().equals(indexMetadata.getOption("mode")), (String)"Index name %s for column '%s' of entity '%s' should have option 'mode' = %s", (Object[])new Object[]{indexName, cqlColumn, entityClass, indexMetadata.getOption("mode")});
        Validator.validateBeanMappingTrue((boolean)(sasiInfo.maxCompactionFlushMemoryInMb + "").equals(indexMetadata.getOption("max_compaction_flush_memory_in_mb")), (String)"Index name %s for column '%s' of entity '%s' should have option 'max_compaction_flush_memory_in_mb' = %s", (Object[])new Object[]{indexName, cqlColumn, entityClass, indexMetadata.getOption("max_compaction_flush_memory_in_mb")});
        if (sasiInfo.analyzed) {
            Validator.validateBeanMappingTrue((boolean)indexMetadata.getOption("analyzed").equals("true"), (String)"Index name %s for column '%s' of entity '%s' should have option 'analyzed' = true", (Object[])new Object[]{indexName, cqlColumn, entityClass});
            Validator.validateBeanMappingTrue((boolean)sasiInfo.analyzerClass.analyzerClass().equals(indexMetadata.getOption("analyzer_class")), (String)"Index name %s for column '%s' of entity '%s' should have option 'analyzerClass' = %s", (Object[])new Object[]{indexName, cqlColumn, entityClass, indexMetadata.getOption("analyzerClass")});
            if (sasiInfo.analyzerClass == SASI.Analyzer.STANDARD_ANALYZER) {
                Validator.validateBeanMappingTrue((boolean)sasiInfo.locale.trim().toLowerCase().equals(indexMetadata.getOption("tokenization_locale")), (String)"Index name %s for column '%s' of entity '%s' should have option 'tokenization_locale' = %s", (Object[])new Object[]{indexName, cqlColumn, entityClass, indexMetadata.getOption("tokenization_locale")});
                Validator.validateBeanMappingTrue((boolean)(sasiInfo.enableStemming + "").equals(indexMetadata.getOption("tokenization_enable_stemming")), (String)"Index name %s for column '%s' of entity '%s' should have option 'tokenization_enable_stemming' = %s", (Object[])new Object[]{indexName, cqlColumn, entityClass, indexMetadata.getOption("tokenization_enable_stemming")});
                Validator.validateBeanMappingTrue((boolean)(sasiInfo.skipStopWords + "").equals(indexMetadata.getOption("tokenization_skip_stop_words")), (String)"Index name %s for column '%s' of entity '%s' should have option 'tokenization_skip_stop_words' = %s", (Object[])new Object[]{indexName, cqlColumn, entityClass, indexMetadata.getOption("tokenization_skip_stop_words")});
                String normalization = sasiInfo.normalization.forStandardAnalyzer();
                String liveNormalization = indexMetadata.getOption(normalization);
                Validator.validateBeanMappingTrue((StringUtils.isNotBlank((CharSequence)liveNormalization) && liveNormalization.equals("true") ? 1 : 0) != 0, (String)"Index name %s for column '%s' of entity '%s' should have option '%s' = true", (Object[])new Object[]{indexName, cqlColumn, entityClass, normalization});
            } else if (sasiInfo.analyzerClass == SASI.Analyzer.NON_TOKENIZING_ANALYZER) {
                if (sasiInfo.normalization == SASI.Normalization.NONE) {
                    String liveCasseSensitive = indexMetadata.getOption("case_sensitive");
                    Validator.validateBeanMappingTrue((StringUtils.isNotBlank((CharSequence)liveCasseSensitive) && liveCasseSensitive.equals("true") ? 1 : 0) != 0, (String)"Index name %s for column '%s' of entity '%s' should have option 'case_sensitive' = true", (Object[])new Object[]{indexName, cqlColumn, entityClass});
                } else {
                    String normalization = sasiInfo.normalization.forNonTokenizingAnalyzer();
                    String liveNormalization = indexMetadata.getOption(normalization);
                    Validator.validateBeanMappingTrue((StringUtils.isNotBlank((CharSequence)liveNormalization) && liveNormalization.equals("true") ? 1 : 0) != 0, (String)"Index name %s for column '%s' of entity '%s' should have option '%s' = true", (Object[])new Object[]{indexName, cqlColumn, entityClass, normalization});
                }
            }
        }
    }

    private static void validateNativeIndex(Class<?> entityClass, AbstractProperty<?, ?, ?> x, String cqlColumn, IndexMetadata indexMetadata) {
        IndexInfo indexInfo = x.fieldInfo.indexInfo;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Validating index on column %s of table %s", cqlColumn, indexMetadata.getTable().getName()));
        }
        String indexName = indexInfo.name;
        Validator.validateBeanMappingTrue((boolean)indexName.equals(indexMetadata.getName()), (String)"Index name '%s' for column '%s' of entity '%s' does not match name '%s' in live schema", (Object[])new Object[]{indexName, cqlColumn, entityClass, indexMetadata.getName()});
        String indexTarget = indexMetadata.getTarget().toLowerCase();
        boolean isIndexOnFullCollection = indexTarget.contains(String.format("full(%s)", cqlColumn));
        boolean isIndexOnMapEntries = indexTarget.contains(String.format("entries(%s)", cqlColumn));
        boolean isIndexOnMapKeys = indexTarget.contains(String.format("keys(%s)", cqlColumn));
        boolean isCustomIndex = indexMetadata.isCustomIndex();
        switch (indexInfo.type) {
            case NORMAL: {
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapEntries, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.NORMAL, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnFullCollection, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.NORMAL, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapKeys, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.NORMAL, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isCustomIndex, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.NORMAL, cqlColumn, entityClass});
                break;
            }
            case COLLECTION: {
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapEntries, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.COLLECTION, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnFullCollection, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.COLLECTION, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapKeys, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.COLLECTION, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isCustomIndex, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.COLLECTION, cqlColumn, entityClass});
                break;
            }
            case FULL: {
                Validator.validateBeanMappingTrue((boolean)isIndexOnFullCollection, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.FULL, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapEntries, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.FULL, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapKeys, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.FULL, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isCustomIndex, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.FULL, cqlColumn, entityClass});
                break;
            }
            case MAP_ENTRY: {
                Validator.validateBeanMappingTrue((boolean)isIndexOnMapEntries, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.MAP_ENTRY, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnFullCollection, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.MAP_ENTRY, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapKeys, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.MAP_ENTRY, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isCustomIndex, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.MAP_ENTRY, cqlColumn, entityClass});
                break;
            }
            case MAP_KEY: {
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapEntries, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.MAP_KEY, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnFullCollection, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.MAP_KEY, cqlColumn, entityClass});
                Validator.validateBeanMappingTrue((boolean)isIndexOnMapKeys, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.MAP_KEY, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isCustomIndex, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.MAP_KEY, cqlColumn, entityClass});
                break;
            }
            case CUSTOM: {
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapEntries, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.CUSTOM, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnFullCollection, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.CUSTOM, cqlColumn, entityClass});
                Validator.validateBeanMappingFalse((boolean)isIndexOnMapKeys, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.CUSTOM, cqlColumn, entityClass});
                Validator.validateBeanMappingTrue((boolean)isCustomIndex, (String)"Index type '%s' for column '%s' of entity '%s' does not match type in live schema", (Object[])new Object[]{IndexType.CUSTOM, cqlColumn, entityClass});
            }
        }
    }
}

