/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.statements;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import info.archinnov.achilles.internals.types.ResultSetWrapper;
import java.util.UUID;

public class NativeStatementWrapper
implements StatementWrapper {
    private final AbstractEntityProperty<?> meta;
    private final BoundStatement boundStatement;
    private final Object[] encodedBoundValues;
    private final UUID queryId = UUID.randomUUID();
    private final OperationType operationType;

    public NativeStatementWrapper(OperationType operationType, AbstractEntityProperty<?> meta, BoundStatement boundStatement, Object[] encodedBoundValues) {
        this.meta = meta;
        this.boundStatement = boundStatement;
        this.encodedBoundValues = encodedBoundValues;
        this.operationType = operationType;
    }

    @Override
    public Object[] getBoundValues() {
        return this.encodedBoundValues;
    }

    @Override
    public BoundStatement getBoundStatement() {
        return this.boundStatement;
    }

    @Override
    public void applyOptions(CassandraOptions cassandraOptions) {
        cassandraOptions.applyOptions(this.operationType, this.meta, (Statement)this.boundStatement);
    }

    @Override
    public void logDML() {
        this.writeDMLStatementLog(DML_LOGGER, this.queryId, this.boundStatement.preparedStatement().getQueryString(), this.boundStatement.getConsistencyLevel(), new Object[0], this.encodedBoundValues);
    }

    @Override
    public ResultSet logReturnResults(ResultSet originalResultSet, int maxDisplayedRows) {
        if (DML_LOGGER.isDebugEnabled()) {
            ResultSetWrapper wrapper = new ResultSetWrapper(originalResultSet);
            this.logReturnedResultsInternal(DML_LOGGER, this.queryId, wrapper, maxDisplayedRows);
            return wrapper;
        }
        return originalResultSet;
    }

    @Override
    public Row logReturnedRow(Row row) {
        if (DML_LOGGER.isDebugEnabled()) {
            this.logReturnedRowInternal(DML_LOGGER, this.queryId, row);
        }
        return row;
    }

    @Override
    public ResultSet logTrace(ResultSet resultSet) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Maybe display tracing for query %s", this.boundStatement.preparedStatement().getQueryString()));
        }
        this.tracingInternal(DML_LOGGER, this.queryId, resultSet);
        return resultSet;
    }
}

