/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.statements;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import info.archinnov.achilles.internals.cache.CacheKey;
import info.archinnov.achilles.internals.cache.StatementsCache;
import info.archinnov.achilles.internals.cassandra_version.CassandraFeature;
import info.archinnov.achilles.internals.cassandra_version.InternalCassandraVersion;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.ComputedProperty;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.columns.ComputedColumnInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreparedStatementGenerator.class);

    public static void generateStaticSelectQuery(Session session, StatementsCache cache, AbstractEntityProperty<?> entityProperty) {
        RegularStatement where = PreparedStatementGenerator.generateSelectQuery(entityProperty, Optional.empty());
        cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.FIND), () -> session.prepare(where));
    }

    public static RegularStatement generateSelectQuery(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        Select from;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate SELECT query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Select.Selection select = QueryBuilder.select();
        Optional<String> keyspace = entityProperty.getKeyspace();
        for (AbstractProperty x2 : entityProperty.allColumns) {
            select.column(x2.fieldInfo.quotedCqlColumn);
        }
        entityProperty.computedColumns.stream().map(x -> (ComputedProperty)x).forEach(x -> {
            ComputedColumnInfo columnInfo = x.computedColumnInfo;
            Object[] args = columnInfo.functionArgs.stream().map(QueryBuilder::column).toArray();
            select.fcall(columnInfo.functionName, args).as(columnInfo.alias);
        });
        if (schemaNameProvider.isPresent()) {
            SchemaNameProvider provider = schemaNameProvider.get();
            from = select.from(provider.keyspaceFor(entityProperty.entityClass), provider.tableNameFor(entityProperty.entityClass));
        } else {
            from = keyspace.isPresent() ? select.from(keyspace.get(), entityProperty.getTableOrViewName()) : select.from(entityProperty.getTableOrViewName());
        }
        Select.Where where = from.where();
        for (AbstractProperty x3 : entityProperty.partitionKeys) {
            where.and(QueryBuilder.eq((String)x3.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x3.fieldInfo.quotedCqlColumn)));
        }
        for (AbstractProperty x3 : entityProperty.clusteringColumns) {
            where.and(QueryBuilder.eq((String)x3.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x3.fieldInfo.quotedCqlColumn)));
        }
        return where;
    }

    public static void generateStaticDeleteQueries(Session session, StatementsCache cache, AbstractEntityProperty<?> entityProperty) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate DELETE queries for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.DELETE), () -> session.prepare(PreparedStatementGenerator.generateDeleteByKeys(entityProperty, Optional.empty())));
        if (!entityProperty.isCounter()) {
            cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.DELETE_IF_EXISTS), () -> session.prepare(PreparedStatementGenerator.generateDeleteByKeysIfExists(entityProperty, Optional.empty())));
        }
        if (entityProperty.isClustered()) {
            cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.DELETE_BY_PARTITION), () -> session.prepare(PreparedStatementGenerator.generateDeleteByPartition(entityProperty, Optional.empty())));
        }
    }

    public static RegularStatement generateDeleteByKeys(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate DELETE query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Delete.Selection delete = QueryBuilder.delete();
        Optional<String> keyspace = entityProperty.getKeyspace();
        Delete from = PreparedStatementGenerator.lookupSchemaFromProvider(entityProperty, schemaNameProvider, delete, keyspace);
        Delete.Where deleteByKeys = from.where();
        for (AbstractProperty x : entityProperty.partitionKeys) {
            deleteByKeys.and(QueryBuilder.eq((String)x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn)));
        }
        for (AbstractProperty x : entityProperty.clusteringColumns) {
            deleteByKeys.and(QueryBuilder.eq((String)x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn)));
        }
        return deleteByKeys;
    }

    public static RegularStatement generateDeleteByKeysIfExists(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate DELETE IF EXISTS query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Delete.Selection delete = QueryBuilder.delete();
        Optional<String> keyspace = entityProperty.getKeyspace();
        Delete from = PreparedStatementGenerator.lookupSchemaFromProvider(entityProperty, schemaNameProvider, delete, keyspace);
        Delete.Where deleteByKeysIfExists = from.ifExists().where();
        for (AbstractProperty x : entityProperty.partitionKeys) {
            deleteByKeysIfExists.and(QueryBuilder.eq((String)x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn)));
        }
        for (AbstractProperty x : entityProperty.clusteringColumns) {
            deleteByKeysIfExists.and(QueryBuilder.eq((String)x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn)));
        }
        return deleteByKeysIfExists;
    }

    public static RegularStatement generateDeleteByPartition(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate DELETE BY PARTITION query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Delete.Selection delete = QueryBuilder.delete();
        Optional<String> keyspace = entityProperty.getKeyspace();
        Delete from = PreparedStatementGenerator.lookupSchemaFromProvider(entityProperty, schemaNameProvider, delete, keyspace);
        Delete.Where deleteByPartition = from.where();
        for (AbstractProperty x : entityProperty.partitionKeys) {
            deleteByPartition.and(QueryBuilder.eq((String)x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn)));
        }
        return deleteByPartition;
    }

    public static void generateStaticInsertQueries(InternalCassandraVersion cassandraVersion, Session session, StatementsCache cache, AbstractEntityProperty<?> entityProperty) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate INSERT queries for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.INSERT), () -> session.prepare(PreparedStatementGenerator.generateInsert(entityProperty, Optional.empty())));
        cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.INSERT_IF_NOT_EXISTS), () -> session.prepare(PreparedStatementGenerator.generateInsertIfNotExists(entityProperty, Optional.empty())));
        if (cassandraVersion.supportsFeature(CassandraFeature.JSON)) {
            cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.INSERT_JSON), () -> session.prepare(PreparedStatementGenerator.generateInsertJSON(entityProperty, Optional.empty())));
            cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.INSERT_IF_NOT_EXISTS_JSON), () -> session.prepare(PreparedStatementGenerator.generateInsertIfNotExistsJson(entityProperty, Optional.empty())));
        }
        if (entityProperty.hasStaticColumn()) {
            cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.INSERT_STATIC), () -> session.prepare(PreparedStatementGenerator.generateInsertStatic(entityProperty, Optional.empty())));
            cache.putStaticCache(new CacheKey(entityProperty.entityClass, CacheKey.Operation.INSERT_STATIC_IF_NOT_EXISTS), () -> session.prepare(PreparedStatementGenerator.generateInsertStaticIfNotExists(entityProperty, Optional.empty())));
        }
    }

    public static RegularStatement generateInsert(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate INSERT query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Insert insert = PreparedStatementGenerator.getInsertWithTableName(entityProperty, schemaNameProvider);
        for (AbstractProperty x : entityProperty.allColumns) {
            insert.value(x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn));
        }
        return insert.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
    }

    public static <T> RegularStatement generateUpdate(T instance, AbstractEntityProperty<T> entityProperty, CassandraOptions options, boolean staticValuesOnly, boolean ifExists) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate UPDATE query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Update update = PreparedStatementGenerator.getUpdateWithTableName(entityProperty, options.getSchemaNameProvider());
        if (options.hasDefaultTimestamp()) {
            update.using(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)"timestamp")));
        }
        update.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
        Update.Assignments assignments = update.with();
        entityProperty.allColumns.stream().filter(x -> x.fieldInfo.columnType != ColumnType.PARTITION).filter(x -> x.fieldInfo.columnType != ColumnType.CLUSTERING).filter(x -> staticValuesOnly ? x.fieldInfo.columnType == ColumnType.STATIC : true).filter(x -> x.getJavaValue(instance) != null).forEach(x -> assignments.and(QueryBuilder.set((String)x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn))));
        Update.Where where = update.where();
        entityProperty.partitionKeys.forEach(x -> where.and(QueryBuilder.eq((String)x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn))));
        if (!staticValuesOnly) {
            entityProperty.clusteringColumns.forEach(x -> where.and(QueryBuilder.eq((String)x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn))));
        }
        if (ifExists) {
            where.ifExists();
        }
        return where;
    }

    public static RegularStatement generateInsertJSON(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate INSERT JSON query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Insert insert = PreparedStatementGenerator.getInsertWithTableName(entityProperty, schemaNameProvider);
        insert.json((Object)QueryBuilder.bindMarker((String)"json"));
        return insert.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
    }

    public static RegularStatement generateInsertStatic(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate INSERT STATIC query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Validator.validateBeanMappingTrue((boolean)entityProperty.hasStaticColumn(), (String)"Cannot generate INSERT STATIC query for entity of type %s because it has no static column", (Object[])new Object[0]);
        Insert insert = PreparedStatementGenerator.getInsertWithTableName(entityProperty, schemaNameProvider);
        for (AbstractProperty x : entityProperty.partitionKeys) {
            insert.value(x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn));
        }
        for (AbstractProperty x : entityProperty.staticColumns) {
            insert.value(x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn));
        }
        return insert.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
    }

    public static RegularStatement generateInsertIfNotExists(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate INSERT IF NOT EXISTS query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Insert insert = PreparedStatementGenerator.getInsertWithTableName(entityProperty, schemaNameProvider);
        for (AbstractProperty x : entityProperty.allColumns) {
            insert.value(x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn));
        }
        return insert.ifNotExists().using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
    }

    public static RegularStatement generateInsertIfNotExistsJson(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate INSERT JSON ... IF NOT EXISTS query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Insert insert = PreparedStatementGenerator.getInsertWithTableName(entityProperty, schemaNameProvider);
        insert.json((Object)QueryBuilder.bindMarker((String)"json"));
        return insert.ifNotExists().using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
    }

    public static RegularStatement generateInsertStaticIfNotExists(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generate INSERT STATIC IF NOT EXISTS query for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        Validator.validateBeanMappingTrue((boolean)entityProperty.hasStaticColumn(), (String)"Cannot generate INSERT IF NOT EXISTS query for entity of type %s because it has no static column", (Object[])new Object[0]);
        Insert insert = PreparedStatementGenerator.getInsertWithTableName(entityProperty, schemaNameProvider);
        for (AbstractProperty x : entityProperty.partitionKeys) {
            insert.value(x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn));
        }
        for (AbstractProperty x : entityProperty.staticColumns) {
            insert.value(x.fieldInfo.quotedCqlColumn, (Object)QueryBuilder.bindMarker((String)x.fieldInfo.quotedCqlColumn));
        }
        return insert.ifNotExists().using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
    }

    private static Insert getInsertWithTableName(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        Insert insert;
        Optional<String> keyspace = entityProperty.getKeyspace();
        if (schemaNameProvider.isPresent()) {
            SchemaNameProvider provider = schemaNameProvider.get();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Get INSERT query for entity of type %s with schema provider %s", entityProperty.entityClass.getCanonicalName(), provider));
            }
            insert = QueryBuilder.insertInto((String)provider.keyspaceFor(entityProperty.entityClass), (String)provider.tableNameFor(entityProperty.entityClass));
        } else {
            insert = keyspace.isPresent() ? QueryBuilder.insertInto((String)keyspace.get(), (String)entityProperty.getTableOrViewName()) : QueryBuilder.insertInto((String)entityProperty.getTableOrViewName());
        }
        return insert;
    }

    private static Update getUpdateWithTableName(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider) {
        Update update;
        Optional<String> keyspace = entityProperty.getKeyspace();
        if (schemaNameProvider.isPresent()) {
            SchemaNameProvider provider = schemaNameProvider.get();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Get UPDATE query for entity of type %s with schema provider %s", entityProperty.entityClass.getCanonicalName(), provider));
            }
            update = QueryBuilder.update((String)provider.keyspaceFor(entityProperty.entityClass), (String)provider.tableNameFor(entityProperty.entityClass));
        } else {
            update = keyspace.isPresent() ? QueryBuilder.update((String)keyspace.get(), (String)entityProperty.getTableOrViewName()) : QueryBuilder.update((String)entityProperty.getTableOrViewName());
        }
        return update;
    }

    private static Delete lookupSchemaFromProvider(AbstractEntityProperty<?> entityProperty, Optional<SchemaNameProvider> schemaNameProvider, Delete.Selection delete, Optional<String> keyspace) {
        Delete from;
        if (schemaNameProvider.isPresent()) {
            SchemaNameProvider provider = schemaNameProvider.get();
            from = delete.from(provider.keyspaceFor(entityProperty.entityClass), provider.tableNameFor(entityProperty.entityClass));
        } else {
            from = keyspace.isPresent() ? delete.from(keyspace.get(), entityProperty.getTableOrViewName()) : delete.from(entityProperty.getTableOrViewName());
        }
        return from;
    }
}

