/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.statements;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import info.archinnov.achilles.internals.cql.TypeMapper;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.types.ResultSetWrapper;
import info.archinnov.achilles.internals.utils.LoggerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface StatementWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(StatementWrapper.class);
    public static final EventComparator EVENT_TRACE_COMPARATOR = new EventComparator();
    public static final Logger DML_LOGGER = LoggerFactory.getLogger((String)"ACHILLES_DML_STATEMENT");

    public Object[] getBoundValues();

    public BoundStatement getBoundStatement();

    public void applyOptions(CassandraOptions var1);

    public void logDML();

    public ResultSet logReturnResults(ResultSet var1, int var2);

    public Row logReturnedRow(Row var1);

    public ResultSet logTrace(ResultSet var1);

    default public void writeDMLStatementLog(Logger actualLogger, UUID queryId, String queryString, ConsistencyLevel consistencyLevel, Object[] boundValues, Object[] encodedValues) {
        if (actualLogger.isDebugEnabled()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Writing DML log for query %s with id %s", queryString, queryId));
            }
            StringBuilder logBuilder = new StringBuilder("\n");
            logBuilder.append(String.format("Query ID %s : [%s] with CONSISTENCY LEVEL [%s]", queryId.toString(), queryString, consistencyLevel));
            if (ArrayUtils.isNotEmpty((Object[])boundValues)) {
                logBuilder.append(String.format("\n\t Java bound values : %s", LoggerHelper.replaceByteBuffersByHexString(boundValues)));
                logBuilder.append(String.format("\n\t Encoded bound values : %s", LoggerHelper.replaceByteBuffersByHexString(encodedValues)));
            }
            actualLogger.debug(logBuilder.toString());
        }
    }

    default public void logReturnedResultsInternal(Logger actualLogger, UUID queryId, ResultSetWrapper resultSet, int maxDisplayedRows) {
        if (maxDisplayedRows > 0) {
            int availableWithoutFetching = resultSet.getAvailableWithoutFetching();
            StringBuilder results = new StringBuilder(String.format("Query ID %s results : \n", queryId));
            actualLogger.debug(resultSet.toString());
            for (int i = 0; i < Integer.min(availableWithoutFetching, maxDisplayedRows); ++i) {
                Row row = resultSet.peek();
                this.appendRowDataToBuilder(row, row.getColumnDefinitions().asList(), results);
            }
            actualLogger.debug(results.toString());
        }
    }

    default public void logReturnedRowInternal(Logger actualLogger, UUID queryId, Row row) {
        StringBuilder results = new StringBuilder(String.format("Query ID %s row : \n", queryId));
        this.appendRowDataToBuilder(row, row.getColumnDefinitions().asList(), results);
        actualLogger.debug(results.toString());
    }

    default public void appendRowDataToBuilder(Row row, List<ColumnDefinitions.Definition> columnsDef, StringBuilder builder) {
        StringJoiner joiner = new StringJoiner(", ", "\t", "\n");
        IntStream.range(0, columnsDef.size()).forEach(index -> {
            ColumnDefinitions.Definition def = (ColumnDefinitions.Definition)columnsDef.get(index);
            Object value = this.extractValueFromRow(row, index, def.getType());
            joiner.add(String.format("%s: %s", def.getName(), value));
        });
        builder.append(joiner.toString());
    }

    default public Object extractValueFromRow(Row row, int index, DataType dataType) {
        DataType.Name typeName = dataType.getName();
        switch (typeName) {
            case LIST: 
            case SET: 
            case MAP: 
            case TUPLE: 
            case CUSTOM: {
                return row.getObject(index);
            }
        }
        return row.get(index, TypeMapper.toJavaType(typeName));
    }

    default public void tracingInternal(Logger actualLogger, UUID queryId, ResultSet resultSet) {
        StringBuilder trace = new StringBuilder();
        if (actualLogger.isTraceEnabled()) {
            for (ExecutionInfo executionInfo : resultSet.getAllExecutionInfo()) {
                trace.append(String.format("\n\nTracing for Query ID %s at host %s with achieved consistency level %s \n", queryId.toString(), executionInfo.getQueriedHost(), executionInfo.getAchievedConsistencyLevel()));
                trace.append("****************************\n");
                trace.append(String.format("%1$-80s | %2$-16s | %3$-24s | %4$-20s\n", "Description", "Source", "Source elapsed in micros", "Thread name"));
                try {
                    QueryTrace queryTrace = executionInfo.getQueryTrace();
                    if (queryTrace != null) {
                        ArrayList events = new ArrayList(queryTrace.getEvents());
                        Collections.sort(events, EVENT_TRACE_COMPARATOR);
                        for (QueryTrace.Event event : events) {
                            trace.append(String.format("%1$-80s | %2$-16s | %3$-24s | %4$-20s\n", event.getDescription(), event.getSource(), event.getSourceElapsedMicros(), event.getThreadName()));
                        }
                    }
                }
                catch (TraceRetrievalException e) {
                    String queryString = this.getBoundStatement().preparedStatement().getQueryString();
                    trace.append(String.format(" ERROR: cannot retrieve trace for query %s because it may not be yet available", queryString));
                }
                trace.append("****************************\n\n");
            }
            actualLogger.trace(trace.toString());
        }
    }

    public static class EventComparator
    implements Comparator<QueryTrace.Event> {
        @Override
        public int compare(QueryTrace.Event event1, QueryTrace.Event event2) {
            return event1.getSource().toString().compareTo(event2.getSource().toString());
        }
    }
}

