/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OverridingOptional<T> {
    private final List<Optional<T>> options = new ArrayList<Optional<T>>();
    private T defaultValue;

    private OverridingOptional(Optional<T> source) {
        this.options.add(source);
    }

    public static <T> OverridingOptional<T> from(Optional<T> source) {
        return new OverridingOptional<T>(source);
    }

    public static <T> OverridingOptional<T> from(T nullableSource) {
        return new OverridingOptional<T>(Optional.ofNullable(nullableSource));
    }

    public OverridingOptional<T> andThen(Optional<T> next) {
        this.options.add(next);
        return this;
    }

    public OverridingOptional<T> andThen(T nullableNext) {
        this.options.add(Optional.ofNullable(nullableNext));
        return this;
    }

    public Optional<T> getOptional() {
        return this.options.stream().filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public OverridingOptionalFinal defaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return new OverridingOptionalFinal();
    }

    public class OverridingOptionalFinal {
        private OverridingOptionalFinal() {
        }

        public T get() {
            Optional<Object> finalOption = OverridingOptional.this.options.stream().filter(Optional::isPresent).map(Optional::get).findFirst();
            return finalOption.orElse(OverridingOptional.this.defaultValue);
        }
    }
}

