/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.types;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internals.types.ResultLoggingIteratorWrapper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ResultSetWrapper
implements ResultSet {
    private final ResultSet delegate;
    private final LinkedList<Row> values = new LinkedList();

    public ResultSetWrapper(ResultSet delegate) {
        this.delegate = delegate;
    }

    public ColumnDefinitions getColumnDefinitions() {
        return this.delegate.getColumnDefinitions();
    }

    public boolean isExhausted() {
        return this.values.size() == 0 && this.delegate.isExhausted();
    }

    public Row peek() {
        Row row = this.delegate.one();
        this.values.add(row);
        return row;
    }

    public Row one() {
        if (this.values.size() > 0) {
            return this.values.poll();
        }
        return this.delegate.one();
    }

    public List<Row> all() {
        this.values.addAll(this.delegate.all());
        return this.values;
    }

    public Iterator<Row> iterator() {
        return new ResultLoggingIteratorWrapper<Row>(this.values, this.delegate.iterator());
    }

    public int getAvailableWithoutFetching() {
        return this.values.size() + this.delegate.getAvailableWithoutFetching();
    }

    public boolean isFullyFetched() {
        return this.delegate.isFullyFetched();
    }

    public ListenableFuture<ResultSet> fetchMoreResults() {
        throw new UnsupportedOperationException("Not supported by Achilles ResultSetWrapper");
    }

    public ExecutionInfo getExecutionInfo() {
        return this.delegate.getExecutionInfo();
    }

    public List<ExecutionInfo> getAllExecutionInfo() {
        return this.delegate.getAllExecutionInfo();
    }

    public boolean wasApplied() {
        return this.delegate.wasApplied();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

