/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.types;

import info.archinnov.achilles.exception.AchillesTranscodingException;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import java.util.Map;
import java.util.Optional;

public class RuntimeCodecWrapper<FROM, TO>
implements Codec<FROM, TO> {
    public final Class<FROM> sourceType;
    public final Class<TO> targetType;
    public final Optional<String> codecName;
    private Codec<FROM, TO> delegate;

    public RuntimeCodecWrapper(Class<FROM> sourceType, Class<TO> targetType, Optional<String> codecName) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.codecName = codecName;
    }

    public Class<FROM> sourceType() {
        return this.sourceType;
    }

    public Class<TO> targetType() {
        return this.targetType;
    }

    public TO encode(FROM fromJava) throws AchillesTranscodingException {
        return (TO)this.delegate.encode(fromJava);
    }

    public FROM decode(TO fromCassandra) throws AchillesTranscodingException {
        return (FROM)this.delegate.decode(fromCassandra);
    }

    public void inject(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecRegistry) {
        CodecSignature mySignature = new CodecSignature(this.sourceType, this.targetType, this.codecName);
        if (!runtimeCodecRegistry.containsKey(mySignature)) {
            throw new AchillesTranscodingException(String.format("Cannot find runtime codec for %s. Did you forget to register it with the ManagerFactoryBuilder ?", mySignature));
        }
        this.delegate = runtimeCodecRegistry.get(mySignature);
    }
}

