/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.utils;

import com.datastax.driver.core.utils.Bytes;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class LoggerHelper {
    public static final int HEX_STRING_LOG_LIMIT = 16;

    public static List<Object> replaceByteBuffersByHexString(Object ... values) {
        ArrayList<Object> boundValues = new ArrayList<Object>(Arrays.asList(values));
        for (int valuePos = 0; valuePos < boundValues.size(); ++valuePos) {
            byte[] firstBytes;
            Object boundValue = boundValues.get(valuePos);
            if (boundValue instanceof ByteBuffer) {
                ByteBuffer bbBoundedValue = (ByteBuffer)boundValue;
                firstBytes = new byte[Math.min(bbBoundedValue.remaining(), 16)];
                bbBoundedValue.get(firstBytes).rewind();
                boundValues.set(valuePos, LoggerHelper.toHexString(firstBytes, bbBoundedValue.remaining()));
                continue;
            }
            if (!(boundValue instanceof byte[])) continue;
            byte[] baBoundedValue = (byte[])boundValue;
            firstBytes = baBoundedValue.length > 16 ? Arrays.copyOfRange(baBoundedValue, 0, 16) : baBoundedValue;
            boundValues.set(valuePos, LoggerHelper.toHexString(firstBytes, baBoundedValue.length));
        }
        return boundValues;
    }

    public static String toHexString(byte[] firstBytes, int originalLength) {
        return Bytes.toHexString((byte[])firstBytes) + LoggerHelper.more(originalLength);
    }

    private static String more(int length) {
        return length > 16 ? String.format("... (%d)", length) : "";
    }
}

