/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.utils;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.internals.parser.TypeUtils;
import java.util.StringJoiner;

public class TypeNameHelper {
    public static String asString(TypeName type) throws IllegalStateException {
        if (type.isPrimitive()) {
            return type.box().toString().replaceAll("java\\.lang\\.", "");
        }
        if (type instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)type;
            ClassName rawType = parameterizedTypeName.rawType;
            if (rawType.equals((Object)TypeUtils.LIST)) {
                return "List_" + TypeNameHelper.asString((TypeName)parameterizedTypeName.typeArguments.get(0));
            }
            if (rawType.equals((Object)TypeUtils.SET)) {
                return "Set_" + TypeNameHelper.asString((TypeName)parameterizedTypeName.typeArguments.get(0));
            }
            if (rawType.equals((Object)TypeUtils.MAP)) {
                return "Map_" + TypeNameHelper.asString((TypeName)parameterizedTypeName.typeArguments.get(0)) + "_" + TypeNameHelper.asString((TypeName)parameterizedTypeName.typeArguments.get(1));
            }
            if (rawType.equals((Object)TypeUtils.TUPLE1)) {
                return "Tuple1_" + TypeNameHelper.asString((TypeName)parameterizedTypeName.typeArguments.get(0));
            }
            if (rawType.equals((Object)TypeUtils.TUPLE2)) {
                StringJoiner joiner = new StringJoiner("_");
                parameterizedTypeName.typeArguments.forEach(x -> joiner.add(TypeNameHelper.asString(x)));
                return "Tuple2_" + joiner.toString();
            }
            if (rawType.equals((Object)TypeUtils.TUPLE3)) {
                StringJoiner joiner = new StringJoiner("_");
                parameterizedTypeName.typeArguments.forEach(x -> joiner.add(TypeNameHelper.asString(x)));
                return "Tuple3_" + joiner.toString();
            }
            if (rawType.equals((Object)TypeUtils.TUPLE4)) {
                StringJoiner joiner = new StringJoiner("_");
                parameterizedTypeName.typeArguments.forEach(x -> joiner.add(TypeNameHelper.asString(x)));
                return "Tuple4_" + joiner.toString();
            }
            if (rawType.equals((Object)TypeUtils.TUPLE5)) {
                StringJoiner joiner = new StringJoiner("_");
                parameterizedTypeName.typeArguments.forEach(x -> joiner.add(TypeNameHelper.asString(x)));
                return "Tuple5_" + joiner.toString();
            }
            if (rawType.equals((Object)TypeUtils.TUPLE6)) {
                StringJoiner joiner = new StringJoiner("_");
                parameterizedTypeName.typeArguments.forEach(x -> joiner.add(TypeNameHelper.asString(x)));
                return "Tuple6_" + joiner.toString();
            }
            if (rawType.equals((Object)TypeUtils.TUPLE7)) {
                StringJoiner joiner = new StringJoiner("_");
                parameterizedTypeName.typeArguments.forEach(x -> joiner.add(TypeNameHelper.asString(x)));
                return "Tuple7_" + joiner.toString();
            }
            if (rawType.equals((Object)TypeUtils.TUPLE8)) {
                StringJoiner joiner = new StringJoiner("_");
                parameterizedTypeName.typeArguments.forEach(x -> joiner.add(TypeNameHelper.asString(x)));
                return "Tuple8_" + joiner.toString();
            }
            if (rawType.equals((Object)TypeUtils.TUPLE9)) {
                StringJoiner joiner = new StringJoiner("_");
                parameterizedTypeName.typeArguments.forEach(x -> joiner.add(TypeNameHelper.asString(x)));
                return "Tuple9_" + joiner.toString();
            }
            if (rawType.equals((Object)TypeUtils.TUPLE10)) {
                StringJoiner joiner = new StringJoiner("_");
                parameterizedTypeName.typeArguments.forEach(x -> joiner.add(TypeNameHelper.asString(x)));
                return "Tuple10_" + joiner.toString();
            }
            if (rawType.equals((Object)TypeUtils.OPTIONAL)) {
                return "Optional_" + TypeNameHelper.asString((TypeName)parameterizedTypeName.typeArguments.get(0));
            }
            throw new IllegalStateException(String.format("Cannot extract name from unexpected type '%s'", type));
        }
        if (type instanceof ArrayTypeName) {
            ArrayTypeName arrayTypeName = (ArrayTypeName)type;
            TypeName componentType = arrayTypeName.componentType;
            if (componentType.isPrimitive()) {
                return "Array_Primitive_" + componentType.toString().replaceAll("java\\.lang\\.", "");
            }
            return "Array_" + TypeNameHelper.asString(componentType);
        }
        if (type instanceof ClassName) {
            if (type.equals((Object)TypeUtils.JAVA_DRIVER_LOCAL_DATE)) {
                return "DriverLocalDate";
            }
            if (type.equals((Object)TypeUtils.JAVA_TIME_LOCAL_DATE)) {
                return "JavaTimeLocalDate";
            }
            ClassName className = (ClassName)type;
            return className.simpleName();
        }
        throw new IllegalStateException(String.format("Cannot extract name from unexpected type '%s'", type));
    }
}

