/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.type.codec;

import info.archinnov.achilles.validation.Validator;
import java.util.Objects;
import java.util.Optional;

public class CodecSignature<FROM, TO> {
    private final Class<FROM> sourceClass;
    private final Class<TO> targetClass;
    private Optional<String> codecName = Optional.empty();

    public CodecSignature(Class<FROM> sourceClass, Class<TO> targetClass) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    public CodecSignature(Class<FROM> sourceClass, Class<TO> targetClass, Optional<String> codecName) {
        this(sourceClass, targetClass);
        this.codecName = codecName;
    }

    public CodecSignature(Class<FROM> sourceClass, Class<TO> targetClass, String codecName) {
        this(sourceClass, targetClass);
        Validator.validateNotBlank(codecName, "codecName for CodecSignature should not be blank", new Object[0]);
        this.codecName = Optional.of(codecName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodecSignature that = (CodecSignature)o;
        return Objects.equals(this.sourceClass, that.sourceClass) && Objects.equals(this.targetClass, that.targetClass) && Objects.equals(this.codecName, that.codecName);
    }

    public int hashCode() {
        return Objects.hash(this.sourceClass, this.targetClass, this.codecName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CodecSignature{");
        sb.append("sourceClass=").append(this.sourceClass);
        sb.append(", targetClass=").append(this.targetClass);
        sb.append(", codecName=").append(this.codecName);
        sb.append('}');
        return sb.toString();
    }
}

