/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.annotation.After;
import cucumber.annotation.Before;
import cucumber.annotation.Order;
import cucumber.io.ClasspathResourceLoader;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Utils;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.StepDefAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class ClasspathMethodScanner {
    private final ClasspathResourceLoader resourceLoader;
    private final Collection<Class<? extends Annotation>> cucumberAnnotationClasses;

    public ClasspathMethodScanner(ClasspathResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.cucumberAnnotationClasses = this.findCucumberAnnotationClasses();
    }

    public void scan(JavaBackend javaBackend, List<String> gluePaths) {
        for (String gluePath : gluePaths) {
            if (gluePath.contains("/") || gluePath.contains("\\")) {
                throw new CucumberException("Java glue must be a Java package name - not a path: " + gluePath);
            }
            Iterator i$ = this.resourceLoader.getDescendants(Object.class, gluePath).iterator();
            while (i$.hasNext()) {
                Class glueCodeClass;
                for (glueCodeClass = (Class)i$.next(); glueCodeClass != null && glueCodeClass != Object.class && !Utils.isInstantiable((Class)glueCodeClass); glueCodeClass = glueCodeClass.getSuperclass()) {
                }
                if (glueCodeClass == null) continue;
                for (Method method : glueCodeClass.getMethods()) {
                    this.scan(javaBackend, method, glueCodeClass);
                }
            }
        }
    }

    public void scan(JavaBackend javaBackend, Method method, Class<?> glueCodeClass) {
        for (Class<? extends Annotation> cucumberAnnotationClass : this.cucumberAnnotationClasses) {
            Annotation annotation = method.getAnnotation(cucumberAnnotationClass);
            if (annotation == null || annotation.annotationType().equals(Order.class)) continue;
            if (!method.getDeclaringClass().isAssignableFrom(glueCodeClass)) {
                throw new CucumberException(String.format("%s isn't assignable from %s", method.getDeclaringClass(), glueCodeClass));
            }
            if (!glueCodeClass.equals(method.getDeclaringClass())) {
                throw new CucumberException(String.format("You're not allowed to extend classes that define Step Definitions or hooks. %s extends %s", glueCodeClass, method.getDeclaringClass()));
            }
            if (this.isHookAnnotation(annotation)) {
                javaBackend.addHook(annotation, method);
                continue;
            }
            if (!this.isStepdefAnnotation(annotation)) continue;
            javaBackend.addStepDefinition(annotation, method);
        }
    }

    private Collection<Class<? extends Annotation>> findCucumberAnnotationClasses() {
        return this.resourceLoader.getAnnotations("cucumber.annotation");
    }

    private boolean isHookAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(Before.class) || annotationClass.equals(After.class);
    }

    private boolean isStepdefAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefAnnotation.class) != null;
    }
}

