/*
 * Decompiled with CFR 0.152.
 */
package cucumber.deps.com.thoughtworks.xstream.converters.reflection;

import cucumber.deps.com.thoughtworks.xstream.converters.MarshallingContext;
import cucumber.deps.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import cucumber.deps.com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import cucumber.deps.com.thoughtworks.xstream.core.ClassLoaderReference;
import cucumber.deps.com.thoughtworks.xstream.core.JVM;
import cucumber.deps.com.thoughtworks.xstream.core.util.Types;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cucumber.deps.com.thoughtworks.xstream.mapper.Mapper;
import java.io.Serializable;

public class LambdaConverter
extends SerializableConverter {
    public LambdaConverter(Mapper mapper, ReflectionProvider reflectionProvider, ClassLoaderReference classLoaderReference) {
        super(mapper, reflectionProvider, classLoaderReference);
    }

    @Override
    public boolean canConvert(Class type) {
        return Types.isLambdaType(type) && (JVM.canCreateDerivedObjectOutputStream() || !Serializable.class.isAssignableFrom(type));
    }

    @Override
    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (original instanceof Serializable) {
            super.marshal(original, writer, context);
        }
    }
}

