/*
 * Decompiled with CFR 0.152.
 */
package gherkin.compiler;

import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.Location;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import java.util.ArrayList;
import java.util.List;
import pickles.Pickle;
import pickles.PickleArgument;
import pickles.PickleLocation;
import pickles.PickleStep;
import pickles.PickleString;
import pickles.PickleTable;
import pickles.PickleTag;

public class Compiler {
    public List<Pickle> compile(Feature feature) {
        ArrayList<Pickle> pickles = new ArrayList<Pickle>();
        ArrayList<PickleStep> backgroundSteps = new ArrayList<PickleStep>();
        GherkinDialect dialect = new GherkinDialectProvider().getDialect(feature.getLanguage(), null);
        this.addBackgroundSteps(feature, backgroundSteps);
        List<PickleTag> featureTags = this.pickle(feature.getTags());
        for (ScenarioDefinition scenarioDefinition : feature.getScenarioDefinitions()) {
            if (scenarioDefinition instanceof Scenario) {
                this.addScenarioPickles(pickles, backgroundSteps, (Scenario)scenarioDefinition, featureTags);
                continue;
            }
            this.addScenarioOutlinePickles(pickles, backgroundSteps, dialect, (ScenarioOutline)scenarioDefinition, featureTags);
        }
        return pickles;
    }

    private void addScenarioPickles(List<Pickle> pickles, List<PickleStep> backgroundSteps, Scenario scenario, List<PickleTag> featureTags) {
        ArrayList<PickleTag> scenarioTags = new ArrayList<PickleTag>(featureTags);
        scenarioTags.addAll(this.pickle(scenario.getTags()));
        String testCaseName = scenario.getKeyword() + ": " + scenario.getName();
        Pickle pickle = new Pickle(testCaseName, backgroundSteps, scenarioTags, this.pickle(scenario.getLocation()));
        for (Step step : scenario.getSteps()) {
            PickleArgument pickledArgument = this.getPickledArgument(step, null, null);
            PickleStep pickleStep = new PickleStep(step.getText(), pickledArgument, this.pickle(step.getLocation()));
            pickle.addTestStep(pickleStep);
        }
        pickles.add(pickle);
    }

    private void addScenarioOutlinePickles(List<Pickle> pickles, List<PickleStep> backgroundSteps, GherkinDialect dialect, ScenarioOutline scenarioOutline, List<PickleTag> featureTags) {
        ArrayList<PickleTag> scenarioOutlineTags = new ArrayList<PickleTag>(featureTags);
        scenarioOutlineTags.addAll(this.pickle(scenarioOutline.getTags()));
        for (Examples examples : scenarioOutline.getExamples()) {
            ArrayList<PickleTag> examplesTags = new ArrayList<PickleTag>(scenarioOutlineTags);
            examplesTags.addAll(this.pickle(examples.getTags()));
            TableRow header = examples.getTableHeader();
            for (TableRow values : examples.getTableBody()) {
                String scenarioName = this.interpolate(scenarioOutline.getName(), examples.getTableHeader(), values);
                String testCaseName = dialect.getScenarioKeywords().get(0) + ": " + scenarioName;
                Pickle pickle = new Pickle(testCaseName, backgroundSteps, examplesTags, this.pickle(scenarioOutline.getLocation()));
                for (Step step : scenarioOutline.getSteps()) {
                    PickleArgument pickledArgument = this.getPickledArgument(step, header, values);
                    String stepName = this.interpolate(step.getText(), examples.getTableHeader(), values);
                    PickleStep pickleStep = new PickleStep(stepName, pickledArgument, this.pickle(step.getLocation()), this.pickle(values.getLocation()));
                    pickle.addTestStep(pickleStep);
                }
                pickles.add(pickle);
            }
        }
    }

    private void addBackgroundSteps(Feature feature, List<PickleStep> backgroundSteps) {
        if (feature.getBackground() != null) {
            for (Step step : feature.getBackground().getSteps()) {
                PickleArgument pickledArgument = this.getPickledArgument(step, null, null);
                backgroundSteps.add(new PickleStep(step.getText(), pickledArgument, this.pickle(step.getLocation())));
            }
        }
    }

    private PickleArgument getPickledArgument(Step step, TableRow header, TableRow values) {
        if (step.getArgument() instanceof DataTable) {
            ArrayList<List<String>> table = new ArrayList<List<String>>();
            for (TableRow tableRow : ((DataTable)step.getArgument()).getRows()) {
                ArrayList<String> row = new ArrayList<String>();
                table.add(row);
                for (TableCell tableCell : tableRow.getCells()) {
                    String cell = this.interpolate(tableCell.getValue(), header, values);
                    row.add(cell);
                }
            }
            return new PickleTable(table);
        }
        if (step.getArgument() instanceof DocString) {
            String value = ((DocString)step.getArgument()).getContent();
            return new PickleString(this.interpolate(value, header, values));
        }
        return null;
    }

    private String interpolate(String name, TableRow variables, TableRow values) {
        int col = 0;
        if (variables != null) {
            for (TableCell headerCell : variables.getCells()) {
                TableCell valueCell = values.getCells().get(col++);
                String header = headerCell.getValue();
                String value = valueCell.getValue();
                name = name.replace("<" + header + ">", value);
            }
        }
        return name;
    }

    private List<PickleTag> pickle(List<Tag> tags) {
        ArrayList<PickleTag> pickleTags = new ArrayList<PickleTag>(tags.size());
        for (Tag tag : tags) {
            pickleTags.add(this.pickle(tag));
        }
        return pickleTags;
    }

    private PickleTag pickle(Tag tag) {
        return new PickleTag(tag.getName(), this.pickle(tag.getLocation()));
    }

    private PickleLocation pickle(Location location) {
        return new PickleLocation(location.getLine(), location.getColumn());
    }
}

