/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.stringsimilarity.ShingleBased;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringDistance;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import java.util.Arrays;

public class Cosine
extends ShingleBased
implements NormalizedStringDistance,
NormalizedStringSimilarity {
    public static void main(String[] args) {
        Cosine cos = new Cosine(3);
        System.out.println(cos.similarity("ABC", "ABCE"));
        cos = new Cosine(2);
        System.out.println(cos.similarity("ABAB", "BAB"));
    }

    public Cosine(int k) {
        super(k);
    }

    public Cosine() {
    }

    public double similarity(String s1, String s2) {
        KShingling ks = new KShingling(this.k);
        int[] profile1 = ks.getArrayProfile(s1);
        int[] profile2 = ks.getArrayProfile(s2);
        return Cosine.dotProduct(profile1, profile2) / (Cosine.norm(profile1) * Cosine.norm(profile2));
    }

    protected static double norm(int[] profile) {
        double agg = 0.0;
        for (int v : profile) {
            agg += (double)(v * v);
        }
        return Math.sqrt(agg);
    }

    protected static double dotProduct(int[] profile1, int[] profile2) {
        int length = Math.max(profile1.length, profile2.length);
        profile1 = Arrays.copyOf(profile1, length);
        profile2 = Arrays.copyOf(profile2, length);
        double agg = 0.0;
        for (int i = 0; i < length; ++i) {
            agg += (double)(profile1[i] * profile2[i]);
        }
        return agg;
    }

    public double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }
}

