/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseIntegerVector
implements Serializable {
    protected int[] keys;
    protected int[] values;
    protected int size = 0;

    public SparseIntegerVector(int size) {
        this.keys = new int[size];
        this.values = new int[size];
    }

    public SparseIntegerVector() {
        this(20);
    }

    public SparseIntegerVector(HashMap<Integer, Integer> hashmap) {
        this(hashmap.size());
        TreeSet<Integer> sorted_keys = new TreeSet<Integer>(hashmap.keySet());
        Iterator i$ = sorted_keys.iterator();
        while (i$.hasNext()) {
            int key;
            this.keys[this.size] = key = ((Integer)i$.next()).intValue();
            this.values[this.size] = hashmap.get(key);
            ++this.size;
        }
    }

    public SparseIntegerVector(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0) continue;
            ++this.size;
        }
        this.keys = new int[this.size];
        this.values = new int[this.size];
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0) continue;
            this.keys[j] = i;
            this.values[j] = array[i];
            ++j;
        }
    }

    public double cosineSimilarity(SparseIntegerVector other) {
        double den = this.norm() * other.norm();
        double agg = 0.0;
        int i = 0;
        int j = 0;
        while (i < this.keys.length && j < other.keys.length) {
            int k1 = this.keys[i];
            int k2 = other.keys[j];
            if (k1 == k2) {
                agg += (double)(this.values[i] * other.values[j]) / den;
                ++i;
                ++j;
                continue;
            }
            if (k1 < k2) {
                ++i;
                continue;
            }
            ++j;
        }
        return agg;
    }

    public double dotProduct(SparseIntegerVector other) {
        double agg = 0.0;
        int i = 0;
        int j = 0;
        while (i < this.keys.length && j < other.keys.length) {
            int k1 = this.keys[i];
            int k2 = other.keys[j];
            if (k1 == k2) {
                agg += (double)(this.values[i] * other.values[j]);
                ++i;
                ++j;
                continue;
            }
            if (k1 < k2) {
                ++i;
                continue;
            }
            ++j;
        }
        return agg;
    }

    public double dotProduct(double[] other) {
        double agg = 0.0;
        for (int i = 0; i < this.keys.length; ++i) {
            agg += other[this.keys[i]] * (double)this.values[i];
        }
        return agg;
    }

    public double norm() {
        double agg = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            agg += (double)(this.values[i] * this.values[i]);
        }
        return Math.sqrt(agg);
    }

    public double jaccard(SparseIntegerVector other) {
        int intersection = this.intersection(other);
        return (double)intersection / (double)(this.size + other.size - intersection);
    }

    public int union(SparseIntegerVector other) {
        return this.size + other.size - this.intersection(other);
    }

    public int intersection(SparseIntegerVector other) {
        int agg = 0;
        int i = 0;
        int j = 0;
        while (i < this.keys.length && j < other.keys.length) {
            int k1 = this.keys[i];
            int k2 = other.keys[j];
            if (k1 == k2) {
                ++agg;
                ++i;
                ++j;
                continue;
            }
            if (k1 < k2) {
                ++i;
                continue;
            }
            ++j;
        }
        return agg;
    }

    public String toString() {
        String r = "";
        for (int i = 0; i < this.size; ++i) {
            r = r + this.keys[i] + ":" + this.values[i] + " ";
        }
        return r;
    }

    public double qgram(SparseIntegerVector other) {
        double agg = 0.0;
        int i = 0;
        int j = 0;
        while (i < this.keys.length && j < other.keys.length) {
            int k1 = this.keys[i];
            int k2 = other.keys[j];
            if (k1 == k2) {
                agg += (double)Math.abs(this.values[i] - other.values[j]);
                ++i;
                ++j;
                continue;
            }
            if (k1 < k2) {
                agg += (double)Math.abs(this.values[i]);
                ++i;
                continue;
            }
            agg += (double)Math.abs(other.values[j]);
            ++j;
        }
        while (i < this.keys.length) {
            agg += (double)Math.abs(this.values[i]);
            ++i;
        }
        while (j < other.keys.length) {
            agg += (double)Math.abs(other.values[j]);
            ++j;
        }
        return agg;
    }

    public int size() {
        return this.size;
    }
}

