/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.ComplexFind;
import io.appium.java_client.ErrorCodesMobile;
import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.FindsByIosUIAutomation;
import io.appium.java_client.MobileDriver;
import io.appium.java_client.MobileElement;
import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.NetworkConnectionSetting;
import io.appium.java_client.TouchAction;
import io.appium.java_client.internal.JsonToMobileElementConverter;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.HttpVerb;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

public class AppiumDriver
extends RemoteWebDriver
implements MobileDriver,
ContextAware,
Rotatable,
FindsByIosUIAutomation,
FindsByAndroidUIAutomator,
FindsByAccessibilityId {
    private static final ErrorHandler errorHandler = new ErrorHandler((ErrorCodes)new ErrorCodesMobile(), true);
    private URL remoteAddress;
    private ComplexFind complexFind;

    public AppiumDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, desiredCapabilities);
        this.setElementConverter(new JsonToMobileElementConverter(this));
        this.remoteAddress = remoteAddress;
        this.complexFind = new ComplexFind(this);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"reset", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/reset")).put((Object)"getStrings", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/strings")).put((Object)"keyEvent", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/keyevent")).put((Object)"currentActivity", (Object)AppiumDriver.getC("/session/:sessionId/appium/device/current_activity")).put((Object)"setValue", (Object)AppiumDriver.postC("/session/:sessionId/appium/element/:id/value")).put((Object)"pullFile", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/pull_file")).put((Object)"pullFolder", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/pull_folder")).put((Object)"hideKeyboard", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/hide_keyboard")).put((Object)"pushFile", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/push_file")).put((Object)"runAppInBackground", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/background")).put((Object)"performTouchAction", (Object)AppiumDriver.postC("/session/:sessionId/touch/perform")).put((Object)"performMultiTouch", (Object)AppiumDriver.postC("/session/:sessionId/touch/multi/perform")).put((Object)"isAppInstalled", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/app_installed")).put((Object)"installApp", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/install_app")).put((Object)"removeApp", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/remove_app")).put((Object)"launchApp", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/launch")).put((Object)"closeApp", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/close")).put((Object)"endTestCoverage", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/end_test_coverage")).put((Object)"lock", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/lock")).put((Object)"shake", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/shake")).put((Object)"complexFind", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/complex_find")).put((Object)"openNotifications", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/open_notifications")).put((Object)"getNetworkConnection", (Object)AppiumDriver.getC("/session/:sessionId/network_connection")).put((Object)"setNetworkConnection", (Object)AppiumDriver.postC("/session/:sessionId/network_connection"));
        ImmutableMap mobileCommands = builder.build();
        HttpCommandExecutor mobileExecutor = new HttpCommandExecutor((Map)mobileCommands, remoteAddress);
        super.setCommandExecutor((CommandExecutor)mobileExecutor);
        super.setErrorHandler(errorHandler);
    }

    @Override
    public Response execute(String driverCommand, Map<String, ?> parameters) {
        return super.execute(driverCommand, parameters);
    }

    protected Response execute(String command) {
        return this.execute(command, (Map<String, ?>)ImmutableMap.of());
    }

    public void resetApp() {
        this.execute("reset");
    }

    public String getAppStrings() {
        Response response = this.execute("getStrings");
        return response.getValue().toString();
    }

    public String getAppStrings(String language) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"language", (Object)language);
        ImmutableMap parameters = builder.build();
        Response response = this.execute("getStrings", (Map<String, ?>)parameters);
        return response.getValue().toString();
    }

    public void sendKeyEvent(int key) {
        this.sendKeyEvent(key, null);
    }

    public void sendKeyEvent(int key, Integer metastate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"keycode", (Object)key);
        if (metastate != null) {
            builder.put((Object)"metastate", (Object)metastate);
        }
        ImmutableMap parameters = builder.build();
        this.execute("keyEvent", (Map<String, ?>)parameters);
    }

    public String currentActivity() {
        Response response = this.execute("currentActivity");
        return response.getValue().toString();
    }

    public byte[] pullFile(String remotePath) {
        Response response = this.execute("pullFile", (Map<String, ?>)ImmutableMap.of((Object)"path", (Object)remotePath));
        String base64String = response.getValue().toString();
        return DatatypeConverter.parseBase64Binary((String)base64String);
    }

    public void pushFile(String remotePath, byte[] base64Data) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"path", (Object)remotePath).put((Object)"data", (Object)base64Data);
        this.execute("pushFile", (Map<String, ?>)builder.build());
    }

    public byte[] pullFolder(String remotePath) {
        Response response = this.execute("pullFolder", (Map<String, ?>)ImmutableMap.of((Object)"path", (Object)remotePath));
        String base64String = response.getValue().toString();
        return DatatypeConverter.parseBase64Binary((String)base64String);
    }

    public void hideKeyboard() {
        this.execute("hideKeyboard");
    }

    public void hideKeyboard(String strategy, String keyName) {
        ImmutableMap parameters = ImmutableMap.of((Object)"strategy", (Object)strategy);
        if (keyName != null) {
            parameters = ImmutableMap.of((Object)"key", (Object)keyName);
        }
        this.execute("hideKeyboard", (Map<String, ?>)parameters);
    }

    public void hideKeyboard(String keyName) {
        this.execute("hideKeyboard", (Map<String, ?>)ImmutableMap.of((Object)"keyName", (Object)keyName));
    }

    public void runAppInBackground(int seconds) {
        this.execute("runAppInBackground", (Map<String, ?>)ImmutableMap.of((Object)"seconds", (Object)seconds));
    }

    public void openNotifications() {
        this.execute("openNotifications");
    }

    @Override
    public TouchAction performTouchAction(TouchAction touchAction) {
        ImmutableMap<String, ImmutableList> parameters = touchAction.getParameters();
        touchAction.clearParameters();
        this.execute("performTouchAction", (Map<String, ?>)parameters);
        return touchAction;
    }

    @Override
    public void performMultiTouchAction(MultiTouchAction multiAction) {
        ImmutableMap parameters = multiAction.getParameters();
        this.execute("performMultiTouch", (Map<String, ?>)parameters);
    }

    public void tap(int fingers, WebElement element, int duration) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        for (int i = 0; i < fingers; ++i) {
            multiTouch.add(this.createTap(element, duration));
        }
        multiTouch.perform();
    }

    public void tap(int fingers, int x, int y, int duration) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        for (int i = 0; i < fingers; ++i) {
            multiTouch.add(this.createTap(x, y, duration));
        }
        multiTouch.perform();
    }

    public void swipe(int startx, int starty, int endx, int endy, int duration) {
        TouchAction touchAction = new TouchAction(this);
        touchAction.press(startx, starty).waitAction(duration).moveTo(endx, endy).release();
        touchAction.perform();
    }

    public void pinch(WebElement el) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        Dimension dimensions = el.getSize();
        Point upperLeft = el.getLocation();
        Point center = new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
        TouchAction action0 = new TouchAction(this).press(el, center.getX(), center.getY() - 100).moveTo(el).release();
        TouchAction action1 = new TouchAction(this).press(el, center.getX(), center.getY() + 100).moveTo(el).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    public void pinch(int x, int y) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        TouchAction action0 = new TouchAction(this).press(x, y - 100).moveTo(x, y).release();
        TouchAction action1 = new TouchAction(this).press(x, y + 100).moveTo(x, y).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    public void zoom(WebElement el) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        Dimension dimensions = el.getSize();
        Point upperLeft = el.getLocation();
        Point center = new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
        TouchAction action0 = new TouchAction(this).press(el).moveTo(el, center.getX(), center.getY() - 100).release();
        TouchAction action1 = new TouchAction(this).press(el).moveTo(el, center.getX(), center.getY() + 100).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    public void zoom(int x, int y) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        TouchAction action0 = new TouchAction(this).press(x, y).moveTo(x, y - 100).release();
        TouchAction action1 = new TouchAction(this).press(x, y).moveTo(x, y + 100).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    public WebElement getNamedTextField(String name) {
        MobileElement element = (MobileElement)this.findElementByAccessibilityId(name);
        if (element.getTagName() != "TextField") {
            return element.findElementByAccessibilityId(name);
        }
        return element;
    }

    public boolean isAppInstalled(String bundleId) {
        Response response = this.execute("isAppInstalled", (Map<String, ?>)ImmutableMap.of((Object)"bundleId", (Object)bundleId));
        return Boolean.parseBoolean(response.getValue().toString());
    }

    public void installApp(String appPath) {
        this.execute("installApp", (Map<String, ?>)ImmutableMap.of((Object)"appPath", (Object)appPath));
    }

    public void removeApp(String bundleId) {
        this.execute("removeApp", (Map<String, ?>)ImmutableMap.of((Object)"bundleId", (Object)bundleId));
    }

    public void launchApp() {
        this.execute("launchApp");
    }

    public void closeApp() {
        this.execute("closeApp");
    }

    public void endTestCoverage(String intent, String path) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"intent", (Object)intent).put((Object)"path", (Object)path);
        this.execute("endTestCoverage", (Map<String, ?>)builder.build());
    }

    public void lockScreen(int seconds) {
        this.execute("lock", (Map<String, ?>)ImmutableMap.of((Object)"seconds", (Object)seconds));
    }

    public void shake() {
        this.execute("shake");
    }

    public MobileElement complexFind(String complex) {
        return this.complexFind.execute(complex);
    }

    public MobileElement scrollTo(String text) {
        return this.complexFind.scrollTo(text);
    }

    public MobileElement scrollToExact(String text) {
        return this.complexFind.scrollToExact(text);
    }

    public NetworkConnectionSetting getNetworkConnection() {
        Response response = this.execute("getNetworkConnection");
        return new NetworkConnectionSetting(Integer.parseInt(response.getValue().toString()));
    }

    public void setNetworkConnection(NetworkConnectionSetting connection) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"name", (Object)"network_connection").put((Object)"parameters", (Object)ImmutableMap.of((Object)"type", (Object)connection.value));
        this.execute("setNetworkConnection", (Map<String, ?>)builder.build());
    }

    public WebDriver context(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Must supply a context name");
        }
        this.execute("switchToContext", (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)name));
        return this;
    }

    public Set<String> getContextHandles() {
        Response response = this.execute("getContextHandles");
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, (Throwable)ex);
        }
    }

    public String getContext() {
        String contextName = String.valueOf(this.execute("getCurrentContextHandle").getValue());
        if (contextName.equals("null")) {
            return null;
        }
        return contextName;
    }

    public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", (Map<String, ?>)ImmutableMap.of((Object)"orientation", (Object)orientation.value().toUpperCase()));
    }

    public ScreenOrientation getOrientation() {
        Response response = this.execute("getScreenOrientation");
        String orientation = response.getValue().toString().toLowerCase();
        if (orientation.equals(ScreenOrientation.LANDSCAPE.value())) {
            return ScreenOrientation.LANDSCAPE;
        }
        if (orientation.equals(ScreenOrientation.PORTRAIT.value())) {
            return ScreenOrientation.PORTRAIT;
        }
        throw new WebDriverException("Unexpected orientation returned: " + orientation);
    }

    @Override
    public WebElement findElementByIosUIAutomation(String using) {
        return this.findElement("-ios uiautomation", using);
    }

    @Override
    public List<WebElement> findElementsByIosUIAutomation(String using) {
        return this.findElements("-ios uiautomation", using);
    }

    @Override
    public WebElement findElementByAndroidUIAutomator(String using) {
        return this.findElement("-android uiautomator", using);
    }

    @Override
    public List<WebElement> findElementsByAndroidUIAutomator(String using) {
        return this.findElements("-android uiautomator", using);
    }

    @Override
    public WebElement findElementByAccessibilityId(String using) {
        return this.findElement("accessibility id", using);
    }

    @Override
    public List<WebElement> findElementsByAccessibilityId(String using) {
        return this.findElements("accessibility id", using);
    }

    private TouchAction createTap(WebElement element, int duration) {
        TouchAction tap = new TouchAction(this);
        return tap.press(element).waitAction(duration).release();
    }

    private TouchAction createTap(int x, int y, int duration) {
        TouchAction tap = new TouchAction(this);
        return tap.press(x, y).waitAction(duration).release();
    }

    private static CommandInfo getC(String url) {
        return new CommandInfo(url, HttpVerb.GET);
    }

    private static CommandInfo postC(String url) {
        return new CommandInfo(url, HttpVerb.POST);
    }

    private static CommandInfo deleteC(String url) {
        return new CommandInfo(url, HttpVerb.DELETE);
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }
}

