/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.events;

import io.appium.java_client.events.DefaultAspect;
import io.appium.java_client.events.api.Listener;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.AbstractApplicationContext;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
class DefaultBeanConfiguration {
    public static final String COMPONENT_BEAN = "component";
    public static final String WEB_DRIVER_BEAN = "webdriver";
    private final List<Listener> listeners = new ArrayList<Listener>();
    private WebDriver driver;
    private AbstractApplicationContext context;

    DefaultBeanConfiguration() {
    }

    @Scope(value="prototype")
    @Bean(name={"webdriver"})
    public <T extends WebDriver> T getListenableWebdriver(T driver, List<Listener> listeners, AbstractApplicationContext context) {
        this.driver = driver;
        this.listeners.addAll(listeners);
        this.context = context;
        return driver;
    }

    @Scope(value="prototype")
    @Bean(name={"webdriverAspect"})
    public DefaultAspect getAspect() {
        DefaultAspect aspect = new DefaultAspect(this.context, this.driver);
        aspect.add(this.listeners);
        return aspect;
    }

    @Scope(value="prototype")
    @Bean(name={"component"})
    public Object getComponent(Object component) {
        return component;
    }
}

