/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.appium.java_client.internal.ElementMap;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

public class JsonToMobileElementConverter
extends JsonToWebElementConverter {
    private static final String AUTOMATION_NAME_PARAMETER = "automationName";
    private static final String PLATFORM_NAME_PARAMETER = "platformName";
    protected final RemoteWebDriver driver;
    private final String automation;
    private final String platform;

    public JsonToMobileElementConverter(RemoteWebDriver driver, Map<String, Object> sessionParameters) {
        super(driver);
        this.driver = driver;
        this.automation = String.valueOf(sessionParameters.get(AUTOMATION_NAME_PARAMETER)).toLowerCase();
        this.platform = String.valueOf(sessionParameters.get(PLATFORM_NAME_PARAMETER)).toLowerCase();
    }

    public Object apply(Object result) {
        if (result instanceof Collection) {
            Collection results = (Collection)result;
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)results, (Function)this));
        }
        if (result instanceof Map) {
            Map resultAsMap = (Map)result;
            if (resultAsMap.containsKey("ELEMENT")) {
                RemoteWebElement element = this.newMobileElement();
                element.setId(String.valueOf(resultAsMap.get("ELEMENT")));
                element.setFileDetector(this.driver.getFileDetector());
                return element;
            }
            return Maps.transformValues((Map)resultAsMap, (Function)this);
        }
        if (result instanceof Number) {
            if (result instanceof Float || result instanceof Double) {
                return ((Number)result).doubleValue();
            }
            return ((Number)result).longValue();
        }
        return result;
    }

    protected RemoteWebElement newMobileElement() {
        Class<? extends RemoteWebElement> target = ElementMap.getElementClass(this.platform, this.automation);
        try {
            Constructor<? extends RemoteWebElement> constructor = target.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            RemoteWebElement result = constructor.newInstance(new Object[0]);
            result.setParent(this.driver);
            return result;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }
}

